/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.volume;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.volume.Volume;

public abstract class VolumeFactory {
    public abstract Volume makeVolume(String var1, boolean var2, long var3, int var5, long var6, boolean var8);

    public Volume makeVolume(String file, boolean readOnly) {
        return this.makeVolume(file, readOnly, 0L);
    }

    public Volume makeVolume(String file, boolean readOnly, long fileLockWait) {
        return this.makeVolume(file, readOnly, fileLockWait, 20, 0L, false);
    }

    @NotNull
    public abstract boolean exists(@Nullable String var1);

    @NotNull
    public static VolumeFactory wrap(final @NotNull Volume volume2, final boolean exists) {
        return new VolumeFactory(){

            @Override
            public Volume makeVolume(String file, boolean readOnly, long fileLockWait, int sliceShift, long initSize, boolean fixedSize) {
                return volume2;
            }

            @Override
            @NotNull
            public boolean exists(@Nullable String file) {
                return exists;
            }

            @Override
            public boolean handlesReadonly() {
                return false;
            }
        };
    }

    public abstract boolean handlesReadonly();
}

