/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dxf.io;

import java.util.Vector;
import org.gvsig.dxf.io.DxfGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DxfGroupVector
extends Vector<Object> {
    private static final long serialVersionUID = -3370601314380922368L;
    private static Logger logger = LoggerFactory.getLogger(DxfGroupVector.class);

    public boolean hasCode(int code) {
        DxfGroup grp = null;
        for (int i = 0; i < this.size(); ++i) {
            grp = (DxfGroup)this.get(i);
            if (grp.code != code) continue;
            return true;
        }
        return false;
    }

    public Object getData(int code) {
        DxfGroup grp = null;
        for (int i = 0; i < this.size(); ++i) {
            grp = (DxfGroup)this.get(i);
            if (grp.code != code) continue;
            return grp.data;
        }
        return null;
    }

    public String getDataAsString(int code) {
        return (String)this.getData(code);
    }

    public double getDataAsDouble(int code) {
        Double f = (Double)this.getData(code);
        if (f == null) {
            logger.warn(this.toString());
            return 0.0;
        }
        return f;
    }

    public int getDataAsInt(int code) {
        Integer i = (Integer)this.getData(code);
        if (i == null) {
            logger.warn(this.toString());
        }
        return i;
    }

    @Override
    public String toString() {
        String str = "DxfGroupVector[";
        DxfGroup grp = null;
        for (int i = 0; i < this.size(); ++i) {
            grp = (DxfGroup)this.get(i);
            str = str + "(" + grp.code + ":" + grp.data + "),";
        }
        return str;
    }
}

