/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dxf.px;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Vector;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.cresques.geo.Projected;
import org.cresques.geo.ViewPortData;
import org.cresques.px.Extent;
import org.gvsig.dxf.geo.Polygon2D;
import org.gvsig.dxf.geo.cover.Hoja;
import org.gvsig.dxf.px.PxObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PxContour
extends PxObj
implements Projected {
    private static Logger logger = LoggerFactory.getLogger(PxContour.class);
    static final Color colorBase = new Color(0, 64, 128, 255);
    static final Color fColorBase = new Color(64, 128, 192, 255);
    IProjection proj = null;
    protected String name;
    protected String fName;
    private Color fColor = fColorBase;
    private Color pc = colorBase;
    private Polygon2D polygon = null;

    public PxContour(Extent e, String fName, String name, IProjection proj) {
        this.fName = fName;
        this.name = name;
        this.proj = proj;
        Point2D[] v = new Point2D[]{proj.createPoint(e.minX(), e.minY()), proj.createPoint(e.maxX(), e.minY()), proj.createPoint(e.maxX(), e.maxY()), proj.createPoint(e.minX(), e.maxY())};
        this.setContour(v);
    }

    public PxContour(Hoja h) {
        this.name = h.getCode();
        this.setContour(h.getVertex());
    }

    public PxContour(Point2D[] v, String name) {
        this.name = name;
        this.setContour(v);
    }

    public void _PxContour(Point2D pt1, Point2D pt2, String fName, String name) {
        this.fName = fName;
        this.name = name;
        this.extent = new Extent(pt1, pt2);
    }

    public void _PxContour(Point2D[] v, String fName, String name) {
        this.fName = fName;
        this.name = name;
        this.setContour(v);
    }

    public IProjection getProjection() {
        return this.proj;
    }

    public void setProjection(IProjection p) {
        this.proj = p;
    }

    private void setContour(Point2D[] v) {
        this.extent = new Extent();
        this.polygon = new Polygon2D();
        for (int i = 0; i < v.length; ++i) {
            this.polygon.addPoint(v[i]);
            this.extent.add(v[i]);
        }
    }

    public Vector getVertex() {
        return this.polygon;
    }

    public Point2D[] getPtList() {
        Point2D[] v = new Point2D[this.polygon.size()];
        for (int i = 0; i < this.polygon.size(); ++i) {
            v[i] = (Point2D)this.polygon.get(i);
        }
        return v;
    }

    public String getName() {
        return this.name;
    }

    public Color c() {
        return this.pc;
    }

    public Color c(Color color) {
        this.pc = color;
        return this.pc;
    }

    public Color fillColor() {
        return this.fColor;
    }

    public Color fillColor(Color c) {
        this.fColor = c;
        return this.fColor;
    }

    public void setColor(Color color) {
        this.pc = color;
    }

    public Color getColor() {
        return this.pc;
    }

    public void setFillColor(Color color) {
        this.fColor = color;
    }

    public Color getFillColor() {
        return this.fColor;
    }

    public void reProject(ICoordTrans rp) {
        Polygon2D savePol = this.polygon;
        this.polygon = new Polygon2D();
        this.extent = new Extent();
        Point2D ptDest = null;
        for (int i = 0; i < savePol.size(); ++i) {
            ptDest = rp.getPDest().createPoint(0.0, 0.0);
            ptDest = rp.convert((Point2D)savePol.get(i), ptDest);
            this.polygon.addPoint(ptDest);
            this.extent.add(ptDest);
        }
        this.setProjection(rp.getPDest());
    }

    public void draw(Graphics2D g, ViewPortData vp, ICoordTrans rp) {
        IProjection saveProj = this.proj;
        Polygon2D savePol = this.polygon;
        Extent saveExt = this.extent;
        this.reProject(rp);
        this.draw(g, vp);
        this.polygon = savePol;
        this.extent = saveExt;
        this.proj = saveProj;
    }

    @Override
    public void draw(Graphics2D g, ViewPortData vp) {
        if (this.fColor != null) {
            g.setColor(this.fColor);
            if (this.polygon == null) {
                g.fillRect((int)this.extent.minX(), (int)this.extent.minY(), (int)this.extent.width(), (int)this.extent.height());
            } else {
                this.polygon.fill(g, vp);
            }
        }
        if (this.pc != null) {
            g.setColor(this.pc);
        }
        if (this.polygon != null) {
            this.polygon.draw(g, vp);
        } else {
            g.drawRect((int)this.extent.minX(), (int)this.extent.minY(), (int)this.extent.width(), (int)this.extent.height());
        }
        FontMetrics fm = g.getFontMetrics();
        int w = fm.stringWidth(this.name);
        int h = fm.getAscent();
        Point2D.Double pt = new Point2D.Double(this.extent.minX() + this.extent.width() / 2.0, this.extent.minY() + this.extent.height() / 2.0);
        try {
            Point2D.Double min = new Point2D.Double(this.extent.minX(), this.extent.minY());
            Point2D.Double max = new Point2D.Double(this.extent.maxX(), this.extent.minY());
            vp.mat.transform(min, min);
            vp.mat.transform(max, max);
            if (max.getX() - min.getX() < (double)w) {
                return;
            }
            vp.mat.transform(pt, pt);
            g.drawString(this.name, (int)pt.getX() - w / 2, (int)pt.getY() + h / 2);
        }
        catch (Exception e) {
            logger.warn("Error drawing", (Throwable)e);
        }
    }
}

