/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dxf.px;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.cresques.geo.ViewPortData;
import org.cresques.px.Extent;
import org.gvsig.dxf.px.Colored;
import org.gvsig.dxf.px.IPoint;
import org.gvsig.dxf.px.ISize;
import org.gvsig.dxf.px.PxObj;

public class PxRect
extends PxObj
implements IPoint,
ISize,
Colored {
    private int px = 0;
    private int py = 0;
    private int pw = 0;
    private int ph = 0;
    private Color pc;
    private Color filColor = null;

    public PxRect(IPoint p, ISize s, Color color, Color fc) {
        this.x(p.x());
        this.y(p.y());
        this.w(s.w());
        this.h(s.h());
        this.c(color);
        this.fillColor(fc);
        this.extent = new Extent((double)this.x(), (double)this.y(), (double)(this.x() + this.w()), (double)(this.y() + this.h()));
    }

    public PxRect(int x, int y, int w, int h, Color color, Color fc) {
        this.x(x);
        this.y(y);
        this.w(w);
        this.h(h);
        this.c(color);
        this.fillColor(fc);
        this.extent = new Extent((double)this.x(), (double)this.y(), (double)(this.x() + this.w()), (double)(this.y() + this.h()));
    }

    @Override
    public int x() {
        return this.px;
    }

    @Override
    public int x(int x) {
        this.px = x;
        return this.px;
    }

    @Override
    public int y() {
        return this.py;
    }

    @Override
    public int y(int y) {
        this.py = y;
        return this.py;
    }

    @Override
    public int w() {
        return this.pw;
    }

    @Override
    public int w(int w) {
        this.pw = w;
        return this.pw;
    }

    @Override
    public int h() {
        return this.ph;
    }

    @Override
    public int h(int h) {
        this.ph = h;
        return this.ph;
    }

    @Override
    public Color c() {
        return this.pc;
    }

    @Override
    public Color c(Color color) {
        this.pc = color;
        return this.pc;
    }

    public Color fillColor() {
        return this.filColor;
    }

    public Color fillColor(Color c) {
        this.filColor = c;
        return this.filColor;
    }

    @Override
    public void draw(Graphics2D g, ViewPortData vp) {
        AffineTransform msave = g.getTransform();
        g.setTransform(vp.mat);
        if (this.fillColor() != null) {
            g.setColor(this.fillColor());
            g.fillRect(this.x(), this.y(), this.w(), this.h());
        }
        g.setColor(this.c());
        g.drawRect(this.x(), this.y(), this.w(), this.h());
        g.setTransform(msave);
    }
}

