/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dxf.px.gml;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.cresques.geo.ViewPortData;
import org.cresques.px.Extent;
import org.gvsig.dxf.geo.Polygon2D;
import org.gvsig.dxf.px.gml.Geometry;
import org.gvsig.dxf.px.gml.Point3D;

public class Polygon
extends Geometry {
    static final Color colorBase = new Color(192, 64, 64);
    static final Color fColorBase = new Color(192, 64, 64, 16);
    public static int pointNr = 0;
    Polygon2D outPol = null;
    Polygon2D inPol = null;
    boolean outer = true;
    private Color fillColor = fColorBase;
    private Color color = colorBase;

    public Polygon() {
        this.outPol = new Polygon2D();
        this.inPol = new Polygon2D();
    }

    public boolean is3D() {
        if (this.isEmpty()) {
            return false;
        }
        Point2D x = this.get(0);
        return x instanceof Point3D;
    }

    @Override
    public void add(Point2D pt) {
        ++pointNr;
        if (this.outer) {
            this.outPol.addPoint(pt);
        } else {
            this.inPol.addPoint(pt);
        }
        this.extent.add(pt);
    }

    public boolean isEmpty() {
        if (this.outer && !this.outPol.isEmpty()) {
            return false;
        }
        return this.inPol.isEmpty();
    }

    @Override
    public Point2D get(int i) {
        if (this.outer) {
            return (Point2D)this.outPol.get(i);
        }
        return (Point2D)this.inPol.get(i);
    }

    public void remove(int i) {
        if (this.outer) {
            this.outPol.remove(i);
        } else {
            this.inPol.remove(i);
        }
    }

    @Override
    public int pointNr() {
        if (this.outer) {
            return this.outPol.size();
        }
        return this.inPol.size();
    }

    public void setOuterBoundary() {
        this.outer = true;
    }

    public void setInnerBoundary() {
        this.outer = false;
    }

    public Color c() {
        return this.color;
    }

    public Color c(Color color) {
        this.color = color;
        return color;
    }

    public Color fillColor() {
        return this.fillColor;
    }

    public Color fillColor(Color c) {
        this.fillColor = c;
        return this.fillColor;
    }

    @Override
    public IProjection getProjection() {
        return this.proj;
    }

    public void setProjection(IProjection p) {
        this.proj = p;
    }

    @Override
    public void reProject(ICoordTrans rp) {
        Polygon2D savePol = this.outPol;
        this.outPol = new Polygon2D();
        this.extent = new Extent();
        Point2D ptDest = null;
        for (int i = 0; i < savePol.size(); ++i) {
            ptDest = rp.getPDest().createPoint(0.0, 0.0);
            ptDest = rp.convert((Point2D)savePol.get(i), ptDest);
            this.outPol.addPoint(ptDest);
            this.extent.add(ptDest);
        }
        this.setProjection(rp.getPDest());
    }

    @Override
    public void draw(Graphics2D g, ViewPortData vp) {
        if (this.fillColor() != null) {
            g.setColor(this.fillColor());
            this.outPol.fill(g, vp);
        }
        g.setColor(this.c());
        this.outPol.draw(g, vp);
    }
}

