/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.app.mainplugin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.filedialogchooser.FileDialogChooser;
import org.gvsig.filedialogchooser.FileDialogChooserManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.VectorLayer;
import org.gvsig.json.Json;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.topology.app.mainplugin.AppTopologyServices;
import org.gvsig.topology.lib.api.TopologyLocator;
import org.gvsig.topology.lib.api.TopologyManager;
import org.gvsig.topology.lib.api.TopologyPlan;
import org.gvsig.topology.lib.api.TopologyServices;
import org.gvsig.topology.swing.api.JTopologyPlanProperties;
import org.gvsig.topology.swing.api.JTopologyReport;
import org.gvsig.topology.swing.api.TopologySwingLocator;
import org.gvsig.topology.swing.api.TopologySwingManager;
import org.gvsig.topology.swing.api.TopologySwingServices;

public class TopologyExtension
extends Extension {
    public static final String TOPOLOGYPLAN_FILE_EXTENSION = "gvtoplan";

    public void initialize() {
    }

    public void postInitialize() {
        AppTopologyServices services = new AppTopologyServices();
        TopologyManager manager = TopologyLocator.getTopologyManager();
        manager.setDefaultServices((TopologyServices)services);
        TopologySwingManager swingManager = TopologySwingLocator.getTopologySwingManager();
        swingManager.setDefaultServices((TopologySwingServices)services);
        IconThemeHelper.registerIcon((String)"topology", (String)"topology-plan", (String)"document-view-tree-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"topology", (String)"topology-plan", (String)"topology-tree-folder", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"topology", (String)"topology-plan", (String)"topology-tree-project", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"tools-topology-checklayer", (Object)((Object)this));
        ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        cfgActionsManager.addConfigurableAction("TopologyPlanPropertiesPanel", (Action)new SaveTopologyPlan());
        cfgActionsManager.addConfigurableAction("TopologyPlanPropertiesPanel", (Action)new LoadTopologyPlan());
    }

    public void execute(String action) {
        if (StringUtils.equalsIgnoreCase((String)"tools-topology-create-or-modify", (String)action)) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ApplicationManager application = ApplicationLocator.getManager();
            TopologyManager manager = TopologyLocator.getTopologyManager();
            TopologySwingManager swingManager = TopologySwingLocator.getTopologySwingManager();
            WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            JTopologyPlanProperties panel = swingManager.createJTopologyPlan();
            TopologyPlan plan = TopologyExtension.getCurrentTopologyPlan();
            if (plan == null) {
                plan = manager.createTopologyPlan();
            }
            panel.put(plan);
            Dialog dlg = winManager.createDialog(panel.asJComponent(), i18n.getTranslation("_Topology_plan"), null, 7);
            dlg.setButtonLabel(4, i18n.getTranslation("_Execute"));
            dlg.addActionListener(e -> {
                switch (dlg.getAction()) {
                    case 1: {
                        TopologyPlan plan1 = panel.fetch(null);
                        TopologyExtension.setCurrentTopologyPlan(plan1);
                        break;
                    }
                    case 4: {
                        TopologyPlan plan1 = panel.fetch(null);
                        TopologyExtension.setCurrentTopologyPlan(plan1);
                        JTopologyReport jreport = swingManager.createJTopologyReport(plan1);
                        jreport.put(plan1);
                        winManager.showWindow(jreport.asJComponent(), i18n.getTranslation("_Topology_plan_error_inspector") + " (" + plan1.getName() + ")", WindowManager.MODE.TOOL);
                        Thread th = new Thread(() -> plan1.execute(), "TopologyPlan-" + plan1.getName());
                        th.start();
                    }
                }
            });
            dlg.show(WindowManager.MODE.WINDOW);
        } else if (StringUtils.equalsIgnoreCase((String)"tools-topology-execute", (String)action)) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            TopologySwingManager swingManager = TopologySwingLocator.getTopologySwingManager();
            WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            TopologyPlan plan = TopologyExtension.getCurrentTopologyPlan();
            if (plan == null) {
                return;
            }
            JTopologyReport panel = swingManager.createJTopologyReport(plan);
            panel.put(plan);
            winManager.showWindow(panel.asJComponent(), ToolsSwingUtils.makeTitle((String)"_Topology_plan_error_inspector", (String)plan.getName(), null), WindowManager.MODE.TOOL);
            Thread th = new Thread(() -> plan.execute(), "TopologyPlan-" + plan.getName());
            th.start();
        } else if (StringUtils.equalsIgnoreCase((String)"tools-topology-checklayer", (String)action)) {
            this.checkCurrentLayer();
        }
    }

    private static String getCurrentTopologyPlanAsJson() {
        ApplicationManager application = ApplicationLocator.getManager();
        Project project = application.getCurrentProject();
        String jsonPlan = (String)project.getProperty("TopologyPlan");
        return jsonPlan;
    }

    private static boolean setCurrentTopologyPlan(String jsonPlan) {
        ApplicationManager application = ApplicationLocator.getManager();
        Project project = application.getCurrentProject();
        project.setProperty("TopologyPlan", (Object)jsonPlan);
        return true;
    }

    public static TopologyPlan getCurrentTopologyPlan() {
        String jsonPlan_s = TopologyExtension.getCurrentTopologyPlanAsJson();
        if (StringUtils.isBlank((String)jsonPlan_s)) {
            return null;
        }
        TopologyPlan plan = null;
        TopologyManager manager = TopologyLocator.getTopologyManager();
        plan = manager.createTopologyPlan();
        try {
            plan.fromJson(Json.createObject((String)jsonPlan_s));
        }
        catch (Exception ex) {
            logger.warn("Can't retrieve topology plan from json.\nPlan=" + jsonPlan_s, (Throwable)ex);
            plan = manager.createTopologyPlan();
        }
        return plan;
    }

    public static boolean setCurrentTopologyPlan(TopologyPlan plan) {
        return TopologyExtension.setCurrentTopologyPlan(plan.toJson().toString());
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    private void checkCurrentLayer() {
        FLayer[] activeLayers;
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            application.messageDialog("There must be an active layer in the active View.", "Check geometries", 2);
        }
        if ((activeLayers = viewdoc.getMapContext().getLayers().getActives()) == null || activeLayers.length != 1 || !(activeLayers[0] instanceof VectorLayer)) {
            application.messageDialog("There must be an active vector layer in the active View.", "Check geometries", 2);
            return;
        }
        VectorLayer layer = (VectorLayer)activeLayers[0];
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        TopologyManager manager = TopologyLocator.getTopologyManager();
        TopologySwingManager swingManager = TopologySwingLocator.getTopologySwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        AppTopologyServices services = new AppTopologyServices();
        manager.setDefaultServices((TopologyServices)services);
        swingManager.setDefaultServices((TopologySwingServices)services);
        TopologyPlan plan = manager.createTopologyPlan();
        plan.setName(i18n.getTranslation("_Validate_geometries"));
        plan.addDataSet(layer.getName(), (DataStore)layer.getFeatureStore());
        plan.addRule("GeometryIsValid", layer.getName(), null, 0.0);
        plan.addRule("GeometryMustNotBeNull", layer.getName(), null, 0.0);
        JTopologyReport panel = swingManager.createJTopologyReport(plan);
        panel.put(plan);
        winManager.showWindow(panel.asJComponent(), ToolsSwingUtils.makeTitle((String)"_Topology_plan_error_inspector", (String)plan.getName(), (String)layer.getName()), WindowManager.MODE.TOOL);
        Thread th = new Thread(() -> plan.execute(), "TopologyPlan-" + plan.getName());
        th.start();
    }

    private static class LoadTopologyPlan
    extends AbstractAction {
        public LoadTopologyPlan() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Load_topology_plan"));
            this.putValue("ActionCommandKey", "LoadTopologyPLanFromFile");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            JTopologyPlanProperties panel = (JTopologyPlanProperties)e.getSource();
            FileDialogChooserManager fileDislogs = ToolsUtilLocator.getFileDialogChooserManager();
            FileDialogChooser dialog = fileDislogs.create("TopologyPlan");
            dialog.setCurrentDirectory(null);
            dialog.setDialogTitle(i18n.getTranslation("_Select_topology_plan_file"));
            dialog.setMultiSelectionEnabled(false);
            dialog.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FilenameUtils.isExtension((String)f.getName(), (String)TopologyExtension.TOPOLOGYPLAN_FILE_EXTENSION);
                }

                @Override
                public String getDescription() {
                    return "Topology plan (gvtoplan)";
                }
            });
            int n = dialog.showOpenDialog((Component)panel.asJComponent());
            if (n == 0) {
                File file = dialog.getSelectedFile();
                try {
                    String fcontents = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                    TopologyManager manager = TopologyLocator.getTopologyManager();
                    TopologyPlan plan = manager.createTopologyPlan();
                    plan.fromJson(Json.createObject((String)fcontents));
                    panel.put(plan);
                }
                catch (IOException ex) {
                    logger.warn("Can't load topology plan", (Throwable)ex);
                    ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs.messageDialog(i18n.getTranslation("_Cant_load_topology_plan"), i18n.getTranslation("_Topology_plan"), 2);
                }
            }
        }
    }

    private static class SaveTopologyPlan
    extends AbstractAction {
        public SaveTopologyPlan() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Save_topology_plan"));
            this.putValue("ActionCommandKey", "SaveTopologyPLanToFile");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            JTopologyPlanProperties panel = (JTopologyPlanProperties)e.getSource();
            TopologyPlan plan = panel.fetch(null);
            FileDialogChooserManager fileDislogs = ToolsUtilLocator.getFileDialogChooserManager();
            FileDialogChooser dialog = fileDislogs.create("TopologyPlan");
            dialog.setCurrentDirectory(null);
            dialog.setDialogTitle(i18n.getTranslation("_Select_topology_plan_file"));
            dialog.setMultiSelectionEnabled(false);
            dialog.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().endsWith(",gvtoplan");
                }

                @Override
                public String getDescription() {
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    return i18n.getTranslation("_Topology_plan");
                }
            });
            int n = dialog.showSaveDialog((Component)panel.asJComponent());
            if (n == 0) {
                File file = dialog.getSelectedFile();
                if (FilenameUtils.indexOfExtension((String)file.getName()) < 0) {
                    file = new File(file.getAbsolutePath() + "." + TopologyExtension.TOPOLOGYPLAN_FILE_EXTENSION);
                }
                try {
                    String fcontents = plan.toJson().toString();
                    FileUtils.write((File)file, (CharSequence)fcontents, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException ex) {
                    logger.warn("Can't save topology plan", (Throwable)ex);
                    ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs.messageDialog(i18n.getTranslation("_Cant_save_topology_plan"), i18n.getTranslation("_Topology_plan"), 2);
                }
            }
        }
    }
}

