/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.georeferencing.swing.GeoreferencingLauncher;
import org.gvsig.raster.georeferencing.swing.GeoreferencingOptions;
import org.gvsig.raster.georeferencing.swing.GeoreferencingPanel;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingManager;
import org.gvsig.raster.georeferencing.swing.LayoutEnvironment;
import org.gvsig.raster.georeferencing.swing.control.GeorefControlPanel;
import org.gvsig.raster.georeferencing.swing.impl.LayoutEnvironmentImpl;
import org.gvsig.raster.georeferencing.swing.impl.control.GeorefControlPanelImpl;
import org.gvsig.raster.georeferencing.swing.impl.launcher.GeorefLauncherDialog;
import org.gvsig.raster.georeferencing.swing.impl.option.CellSizeDialog;
import org.gvsig.raster.georeferencing.swing.impl.option.GeorefOptionsDataModelImpl;
import org.gvsig.raster.georeferencing.swing.impl.option.GeorefOptionsDialog;
import org.gvsig.raster.georeferencing.swing.impl.view.ViewPanelImpl;
import org.gvsig.raster.georeferencing.swing.impl.view.ZoomPanelImpl;
import org.gvsig.raster.georeferencing.swing.impl.view.synchronize.SynchronizationViewImpl;
import org.gvsig.raster.georeferencing.swing.model.GeoreferencingOptionsDataModel;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.raster.georeferencing.swing.view.IViewRequestManager;
import org.gvsig.raster.georeferencing.swing.view.SynchronizedViews;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;
import org.gvsig.raster.swing.basepanel.ButtonsPanelListener;
import org.gvsig.raster.swing.pagedtable.PagedTable;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGeoreferencingSwingManager
implements GeoreferencingSwingManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultGeoreferencingSwingManager.class);
    private static final int SMALL_WINDOWS_HEIGHT = 140;
    private static final int SMALL_WINDOWS_WIDTH = 220;
    private I18nManager i18nmanager = ToolsLocator.getI18nManager();
    private GeoreferencingOptionsDataModel dataModel = null;
    private GeoreferencingPanelImpl georeferencingPanel;

    public GeoreferencingOptionsDataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new GeorefOptionsDataModelImpl();
        }
        return this.dataModel;
    }

    public String getTranslation(String key) {
        return this.i18nmanager.getTranslation(key);
    }

    public static String getText(Object parent, String key) {
        if (key == null) {
            return null;
        }
        String translation = Messages.getText((String)key, (boolean)false);
        if (translation != null) {
            return translation;
        }
        logger.debug("Can't find translation for ''{1}''.", (Object)key);
        return key;
    }

    public SynchronizedViews createSyncViews(GeoreferencingView[] views, IViewRequestManager[] viewMan, GeorefControlPanel control, PagedTable table, ToolListener listener) {
        SynchronizationViewImpl syncViews = new SynchronizationViewImpl(this.getDataModel().getGCPList(), listener);
        syncViews.setRequestsManager(viewMan[0], viewMan[1], viewMan[2], viewMan[3]);
        syncViews.setViews(views[0], views[1], views[2], views[3], table);
        syncViews.setControlPanel(control);
        syncViews.disableAllTools();
        return syncViews;
    }

    public GeorefControlPanel createGeorefControlPanel() {
        return new GeorefControlPanelImpl();
    }

    public GeoreferencingView createView(boolean showInfo, boolean minMaxUL, boolean rightSideButtons, ToolListener toolListener) {
        ViewPanelImpl v = new ViewPanelImpl(toolListener, rightSideButtons);
        v.setMinxMaxyUL(minMaxUL);
        v.setShowInfo(showInfo);
        return v;
    }

    public GeoreferencingView createZoom(boolean showInfo, boolean minMaxUL) {
        ZoomPanelImpl v = new ZoomPanelImpl();
        v.setMinxMaxyUL(minMaxUL);
        v.setShowInfo(showInfo);
        return v;
    }

    public GeoreferencingLauncher createWindowLauncher(List<String> viewList, int polynomialDegree) {
        return new GeorefLauncherDialog(viewList, polynomialDegree);
    }

    public GeoreferencingOptions createWindowOptions(int polynomialDegree, ButtonsPanelListener listener) {
        return new GeorefOptionsDialog(polynomialDegree, listener);
    }

    public JPanel createCellSizeWindow(ButtonsPanelListener listener) {
        return new CellSizeDialog(this.getDataModel(), listener);
    }

    public void createLayout(LayoutEnvironment env) {
        if (env.getViewBaseCartography() == null || env.getViewZoomBaseCartography() == null) {
            this.createLayoutWithoutReferenceMap(env);
        } else {
            this.createLayoutWithReferenceMap(env);
        }
    }

    public JPanel createLayoutWithReferenceMap(LayoutEnvironment env) {
        GeoreferencingPanelImpl mainPanel = new GeoreferencingPanelImpl();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        mainPanel.add((Component)env.getViewBaseCartography(), gbc);
        gbc.gridx = 1;
        mainPanel.add((Component)env.getViewRasterToGeoref(), gbc);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        mainPanel.add((Component)env.getControlBar(), gbc);
        gbc.gridy = 2;
        JPanel p = this.fixPanelWithReference(env.getTable(), env.getViewZoomBaseCartography(), env.getViewZoomRasterToGeoref());
        mainPanel.add((Component)p, gbc);
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        winManager.showWindow((JComponent)mainPanel, i18n.getTranslation("georeferencing"), WindowManager.MODE.WINDOW, Collections.singletonMap("maximized", true));
        this.georeferencingPanel = mainPanel;
        ToolsSwingUtils.addWindowClosedListener((JComponent)this.georeferencingPanel, e -> {
            this.georeferencingPanel = null;
        });
        return mainPanel;
    }

    public JPanel createLayoutWithoutReferenceMap(LayoutEnvironment env) {
        GeoreferencingPanelImpl mainPanel = new GeoreferencingPanelImpl();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        mainPanel.add((Component)env.getViewRasterToGeoref(), gbc);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        mainPanel.add((Component)env.getControlBar(), gbc);
        gbc.gridy = 2;
        JPanel p = this.fixPanelWithoutReference(env.getTable(), env.getViewZoomRasterToGeoref());
        mainPanel.add((Component)p, gbc);
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        winManager.showWindow((JComponent)mainPanel, i18n.getTranslation("georeferencing"), WindowManager.MODE.WINDOW, Collections.singletonMap("maximized", true));
        this.georeferencingPanel = mainPanel;
        ToolsSwingUtils.addWindowClosedListener((JComponent)this.georeferencingPanel, e -> {
            this.georeferencingPanel = null;
        });
        return mainPanel;
    }

    private JPanel fixPanelWithoutReference(JPanel table, JPanel zoom) {
        JPanel fixPanel = new JPanel();
        fixPanel.setPreferredSize(new Dimension(0, 140));
        fixPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        fixPanel.add((Component)table, gbc);
        gbc.gridx = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        JPanel zoomFixPanel = new JPanel();
        zoomFixPanel.setPreferredSize(new Dimension(220, 140));
        zoomFixPanel.setLayout(new BorderLayout());
        zoomFixPanel.add((Component)zoom, "Center");
        fixPanel.add((Component)zoomFixPanel, gbc);
        return fixPanel;
    }

    private JPanel fixPanelWithReference(JPanel table, JPanel zoom1, JPanel zoom2) {
        JPanel fixPanel = new JPanel();
        fixPanel.setPreferredSize(new Dimension(0, 140));
        fixPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        fixPanel.add((Component)table, gbc);
        gbc.gridx = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        JPanel zoomFixPanel1 = new JPanel();
        zoomFixPanel1.setPreferredSize(new Dimension(220, 140));
        zoomFixPanel1.setLayout(new BorderLayout());
        zoomFixPanel1.add((Component)zoom1, "Center");
        fixPanel.add((Component)zoomFixPanel1, gbc);
        JPanel zoomFixPanel2 = new JPanel();
        zoomFixPanel2.setPreferredSize(new Dimension(220, 140));
        zoomFixPanel2.setLayout(new BorderLayout());
        zoomFixPanel2.add((Component)zoom2, "Center");
        gbc.gridx = 2;
        fixPanel.add((Component)zoomFixPanel2, gbc);
        return fixPanel;
    }

    public LayoutEnvironment createLayoutEnvironment() {
        return new LayoutEnvironmentImpl();
    }

    public void showWindow(JPanel panel, int w, int h, String title) {
        panel.setPreferredSize(new Dimension(w, h));
        WindowManager winManager = ToolsSwingLocator.getWindowManager();
        winManager.showWindow((JComponent)panel, title, WindowManager.MODE.DIALOG);
    }

    public void closeWindow(JPanel panel) {
        panel.setVisible(false);
    }

    public void closeGeoreferencingPanel() {
        if (this.georeferencingPanel != null) {
            this.georeferencingPanel.setVisible(false);
            this.georeferencingPanel = null;
        }
    }

    private static class GeoreferencingPanelImpl
    extends JPanel
    implements GeoreferencingPanel {
        private GeoreferencingPanelImpl() {
        }

        public JComponent asJComponent() {
            return this;
        }
    }
}

