/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.launcher;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.gvsig.i18n.Messages;

public class TypeSelectionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private List<String> viewNameList = null;
    private JRadioButton withoutMap = null;
    private JRadioButton withMap = null;
    private JComboBox viewList = null;

    public TypeSelectionPanel(List<String> viewList) {
        this.viewNameList = viewList;
        this.init();
    }

    public void init() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.getWithoutMap());
        group.add(this.getWithMap());
        this.getWithoutMap().addActionListener(this);
        this.getWithMap().addActionListener(this);
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        this.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"georef_type"), 0, 0, null, null));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 8, 0);
        this.add((Component)this.getWithoutMap(), gbc);
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 5, 8, 0);
        this.add((Component)this.getWithMap(), gbc);
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 35, 8, 0);
        this.add((Component)this.getView(), gbc);
    }

    public JRadioButton getWithoutMap() {
        if (this.withoutMap == null) {
            this.withoutMap = new JRadioButton(Messages.getText((String)"without_map"));
        }
        return this.withoutMap;
    }

    public JRadioButton getWithMap() {
        if (this.withMap == null) {
            this.withMap = new JRadioButton(Messages.getText((String)"with_map"));
            this.withMap.setSelected(true);
        }
        return this.withMap;
    }

    public JComboBox getView() {
        if (this.viewList == null) {
            this.viewList = new JComboBox();
            for (int i = 0; i < this.viewNameList.size(); ++i) {
                this.viewList.addItem(this.viewNameList.get(i));
            }
        }
        return this.viewList;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getView().setEnabled(this.getWithMap().isSelected());
    }

    public String getSelectedView() {
        if (this.viewList != null && this.getWithMap().isSelected()) {
            return (String)this.viewList.getSelectedItem();
        }
        return null;
    }

    public int getType() {
        if (this.getWithoutMap().isSelected()) {
            return 1;
        }
        if (this.getWithMap().isSelected()) {
            return 0;
        }
        return -1;
    }
}

