/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.layer;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.raster.georeferencing.swing.impl.layer.GPGraphic;
import org.gvsig.raster.georeferencing.swing.impl.view.CanvasZone;
import org.gvsig.raster.georeferencing.swing.model.GCPList;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.raster.georeferencing.swing.view.IGraphicLayer;
import org.gvsig.raster.georeferencing.swing.view.ToolEvent;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCPsGraphicLayer
implements IGraphicLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GCPsGraphicLayer.class);
    public boolean active = true;
    private static final int NONE = -1;
    private static final int MOVE = 0;
    private GCPList pointList = null;
    private int type = 1;
    private Image icoBlue = null;
    private Image icoRed = null;
    private CanvasZone canvas = null;
    private int operation = -1;
    private GPGraphic operanteGP = null;
    private GPGraphic lastGP = null;
    private ToolListener listener = null;
    private boolean sleepActive = false;
    private GeoreferencingView view = null;

    public GCPsGraphicLayer(int type, ToolListener listener, GCPList pointList) {
        this.type = type;
        this.pointList = pointList;
        this.listener = listener;
        try {
            this.icoBlue = IconThemeHelper.getImage((String)"crux_blue-icon");
            this.icoRed = IconThemeHelper.getImage((String)"crux_red-icon");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public long getID(int pos) {
        try {
            return ((GPGraphic)this.pointList.getGraphicPoint(pos)).getId();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1L;
        }
    }

    public void setGeoreferencingView(GeoreferencingView view) {
        this.view = view;
        this.canvas = (CanvasZone)view.getCanvas();
        this.canvas.addMouseMotionListener((MouseMotionListener)((Object)this));
        this.canvas.addMouseListener((MouseListener)((Object)this));
    }

    public void draw(Graphics2D g, Rectangle2D ext, int w, int h) {
        if (this.pointList == null || this.canvas == null) {
            LOGGER.warn("Can't draw, pointList or canvas is null");
            return;
        }
        int selectedPoint = this.pointList.getSelectedPoint();
        for (int i = 0; i < this.pointList.size(); ++i) {
            GPGraphic graphicPoint = (GPGraphic)this.pointList.getGraphicPoint(i);
            if (graphicPoint == null) {
                LOGGER.warn("Can't draw, graphicPoint " + i + " is null");
                continue;
            }
            graphicPoint.draw(g, this.type, this.canvas, i == selectedPoint);
        }
    }

    public void setShowLabel(boolean showLabel) {
        for (int i = 0; i < this.pointList.size(); ++i) {
            GPGraphic graphicPoint = (GPGraphic)this.pointList.getGraphicPoint(i);
            if (graphicPoint == null) {
                LOGGER.warn("Can't do setShowLabel, graphicPoint " + i + " is null");
                continue;
            }
            graphicPoint.setShowLabel(showLabel);
        }
    }

    public GPGraphic getPoint(int pos) {
        try {
            return (GPGraphic)this.pointList.getGraphicPoint(pos);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public GCPList getPointList() {
        return this.pointList;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.isActive() || this.getOperation() != 0) {
            return;
        }
        this.operanteGP.setDraw(true);
        Point2D point = this.canvas.viewCoordsToWorld(e.getPoint());
        switch (this.type) {
            case 1: {
                this.operanteGP.getGeoPoint().setMapPoint(point);
                break;
            }
            case 0: {
                this.operanteGP.getGeoPoint().setPixelPoint(point);
            }
        }
        this.canvas.setCursor(new Cursor(0));
        this.operanteGP = null;
        this.setOperation(-1);
        if (this.listener != null) {
            this.listener.endAction(new ToolEvent((Object)this, this.view, null));
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.isActive()) {
            return;
        }
        if (this.getOperation() == 0) {
            this.operanteGP.setDraw(false);
            if (this.type == 0 && this.icoRed != null) {
                this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.icoRed, new Point(16, 16), ""));
            }
            if (this.type == 1 && this.icoBlue != null) {
                this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.icoBlue, new Point(16, 16), ""));
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.isActive()) {
            return;
        }
        this.setOperation(-1);
        for (int i = 0; i < this.pointList.size(); ++i) {
            GPGraphic gp = (GPGraphic)this.pointList.getGraphicPoint(i);
            Point2D p1 = null;
            if (this.type == 0) {
                p1 = gp.getGeoPoint().getPixelPoint();
            }
            if (this.type == 1) {
                p1 = gp.getGeoPoint().getMapPoint();
            }
            if (p1 == null) {
                return;
            }
            p1 = this.canvas.viewCoordsFromWorld(p1);
            int pxLeft = (int)p1.getX() - 4;
            int pxRight = (int)p1.getX() + 4;
            int pyUp = (int)p1.getY() - 4;
            int pyDown = (int)p1.getY() + 4;
            if (e.getX() < pxLeft || e.getX() > pxRight || e.getY() < pyUp || e.getY() > pyDown) continue;
            this.lastGP = this.operanteGP = gp;
            this.getPointList().setSelectedPoint(i);
            this.setOperation(0);
        }
    }

    private int getOperation() {
        return this.operation;
    }

    private void setOperation(int op) {
        this.operation = op;
        if (op == -1) {
            this.listener.offTool(new ToolEvent((Object)this, this.view, null));
        } else {
            this.listener.onTool(new ToolEvent((Object)this, this.view, null));
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void sleep() {
        this.sleepActive = this.active;
        this.active = false;
    }

    public void awake() {
        this.active = this.sleepActive;
    }

    public GPGraphic getLastPoint() {
        return this.lastGP;
    }
}

