/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.layer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.raster.georeferencing.swing.impl.view.CanvasZone;

public class GPGraphic {
    public static final int PIXEL = 0;
    public static final int MAP = 1;
    private final int DIAM_CIRCLE = 18;
    private boolean showNumber = true;
    private boolean showLabel = true;
    private GeoPoint geoPoint = null;
    private boolean draw = true;
    private long id = -1L;

    public GPGraphic(GeoPoint gp) {
        this.geoPoint = gp;
    }

    public void draw(Graphics2D g, int type, CanvasZone canvas, boolean selected) {
        if (!this.draw) {
            return;
        }
        if (this.geoPoint != null) {
            this.draw(g, this.geoPoint.getNumber(), this.geoPoint.getLabel(), type, canvas, selected);
        }
    }

    public void draw(Graphics2D g, int pointNumber, String label, int type, CanvasZone canvas, boolean selected) {
        switch (type) {
            case 0: {
                Point2D p1 = this.geoPoint.getPixelPoint();
                p1 = canvas.viewCoordsFromWorld(p1);
                this.drawPixelCrux(g, p1, pointNumber, label, selected);
                break;
            }
            case 1: {
                Point2D p2 = this.geoPoint.getMapPoint();
                p2 = canvas.viewCoordsFromWorld(p2);
                this.drawMapCrux(g, p2, pointNumber, label, selected);
            }
        }
    }

    private void drawPixelCrux(Graphics2D g, Point2D p, int pointNumber, String label, boolean selected) {
        int dpto = 9;
        int incr = 5;
        g.setColor(Color.WHITE);
        g.drawOval((int)p.getX() - dpto + 1, (int)p.getY() - dpto + 1, 16, 16);
        g.drawLine((int)p.getX() - incr, (int)p.getY() - 1, (int)p.getX() - 1, (int)p.getY() - 1);
        g.drawLine((int)p.getX() - incr, (int)p.getY() + 1, (int)p.getX() - 1, (int)p.getY() + 1);
        g.drawLine((int)p.getX() + incr, (int)p.getY() - 1, (int)p.getX() + 1, (int)p.getY() - 1);
        g.drawLine((int)p.getX() + incr, (int)p.getY() + 1, (int)p.getX() + 1, (int)p.getY() + 1);
        g.drawLine((int)p.getX() - 1, (int)p.getY() - incr, (int)p.getX() - 1, (int)p.getY() - 1);
        g.drawLine((int)p.getX() + 1, (int)p.getY() - incr, (int)p.getX() + 1, (int)p.getY() - 1);
        g.drawLine((int)p.getX() - 1, (int)p.getY() + incr, (int)p.getX() - 1, (int)p.getY() + 1);
        g.drawLine((int)p.getX() + 1, (int)p.getY() + incr, (int)p.getX() + 1, (int)p.getY() + 1);
        if (selected) {
            g.setColor(Color.GREEN);
        } else {
            g.setColor(Color.red);
        }
        g.drawOval((int)p.getX() - dpto, (int)p.getY() - dpto, 18, 18);
        g.drawLine((int)p.getX(), (int)p.getY() - dpto - incr, (int)p.getX(), (int)p.getY() + dpto + incr);
        g.drawLine((int)p.getX() - dpto - incr, (int)p.getY(), (int)p.getX() + dpto + incr, (int)p.getY());
        if (this.showNumber) {
            String pt = String.valueOf(pointNumber);
            int ptX = (int)(p.getX() + (double)dpto + 1.0);
            int ptY = (int)(p.getY() + (double)dpto - 1.0);
            g.setColor(Color.WHITE);
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    g.drawString(pt, ptX + i, ptY + j);
                }
            }
            if (selected) {
                g.setColor(Color.GREEN);
            } else {
                g.setColor(Color.red);
            }
            g.drawString(pt, ptX, ptY);
        }
        if (this.showLabel) {
            // empty if block
        }
    }

    private void drawMapCrux(Graphics2D g, Point2D p, int pointNumber, String label, boolean selected) {
        int dpto = 9;
        int incr = 5;
        g.setColor(Color.WHITE);
        g.drawRect((int)p.getX() - dpto + 1, (int)p.getY() - dpto + 1, 16, 16);
        g.drawLine((int)p.getX() - incr, (int)p.getY() - 1, (int)p.getX() - 1, (int)p.getY() - 1);
        g.drawLine((int)p.getX() - incr, (int)p.getY() + 1, (int)p.getX() - 1, (int)p.getY() + 1);
        g.drawLine((int)p.getX() + incr, (int)p.getY() - 1, (int)p.getX() + 1, (int)p.getY() - 1);
        g.drawLine((int)p.getX() + incr, (int)p.getY() + 1, (int)p.getX() + 1, (int)p.getY() + 1);
        g.drawLine((int)p.getX() - 1, (int)p.getY() - incr, (int)p.getX() - 1, (int)p.getY() - 1);
        g.drawLine((int)p.getX() + 1, (int)p.getY() - incr, (int)p.getX() + 1, (int)p.getY() - 1);
        g.drawLine((int)p.getX() - 1, (int)p.getY() + incr, (int)p.getX() - 1, (int)p.getY() + 1);
        g.drawLine((int)p.getX() + 1, (int)p.getY() + incr, (int)p.getX() + 1, (int)p.getY() + 1);
        if (selected) {
            g.setColor(Color.GREEN);
        } else {
            g.setColor(new Color(45, 8, 165));
        }
        g.drawRect((int)p.getX() - dpto, (int)p.getY() - dpto, 18, 18);
        g.drawLine((int)p.getX(), (int)p.getY() - dpto - incr, (int)p.getX(), (int)p.getY() + dpto + incr);
        g.drawLine((int)p.getX() - dpto - incr, (int)p.getY(), (int)p.getX() + dpto + incr, (int)p.getY());
        if (this.showNumber) {
            String pt = String.valueOf(pointNumber);
            int ptX = (int)(p.getX() + (double)dpto + 1.0);
            int ptY = (int)(p.getY() - (double)dpto - 1.0);
            g.setColor(Color.WHITE);
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    g.drawString(pt, ptX + i, ptY + j);
                }
            }
            if (selected) {
                g.setColor(Color.GREEN);
            } else {
                g.setColor(new Color(45, 8, 165));
            }
            g.drawString(String.valueOf(pointNumber), (int)(p.getX() + (double)dpto + 1.0), (int)(p.getY() - (double)dpto - 1.0));
        }
        if (this.showLabel) {
            // empty if block
        }
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public void setShowNumber(boolean showNumber) {
        this.showNumber = showNumber;
    }

    public GeoPoint getGeoPoint() {
        return this.geoPoint;
    }

    public boolean isDraw() {
        return this.draw;
    }

    public void setDraw(boolean draw) {
        this.draw = draw;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setNumber(int number) {
        this.geoPoint.setNumber(number);
    }
}

