/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.option;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.gvsig.i18n.Messages;

public class ColorSelector
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton button = null;
    private JPanel colorPanel = null;
    private Color color = null;
    private String text = null;
    private JColorChooser colorChooser = null;
    private JDialog dialog = null;

    public ColorSelector(Color color, String text) {
        this.color = color;
        this.text = text;
        this.init();
    }

    public void setColor(Color c) {
        this.color = c;
        if (this.colorPanel != null) {
            this.colorPanel.setBackground(this.color);
        }
        if (this.colorChooser != null) {
            this.colorChooser.setColor(this.color);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void init() {
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.getButton(), gbc);
        gbc.gridx = 1;
        this.add((Component)this.getPanel(), gbc);
    }

    public JButton getButton() {
        if (this.button == null) {
            this.button = new JButton(this.text);
            this.button.addActionListener(this);
        }
        return this.button;
    }

    public JPanel getPanel() {
        if (this.colorPanel == null) {
            this.colorPanel = new JPanel();
            this.colorPanel.setPreferredSize(new Dimension(50, 20));
            this.colorPanel.setSize(new Dimension(50, 20));
            this.colorPanel.setBackground(this.color);
        }
        return this.colorPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getButton()) {
            if (this.colorChooser == null) {
                this.colorChooser = new JColorChooser();
            }
            this.dialog = JColorChooser.createDialog(this.button, Messages.getText((String)"select_color"), true, this.colorChooser, this, null);
            this.colorChooser.setColor(this.color);
            this.dialog.setVisible(true);
            return;
        }
        this.color = this.colorChooser.getColor();
        this.getPanel().setBackground(this.color);
    }
}

