/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.view;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.gvsig.gui.beans.Messages;
import org.gvsig.raster.georeferencing.swing.impl.tool.BaseViewTool;
import org.gvsig.raster.georeferencing.swing.view.GeorefCanvas;
import org.gvsig.raster.georeferencing.swing.view.IGraphicLayer;
import org.gvsig.raster.georeferencing.swing.view.ViewEvent;
import org.gvsig.raster.georeferencing.swing.view.ViewListener;
import org.gvsig.tools.logger.FilteredLogger;
import org.slf4j.LoggerFactory;

public class CanvasZone
extends JPanel
implements GeorefCanvas,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1308683333757367640L;
    private static final FilteredLogger LOGGER_PAINT = new FilteredLogger(LoggerFactory.getLogger(CanvasZone.class), "paintCanvas", 15000L);
    private BufferedImage image = null;
    private double scale = 1.0;
    private Rectangle2D extent = null;
    private double pixelSize = 1.0;
    private Point2D center = null;
    private List<IGraphicLayer> graphicLayers = new ArrayList<IGraphicLayer>();
    private Rectangle2D lastExtent = null;
    private BufferedImage lastImage = null;
    private BufferedImage lastImageWithLayers = null;
    private boolean clear = true;
    private BaseViewTool selectedTool = null;
    private Point2D realCoord = new Point2D.Double(0.0, 0.0);
    private boolean showInfo = false;
    private boolean minxMaxyUL = true;
    private Color backgroundColor = Color.BLACK;
    private Color textColor = Color.RED;
    private boolean forceRequest = false;
    private ViewListener viewListener = null;
    private ViewEvent viewEvent = null;
    private AffineTransform panAT = new AffineTransform();
    private AffineTransform zoomAT = new AffineTransform();
    private boolean activeMouseCanvasEvents = true;

    public void setDrawParams(BufferedImage img, Rectangle2D ext, double pixelSize, Point2D center) {
        this.image = img;
        this.extent = ext;
        this.pixelSize = pixelSize;
        this.center = center;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.repaint();
    }

    public void setViewListener(ViewListener listener) {
        this.viewListener = listener;
        this.viewEvent = new ViewEvent((Object)this);
    }

    public void setCenter(Point2D center) {
        this.center = center;
        this.repaint();
    }

    public Point2D viewCoordsToWorld(Point2D p) {
        if (p == null) {
            return null;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        double cx = this.extent.getMinX() + p.getX() * this.extent.getWidth() / (double)w;
        double cy = this.minxMaxyUL ? this.extent.getMaxY() - p.getY() * this.extent.getHeight() / (double)h : this.extent.getMinY() + p.getY() * this.extent.getHeight() / (double)h;
        return new Point2D.Double(cx, cy);
    }

    public Point2D viewCoordsFromWorld(Point2D p) {
        if (p == null) {
            return null;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        double cx = (p.getX() - this.extent.getMinX()) * (double)w / this.extent.getWidth();
        double cy = 0.0;
        cy = this.minxMaxyUL ? (this.extent.getMaxY() - p.getY()) * (double)h / this.extent.getHeight() : (p.getY() - this.extent.getMinY()) * (double)h / this.extent.getHeight();
        return new Point2D.Double(cx, cy);
    }

    public Rectangle2D getExtent() {
        if (this.lastExtent == null) {
            return this.extent;
        }
        return this.lastExtent;
    }

    public void setViewCenter(Point2D c) {
        int w = this.getWidth();
        int h = this.getHeight();
        double cx = c.getX() * this.lastExtent.getWidth() / (double)w;
        double cy = c.getY() * this.lastExtent.getHeight() / (double)h;
        this.setPixelCenter(new Point2D.Double(cx, cy));
    }

    public void setPixelCenter(Point2D c) {
        int w = this.getWidth();
        int h = this.getHeight();
        Rectangle2D ext = this.getCanvasExtent(w, h, this.scale);
        double wWC = c.getX() / this.scale * this.pixelSize;
        double hWC = c.getY() / this.scale * this.pixelSize;
        this.center = new Point2D.Double(ext.getMinX() + wWC, ext.getMinY() - hWC);
        this.repaint();
    }

    public void setPixelCenter(int x, int y) {
        int w = this.getWidth();
        int h = this.getHeight();
        Rectangle2D ext = this.getCanvasExtent(w, h, this.scale);
        double wWC = (double)x / this.scale * this.pixelSize;
        double hWC = (double)y / this.scale * this.pixelSize;
        Point2D.Double center = new Point2D.Double(ext.getMinX() + wWC, ext.getMinY() - hWC);
        int pxX = (int)(((Point2D)center).getX() * ((double)w / this.scale) / ext.getWidth());
        int pxY = (int)(((Point2D)center).getY() * ((double)h / this.scale) / ext.getHeight());
        double wcX = (double)pxX * ext.getWidth() / ((double)w / this.scale);
        double wcY = (double)pxY * ext.getHeight() / ((double)h / this.scale);
        this.center = new Point2D.Double(wcX, wcY);
        this.repaint();
    }

    public void setGraphicLayer(IGraphicLayer layer) {
        this.graphicLayers.add(layer);
    }

    public List<IGraphicLayer> getGraphicLayers() {
        return this.graphicLayers;
    }

    public void setZoom(double scale) {
        this.scale = scale;
        this.repaint();
    }

    public double getZoom() {
        return this.scale;
    }

    public Rectangle2D getCanvasExtent() {
        return this.lastExtent;
    }

    public void setCanvasExtent(Rectangle2D r) {
        this.lastExtent = r;
    }

    public double getPixelSize() {
        return this.pixelSize;
    }

    public Point2D getCenter() {
        return this.center;
    }

    public BufferedImage getBufferedImage() {
        return null;
    }

    public void activeClear() {
        this.clear = true;
    }

    private void resetView(Graphics g, int w, int h) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(new Color(61, 191, 193));
        Font f = g.getFont();
        Font newFont = new Font(f.getName(), f.getStyle(), 32);
        g.setFont(newFont);
        String text = Messages.getText((String)"loading_georef");
        int lon = g.getFontMetrics().stringWidth(text);
        g.drawString(text, w / 2 - lon / 2, h / 2);
        this.clear = false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        try {
            if (this.clear) {
                this.resetView(g, this.getWidth(), this.getHeight());
                return;
            }
            if (this.image == null) {
                return;
            }
            if (this.viewListener != null) {
                this.viewListener.startDraw(this.viewEvent);
            }
            int w = this.getWidth();
            int h = this.getHeight();
            Rectangle2D ext = this.getCanvasExtent(w, h, this.scale);
            if (!this.zoomAT.isIdentity()) {
                g.setColor(this.backgroundColor);
                g.fillRect(0, 0, w, h);
                ((Graphics2D)g).transform(this.zoomAT);
                g.drawImage(this.lastImage, 0, 0, null);
                this.zoomAT.setToIdentity();
                return;
            }
            if (this.lastImage == null || this.lastImage.getWidth() != w || this.lastImage.getHeight() != h) {
                this.lastImage = new BufferedImage(w, h, 1);
                this.lastImageWithLayers = new BufferedImage(w, h, 1);
            } else if (!this.panAT.isIdentity()) {
                g.drawImage(this.lastImageWithLayers, 0, 0, null);
                ((Graphics2D)g).transform(this.panAT);
                AlphaComposite composite = AlphaComposite.getInstance(10, 0.6f);
                ((Graphics2D)g).setComposite(composite);
                g.drawImage(this.lastImage, 0, 0, null);
                return;
            }
            Graphics graphicsDB = this.draw(ext, w, h);
            for (int i = 0; i < this.graphicLayers.size(); ++i) {
                this.graphicLayers.get(i).draw((Graphics2D)graphicsDB, ext, w, h);
            }
            this.lastExtent = ext;
            if (this.selectedTool != null) {
                this.selectedTool.draw(graphicsDB);
            }
            if (this.showInfo) {
                this.showInfo(graphicsDB);
            }
            g.drawImage(this.lastImageWithLayers, 0, 0, this);
            graphicsDB.dispose();
            if (this.viewListener != null) {
                this.viewListener.endDraw(this.viewEvent);
            }
        }
        catch (Throwable th) {
            LOGGER_PAINT.warn("Can't paint canvas", th);
        }
    }

    private void showInfo(Graphics g) {
        g.setColor(this.textColor);
        g.drawString("X: " + this.clipDecimals(this.realCoord.getX(), 3), 12, 18);
        g.drawString("Y: " + this.clipDecimals(this.realCoord.getY(), 3), 12, 32);
    }

    public double clipDecimals(double num, int n) {
        long m = (long)Math.pow(10.0, n);
        long aux = Math.round(num * (double)m);
        return (double)aux / (double)m;
    }

    private boolean equal(Rectangle2D e1, Rectangle2D e2) {
        return e1 != null && e2 != null && e1.getMinX() == e2.getMinX() && e1.getMinY() == e2.getMinY() && e1.getMaxX() == e2.getMaxX() && e1.getMaxY() == e2.getMaxY();
    }

    private Rectangle2D getCanvasExtent(double w, double h, double scale) {
        double tW = w / scale / 2.0 * this.pixelSize;
        double tH = h / scale / 2.0 * this.pixelSize;
        double minX = this.center.getX() - tW;
        double minY = this.center.getY() - tH;
        double width = Math.abs(this.center.getX() + tW - minX);
        double height = Math.abs(this.center.getY() + tH - minY);
        return new Rectangle2D.Double(minX, minY, width, height);
    }

    private Graphics draw(Rectangle2D ext, double w, double h) {
        if (!this.equal(this.lastExtent, ext) || this.forceRequest) {
            double pxX = (ext.getMinX() - this.extent.getMinX()) * (w / this.scale) / ext.getWidth();
            double pxY = (this.extent.getMinY() - ext.getMinY()) * (h / this.scale) / ext.getHeight();
            double step = 1.0 / this.scale;
            double xValue = pxX;
            double yValue = pxY;
            int i = 0;
            while ((double)i < w) {
                yValue = pxY;
                int j = 0;
                while ((double)j < h) {
                    if ((int)xValue >= 0 && (int)yValue >= 0 && (int)xValue < this.image.getWidth() && (int)yValue < this.image.getHeight()) {
                        this.lastImage.setRGB(i, j, this.image.getRGB((int)xValue, (int)yValue));
                        this.lastImageWithLayers.setRGB(i, j, this.image.getRGB((int)xValue, (int)yValue));
                    } else {
                        this.lastImage.setRGB(i, j, -1);
                        this.lastImageWithLayers.setRGB(i, j, -1);
                    }
                    yValue += step;
                    ++j;
                }
                xValue += step;
                ++i;
            }
            if (this.viewListener != null) {
                this.viewListener.zoomViewChanged(this.viewEvent);
            }
            this.forceRequest = false;
        } else {
            ((Graphics2D)this.lastImageWithLayers.getGraphics()).drawImage((Image)this.lastImage, 0, 0, null);
        }
        return this.lastImageWithLayers.getGraphics();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.activeMouseCanvasEvents) {
            return;
        }
        for (int i = 0; i < this.graphicLayers.size(); ++i) {
            this.graphicLayers.get(i).mouseClicked(e);
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.activeMouseCanvasEvents) {
            return;
        }
        for (int i = 0; i < this.graphicLayers.size(); ++i) {
            this.graphicLayers.get(i).mouseEntered(e);
        }
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.activeMouseCanvasEvents) {
            return;
        }
        for (int i = 0; i < this.graphicLayers.size(); ++i) {
            this.graphicLayers.get(i).mouseExited(e);
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.activeMouseCanvasEvents) {
            return;
        }
        for (int i = 0; i < this.graphicLayers.size(); ++i) {
            this.graphicLayers.get(i).mousePressed(e);
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.activeMouseCanvasEvents) {
            return;
        }
        for (int i = 0; i < this.graphicLayers.size(); ++i) {
            this.graphicLayers.get(i).mouseReleased(e);
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.activeMouseCanvasEvents) {
            return;
        }
        for (int i = 0; i < this.graphicLayers.size(); ++i) {
            this.graphicLayers.get(i).mouseDragged(e);
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.activeMouseCanvasEvents) {
            return;
        }
        this.realCoord = this.viewCoordsToWorld(e.getPoint());
        for (int i = 0; i < this.graphicLayers.size(); ++i) {
            this.graphicLayers.get(i).mouseMoved(e);
        }
        this.repaint();
    }

    public void setSelectedTool(BaseViewTool selectedTool) {
        this.selectedTool = selectedTool;
    }

    public BaseViewTool getSelectedTool() {
        return this.selectedTool;
    }

    public void setShowInfo(boolean showInfo) {
        this.showInfo = showInfo;
    }

    public void setMinxMaxyUL(boolean v) {
        this.minxMaxyUL = v;
    }

    public boolean getMinxMaxyUL() {
        return this.minxMaxyUL;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
        this.repaint();
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean isForceRequest() {
        return this.forceRequest;
    }

    public void setForceRequest(boolean forceRequest) {
        this.forceRequest = forceRequest;
    }

    public AffineTransform getPanAffineTransform() {
        return this.panAT;
    }

    public synchronized void setZoomAffineTransform(double scaleX, double scaleY, double shiftX, double shiftY) {
        this.zoomAT = new AffineTransform(scaleX, 0.0, 0.0, scaleY, shiftX, shiftY);
        this.activeMouseCanvasEvents = false;
    }

    public AffineTransform getAtZoom() {
        return this.zoomAT;
    }

    public void setActiveMoveRedraw(boolean active) {
        this.activeMouseCanvasEvents = active;
    }
}

