/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLibrary;
import org.gvsig.raster.georeferencing.swing.exception.InvalidRequestException;
import org.gvsig.raster.georeferencing.swing.impl.GeoreferencingSwingImplLibrary;
import org.gvsig.raster.georeferencing.swing.impl.layer.ZoomCursorGraphicLayer;
import org.gvsig.raster.georeferencing.swing.impl.tool.BaseViewTool;
import org.gvsig.raster.georeferencing.swing.impl.tool.PanTool;
import org.gvsig.raster.georeferencing.swing.impl.tool.ZoomRectangleTool;
import org.gvsig.raster.georeferencing.swing.impl.tool.ZoomWheelTool;
import org.gvsig.raster.georeferencing.swing.impl.view.CanvasZone;
import org.gvsig.raster.georeferencing.swing.impl.view.ViewRecord;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.raster.georeferencing.swing.view.IGraphicLayer;
import org.gvsig.raster.georeferencing.swing.view.IViewRequestManager;
import org.gvsig.raster.georeferencing.swing.view.ToolEvent;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;
import org.gvsig.raster.georeferencing.swing.view.ViewEvent;
import org.gvsig.raster.georeferencing.swing.view.ViewListener;
import org.gvsig.tools.task.Cancellable;

public class ViewControl
extends JPanel
implements ActionListener,
ToolListener {
    private static final long serialVersionUID = 1L;
    public static final int ZOOM_INCREASE = 0;
    public static final int ZOOM_DECREASE = 1;
    public static final int SELECT_ZOOM_AREA = 2;
    public static final int FULL_VIEW = 3;
    public static final int PREV_ZOOM = 4;
    public static final int PAN = 5;
    public static final int LOCATOR = 6;
    public static final int RIGHT_CONTROL = 1;
    public static final int LEFT_CONTROL = 2;
    public static final int NOCONTROL = 0;
    private final double SCALE = 0.5;
    private int controlsPosition;
    private CanvasZone canvas = null;
    private JPanel buttons = null;
    private JButton bZoomMas = null;
    private JButton bZoomMenos = null;
    private JToggleButton bSelectZoomArea = null;
    private JToggleButton bPan = null;
    private JButton bFullView = null;
    private JButton bPrevZoom = null;
    private JButton bCenterLocator = null;
    private double stepScale = 2.0;
    private IViewRequestManager extReq = null;
    private ViewRecord zoomRecord = null;
    private List<BaseViewTool> toolList = null;
    private ViewListener viewListener = null;
    private ViewEvent viewEvent = null;

    public ViewControl(int control, GeoreferencingView parentView) {
        this.controlsPosition = control;
        this.toolList = new ArrayList<BaseViewTool>();
        this.init();
    }

    public void setViewListener(ViewListener listener) {
        this.viewListener = listener;
        this.viewEvent = new ViewEvent((Object)this);
        this.getCanvas().setViewListener(this.viewListener);
    }

    public void addTool(BaseViewTool tool) {
        if (!this.toolList.contains(tool)) {
            this.toolList.add(tool);
        }
    }

    public void replaceTool(BaseViewTool tool) {
        for (int i = 0; i < this.toolList.size(); ++i) {
            if (this.toolList.get(i).getClass().isInstance(tool)) {
                this.toolList.remove(i);
                break;
            }
            this.toolList.add(tool);
        }
    }

    public BaseViewTool getToolSelected() {
        return this.getCanvas().getSelectedTool();
    }

    public void enableToolPressingButton(int tool) {
        if (tool == GeoreferencingSwingLibrary.ZOOM_RECTANGLE_TOOL) {
            this.getBSelectZoomArea().setSelected(true);
        }
        if (tool == GeoreferencingSwingLibrary.PAN_TOOL) {
            this.getBPan().setSelected(true);
        }
        this.enableTool(tool);
    }

    public void enableTool(int tool) {
        if (tool < 0) {
            this.disableAllTools();
            return;
        }
        for (int i = 0; i < this.toolList.size(); ++i) {
            if (this.toolList.get(i).getToolType() != tool) continue;
            this.toolList.get(i).setActive(true);
            this.getCanvas().setSelectedTool(this.toolList.get(i));
            if (this.viewListener == null) continue;
            this.viewListener.addingTool(this.viewEvent);
        }
    }

    public void selectUniqueTool(Class<?> tool) {
        if (tool == null) {
            for (int i = 0; i < this.toolList.size(); ++i) {
                this.toolList.get(i).setActive(false);
            }
            this.getCanvas().setSelectedTool(null);
            return;
        }
        for (int i = 0; i < this.toolList.size(); ++i) {
            if (tool.isInstance(this.toolList.get(i))) {
                this.toolList.get(i).setActive(true);
                this.getCanvas().setSelectedTool(this.toolList.get(i));
                if (this.viewListener == null) continue;
                this.viewListener.addingTool(this.viewEvent);
                continue;
            }
            this.toolList.get(i).setActive(false);
        }
    }

    public boolean registerToolListener(Class<?> tool, ToolListener listener) {
        if (tool == null) {
            return false;
        }
        for (int i = 0; i < this.toolList.size(); ++i) {
            if (!tool.isInstance(this.toolList.get(i))) continue;
            this.toolList.get(i).addToolListener(listener);
            return true;
        }
        return false;
    }

    public void sleepTools() {
        for (int i = 0; i < this.toolList.size(); ++i) {
            this.toolList.get(i).sleep();
        }
    }

    public void disableAllTools() {
        for (int i = 0; i < this.toolList.size(); ++i) {
            this.toolList.get(i).setActive(false);
        }
        this.getBPan().setSelected(false);
        this.getBSelectZoomArea().setSelected(false);
        this.getCanvas().setSelectedTool(null);
    }

    public void disableTool(int tool) {
        for (int i = 0; i < this.toolList.size(); ++i) {
            if (this.toolList.get(i).getToolType() != tool) continue;
            this.toolList.get(i).setActive(false);
        }
    }

    public void awakeTools() {
        for (int i = 0; i < this.toolList.size(); ++i) {
            this.toolList.get(i).awake();
        }
    }

    private void init() {
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        if (this.controlsPosition == 2) {
            this.add((Component)this.getButtonsPanel(), "West");
        }
        if (this.controlsPosition == 1) {
            this.add((Component)this.getButtonsPanel(), "East");
        }
        this.add((Component)this.getCanvas(), "Center");
    }

    public void hideButton(int b) {
        switch (b) {
            case 0: {
                this.getBZoomMas().setVisible(false);
                break;
            }
            case 1: {
                this.getBZoomMenos().setVisible(false);
                break;
            }
            case 2: {
                this.getBSelectZoomArea().setVisible(false);
                break;
            }
            case 3: {
                this.getBFullView().setVisible(false);
                break;
            }
            case 4: {
                this.getBPrevZoom().setVisible(false);
                break;
            }
            case 5: {
                this.getBPan().setVisible(false);
                break;
            }
            case 6: {
                this.getBCenterLocator().setVisible(false);
                break;
            }
        }
    }

    public void showButton(int b) {
        switch (b) {
            case 0: {
                this.getBZoomMas().setVisible(true);
                break;
            }
            case 1: {
                this.getBZoomMenos().setVisible(true);
                break;
            }
            case 2: {
                this.getBSelectZoomArea().setVisible(true);
                break;
            }
            case 3: {
                this.getBFullView().setVisible(true);
                break;
            }
            case 4: {
                this.getBPrevZoom().setVisible(true);
                break;
            }
            case 5: {
                this.getBPan().setVisible(true);
                break;
            }
            case 6: {
                this.getBCenterLocator().setVisible(true);
                break;
            }
        }
    }

    public void setGraphicLayer(IGraphicLayer layer) {
        this.getCanvas().setGraphicLayer(layer);
    }

    public CanvasZone getCanvas() {
        if (this.canvas == null) {
            this.canvas = new CanvasZone();
            this.canvas.setViewListener(this.viewListener);
            this.canvas.setBorder(BorderFactory.createBevelBorder(1));
        }
        return this.canvas;
    }

    public JPanel getButtonsPanel() {
        if (this.buttons == null) {
            this.buttons = new JPanel();
            GridBagLayout l = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 0, 3, 3);
            this.buttons.setLayout(l);
            this.buttons.add((Component)this.getBZoomMas(), gbc);
            gbc.gridy = 1;
            this.buttons.add((Component)this.getBZoomMenos(), gbc);
            gbc.gridy = 2;
            this.buttons.add((Component)this.getBSelectZoomArea(), gbc);
            gbc.gridy = 3;
            this.buttons.add((Component)this.getBFullView(), gbc);
            gbc.gridy = 4;
            this.buttons.add((Component)this.getBPrevZoom(), gbc);
            gbc.gridy = 5;
            this.buttons.add((Component)this.getBPan(), gbc);
            gbc.gridy = 6;
            this.buttons.add((Component)this.getBCenterLocator(), gbc);
        }
        return this.buttons;
    }

    public JButton getBZoomMas() {
        if (this.bZoomMas == null) {
            this.bZoomMas = new JButton();
            this.bZoomMas.setToolTipText(Messages.getText((String)"Zoom_in"));
            this.bZoomMas.setPreferredSize(new Dimension(25, 25));
            try {
                this.bZoomMas.setIcon(IconThemeHelper.getImageIcon((String)"view-navigation-zoom-in-topoint"));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.bZoomMas.addActionListener(this);
        }
        return this.bZoomMas;
    }

    public JButton getBCenterLocator() {
        if (this.bCenterLocator == null) {
            this.bCenterLocator = new JButton();
            this.bCenterLocator.setToolTipText(Messages.getText((String)"center_locator"));
            this.bCenterLocator.setPreferredSize(new Dimension(25, 25));
            try {
                this.bCenterLocator.setIcon(IconThemeHelper.getImageIcon((String)"centerlocator-icon"));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.bCenterLocator.addActionListener(this);
        }
        return this.bCenterLocator;
    }

    public JButton getBZoomMenos() {
        if (this.bZoomMenos == null) {
            this.bZoomMenos = new JButton();
            this.bZoomMenos.setToolTipText(Messages.getText((String)"Zoom_out"));
            this.bZoomMenos.setPreferredSize(new Dimension(25, 25));
            try {
                this.bZoomMenos.setIcon(IconThemeHelper.getImageIcon((String)"view-navigation-zoom-out-topoint"));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.bZoomMenos.addActionListener(this);
        }
        return this.bZoomMenos;
    }

    public JToggleButton getBSelectZoomArea() {
        if (this.bSelectZoomArea == null) {
            this.bSelectZoomArea = new JToggleButton();
            this.bSelectZoomArea.setToolTipText(Messages.getText((String)"select_zoom_area"));
            this.bSelectZoomArea.setPreferredSize(new Dimension(25, 25));
            try {
                this.bSelectZoomArea.setIcon(IconThemeHelper.getImageIcon((String)"selectzoomarea-icon"));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.bSelectZoomArea.addActionListener(this);
        }
        return this.bSelectZoomArea;
    }

    public JToggleButton getBPan() {
        if (this.bPan == null) {
            this.bPan = new JToggleButton();
            this.bPan.setToolTipText(Messages.getText((String)"move_image"));
            this.bPan.setPreferredSize(new Dimension(25, 25));
            try {
                this.bPan.setIcon(IconThemeHelper.getImageIcon((String)"hand-icon"));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.bPan.addActionListener(this);
        }
        return this.bPan;
    }

    public JButton getBPrevZoom() {
        if (this.bPrevZoom == null) {
            this.bPrevZoom = new JButton();
            this.bPrevZoom.setToolTipText(Messages.getText((String)"prev_zoom"));
            this.bPrevZoom.setPreferredSize(new Dimension(25, 25));
            try {
                this.bPrevZoom.setIcon(IconThemeHelper.getImageIcon((String)"prevzoom-icon"));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.bPrevZoom.addActionListener(this);
        }
        return this.bPrevZoom;
    }

    public JButton getBFullView() {
        if (this.bFullView == null) {
            this.bFullView = new JButton();
            this.bFullView.setToolTipText(Messages.getText((String)"full_view"));
            this.bFullView.setPreferredSize(new Dimension(25, 25));
            try {
                this.bFullView.setIcon(IconThemeHelper.getImageIcon((String)"fullview-icon"));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.bFullView.addActionListener(this);
        }
        return this.bFullView;
    }

    public void setDrawParams(BufferedImage img, Rectangle2D ext, double pixelSize, Point2D center) {
        this.getZoomRecord().setRequest(ext);
        this.getCanvas().setDrawParams(img, ext, pixelSize, center);
    }

    public void setCenter(Point2D center) {
        Rectangle2D ext = this.getCanvas().getExtent();
        double diffX = center.getX() - ext.getCenterX();
        double diffY = center.getY() - ext.getCenterY();
        ext.setRect(ext.getX() + diffX, ext.getY() + diffY, ext.getWidth(), ext.getHeight());
        try {
            this.getCanvas().setForceRequest(true);
            if (this.extReq != null) {
                this.extReq.request(ext, null);
            }
        }
        catch (InvalidRequestException e) {
            GeoreferencingSwingImplLibrary.messageBoxError("error_setview_preview", this);
        }
    }

    public void setExtensionRequest(IViewRequestManager er) {
        this.extReq = er;
    }

    public IViewRequestManager getExtensionRequest() {
        return this.extReq;
    }

    public ViewRecord getZoomRecord() {
        if (this.zoomRecord == null) {
            this.zoomRecord = new ViewRecord();
        }
        return this.zoomRecord;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bCenterLocator) {
            List<IGraphicLayer> graphicLayers = this.getCanvas().getGraphicLayers();
            for (int i = 0; i < graphicLayers.size(); ++i) {
                if (!(graphicLayers.get(i) instanceof ZoomCursorGraphicLayer)) continue;
                ((ZoomCursorGraphicLayer)graphicLayers.get(i)).setCursorPosition(this.getCanvas().getWidth() / 2, this.getCanvas().getHeight() / 2);
                ((ZoomCursorGraphicLayer)graphicLayers.get(i)).resetCursorSize();
            }
        }
        if (this.extReq == null) {
            if (e.getSource() == this.bZoomMas) {
                this.getCanvas().setZoom(this.canvas.getZoom() * this.stepScale);
            }
            if (e.getSource() == this.bZoomMenos) {
                this.getCanvas().setZoom(this.canvas.getZoom() / this.stepScale);
            }
            if (e.getSource() == this.bFullView) {
                this.getCanvas().setZoom(1.0);
            }
        } else {
            double width = 0.0;
            double height = 0.0;
            this.getCanvas().setZoom(1.0);
            if (e.getSource() == this.bCenterLocator) {
                double zoomPrev = this.canvas.getZoom();
                try {
                    this.extReq.fullExtent();
                }
                catch (InvalidRequestException e1) {
                    GeoreferencingSwingImplLibrary.messageBoxError("error_setview_preview", this);
                }
                this.getCanvas().setZoom(zoomPrev);
            }
            if (e.getSource() == this.bFullView) {
                try {
                    this.extReq.fullExtent();
                }
                catch (InvalidRequestException e1) {
                    GeoreferencingSwingImplLibrary.messageBoxError("error_setview_preview", this);
                }
                return;
            }
            if (e.getSource() == this.bPrevZoom) {
                Object request = this.getZoomRecord().getRequest();
                if (request != null) {
                    if (request instanceof Rectangle2D) {
                        try {
                            this.extReq.request((Rectangle2D)request, null);
                        }
                        catch (InvalidRequestException e1) {
                            GeoreferencingSwingImplLibrary.messageBoxError("error_setview_preview", this);
                        }
                    }
                    if (request instanceof Integer && (Integer)request == 3) {
                        try {
                            this.extReq.fullExtent();
                        }
                        catch (InvalidRequestException e1) {
                            GeoreferencingSwingImplLibrary.messageBoxError("error_setview_preview", this);
                        }
                    }
                    this.getZoomRecord().getRequest();
                }
                return;
            }
            width = this.getCanvas().getCanvasExtent().getWidth();
            height = this.getCanvas().getCanvasExtent().getHeight();
            if (e.getSource() == this.bPan) {
                if (this.getBPan().isSelected()) {
                    for (int i = 0; i < this.toolList.size(); ++i) {
                        this.toolList.get(i).setActive(false);
                    }
                    this.getBSelectZoomArea().setSelected(false);
                    this.enableTool(GeoreferencingSwingLibrary.PAN_TOOL);
                } else {
                    this.disableTool(GeoreferencingSwingLibrary.PAN_TOOL);
                }
            }
            if (e.getSource() == this.bSelectZoomArea) {
                if (this.getBSelectZoomArea().isSelected()) {
                    for (int i = 0; i < this.toolList.size(); ++i) {
                        this.toolList.get(i).setActive(false);
                    }
                    this.getBPan().setSelected(false);
                    this.enableTool(GeoreferencingSwingLibrary.ZOOM_RECTANGLE_TOOL);
                } else {
                    this.disableTool(GeoreferencingSwingLibrary.ZOOM_RECTANGLE_TOOL);
                }
            }
            if (e.getSource() == this.bZoomMas) {
                width = this.getCanvas().getCanvasExtent().getWidth() * 0.5;
                height = this.getCanvas().getCanvasExtent().getHeight() * 0.5;
            }
            if (e.getSource() == this.bZoomMenos) {
                width = this.getCanvas().getCanvasExtent().getWidth() / 0.5;
                height = this.getCanvas().getCanvasExtent().getHeight() / 0.5;
            }
            double x = this.getCanvas().getCenter().getX() - width / 2.0;
            double y = this.getCanvas().getCenter().getY() - height / 2.0;
            Rectangle2D.Double request = new Rectangle2D.Double(x, y, width, height);
            try {
                this.extReq.request((Rectangle2D)request, null);
            }
            catch (InvalidRequestException e1) {
                GeoreferencingSwingImplLibrary.messageBoxError("error_setview_preview", this);
            }
        }
    }

    public void reload() {
        if (this.getCanvas() == null || this.getCanvas().getCanvasExtent() == null) {
            return;
        }
        double width = this.getCanvas().getCanvasExtent().getWidth();
        double height = this.getCanvas().getCanvasExtent().getHeight();
        double x = this.getCanvas().getCenter().getX() - width / 2.0;
        double y = this.getCanvas().getCenter().getY() - height / 2.0;
        Rectangle2D.Double request = new Rectangle2D.Double(x, y, width, height);
        try {
            this.getCanvas().setForceRequest(true);
            if (this.extReq != null) {
                this.extReq.request((Rectangle2D)request, null);
            }
        }
        catch (InvalidRequestException e1) {
            GeoreferencingSwingImplLibrary.messageBoxError("error_setview_preview", this);
        }
    }

    public int getCanvasWith() {
        return this.getCanvas().getWidth();
    }

    public int getCanvasHeight() {
        return this.getCanvas().getHeight();
    }

    public BufferedImage getBufferedImage() {
        return this.getCanvas().getBufferedImage();
    }

    public void endAction(ToolEvent ev) {
        if ((ev.getSource() instanceof ZoomRectangleTool || ev.getSource() instanceof ZoomRectangleTool.Drawer || ev.getSource() instanceof PanTool || ev.getSource() instanceof PanTool.Drawer) && this.getCanvas().getSelectedTool().getResult() instanceof Rectangle2D) {
            Rectangle2D extent = (Rectangle2D)this.getCanvas().getSelectedTool().getResult();
            try {
                if (this.extReq != null) {
                    this.extReq.request(extent, ev.getCancellable());
                }
            }
            catch (InvalidRequestException e1) {
                GeoreferencingSwingImplLibrary.messageBoxError("error_setview_preview", this);
            }
        }
        if (ev.getSource() instanceof ZoomWheelTool) {
            for (int i = 0; i < this.toolList.size(); ++i) {
                if (!(this.toolList.get(i) instanceof ZoomWheelTool)) continue;
                Cancellable c = ev.getCancellable();
                try {
                    if (this.extReq == null || c != null && (c == null || c.isCanceled())) continue;
                    this.extReq.request((Rectangle2D)ev.getResult(), ev.getCancellable());
                    continue;
                }
                catch (InvalidRequestException e1) {
                    GeoreferencingSwingImplLibrary.messageBoxError("error_setview_preview", this);
                }
            }
        }
    }

    public void onTool(ToolEvent ev) {
    }

    public void offTool(ToolEvent ev) {
    }
}

