/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.gvsig.raster.georeferencing.swing.impl.layer.ZoomCursorGraphicLayer;
import org.gvsig.raster.georeferencing.swing.impl.tool.PanTool;
import org.gvsig.raster.georeferencing.swing.impl.tool.ZoomRectangleTool;
import org.gvsig.raster.georeferencing.swing.impl.tool.ZoomWheelTool;
import org.gvsig.raster.georeferencing.swing.impl.view.BaseViewPanel;
import org.gvsig.raster.georeferencing.swing.impl.view.ViewControl;
import org.gvsig.raster.georeferencing.swing.view.IGraphicLayer;
import org.gvsig.raster.georeferencing.swing.view.IViewRequestManager;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;
import org.gvsig.raster.georeferencing.swing.view.ViewListener;
import org.slf4j.LoggerFactory;

public class ViewPanelImpl
extends BaseViewPanel
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    private ZoomCursorGraphicLayer zoomCursorGraphic = null;
    private ToolListener zoomCursorGraphicListener = null;
    private boolean rightSideButtons = true;

    public ViewPanelImpl(ToolListener zoomCursorGraphicListener, boolean rightSideButtons) {
        this.zoomCursorGraphicListener = zoomCursorGraphicListener;
        this.rightSideButtons = rightSideButtons;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getControl(), "Center");
        this.getZoomCursorGraphicLayer();
    }

    @Override
    public void setViewListener(ViewListener listener) {
        this.getControl().setViewListener(listener);
    }

    public void setMinxMaxyUL(boolean v) {
        this.getCanvas().setMinxMaxyUL(v);
    }

    public boolean getMinxMaxyUL() {
        return this.getCanvas().getMinxMaxyUL();
    }

    public void setCenter(Point2D center) {
        this.getControl().setCenter(center);
    }

    @Override
    public void setDrawParams(BufferedImage img, Rectangle2D ext, double pixelSize, Point2D center) {
        this.getControl().setDrawParams(img, ext, pixelSize, center);
    }

    @Override
    public ViewControl getControl() {
        if (this.viewControl == null) {
            this.viewControl = this.rightSideButtons ? new ViewControl(1, this) : new ViewControl(2, this);
            this.viewControl.addComponentListener(this);
            this.viewControl.addTool(new ZoomRectangleTool(this.viewControl, this));
            this.viewControl.addTool(new PanTool(this.viewControl, this));
            this.viewControl.addTool(new ZoomWheelTool(this.viewControl, this));
        }
        return this.viewControl;
    }

    public void setRequestListener(IViewRequestManager er) {
        this.viewControl.setExtensionRequest(er);
    }

    @Override
    public void addGraphicLayer(IGraphicLayer graphicLayer) {
        this.getControl().setGraphicLayer(graphicLayer);
    }

    public ZoomCursorGraphicLayer getZoomCursorGraphicLayer() {
        if (this.zoomCursorGraphic == null) {
            this.zoomCursorGraphic = new ZoomCursorGraphicLayer(this.getWidth() / 2, this.getHeight() / 2, 12, 6, this.zoomCursorGraphicListener);
            this.zoomCursorGraphic.setGeoreferencingView(this);
            this.getControl().setGraphicLayer(this.zoomCursorGraphic);
        }
        return this.zoomCursorGraphic;
    }

    @Override
    public void setCursorPosition(int x, int y) {
        this.getZoomCursorGraphicLayer().setCursorPosition(x, y);
    }

    @Override
    public void setCursorSize(int w, int h) {
        this.getZoomCursorGraphicLayer().setCursorSize(w, h);
    }

    public void setShowInfo(boolean show) {
        this.viewControl.getCanvas().setShowInfo(show);
    }

    public Rectangle2D getCursorWorldCoordinates() {
        Rectangle2D r = this.getZoomCursorGraphicLayer().getCursorViewCoordinates();
        Point2D p1 = this.viewControl.getCanvas().viewCoordsToWorld(new Point2D.Double(r.getX(), r.getY()));
        Point2D p2 = this.viewControl.getCanvas().viewCoordsToWorld(new Point2D.Double(r.getX() + r.getWidth(), r.getY() + r.getHeight()));
        return new Rectangle2D.Double(Math.min(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.abs(p2.getX() - p1.getX()), Math.abs(p2.getY() - p1.getY()));
    }

    public Rectangle2D getCursorAdjustedWorldCoordinates(int wWindow, int hWindow) {
        Rectangle2D r = this.getZoomCursorGraphicLayer().getCursorViewCoordinates();
        double x = r.getX();
        double y = r.getY();
        double w = r.getWidth();
        double h = r.getHeight();
        try {
            if (wWindow < hWindow) {
                if (r.getWidth() / r.getHeight() >= (double)(wWindow / hWindow)) {
                    h = (double)hWindow * r.getWidth() / (double)wWindow;
                    y = r.getCenterY() - h / 2.0;
                } else {
                    w = (double)wWindow * r.getHeight() / (double)hWindow;
                    x = r.getCenterX() - w / 2.0;
                }
            } else if (r.getWidth() / r.getHeight() <= (double)(wWindow / hWindow)) {
                w = (double)wWindow * r.getHeight() / (double)hWindow;
                x = r.getCenterX() - w / 2.0;
            } else {
                h = (double)hWindow * r.getWidth() / (double)wWindow;
                y = r.getCenterY() - h / 2.0;
            }
        }
        catch (ArithmeticException ex) {
            LoggerFactory.getLogger(ViewPanelImpl.class).debug("Redimensi\u00f3n de las ventanas. La altura de estas es menor que cero", (Object)this, (Object)ex);
            return r;
        }
        r = this.viewControl.getCanvas().getMinxMaxyUL() ? new Rectangle2D.Double(x, y + h, w, h) : new Rectangle2D.Double(x, y - h, w, h);
        Point2D p1 = this.viewControl.getCanvas().viewCoordsToWorld(new Point2D.Double(r.getX(), r.getY()));
        Point2D p2 = this.viewControl.getCanvas().viewCoordsToWorld(new Point2D.Double(r.getX() + r.getWidth(), r.getY() + r.getHeight()));
        return new Rectangle2D.Double(Math.min(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.abs(p2.getX() - p1.getX()), Math.abs(p2.getY() - p1.getY()));
    }

    public Rectangle2D getViewExtent() {
        return this.viewControl.getCanvas().getExtent();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.viewControl.reload();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

