/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.rendering;

import java.util.ArrayList;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.rendering.legend.IInterval;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.AbstractClassifiedVectorLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.VectorialIntervalLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.rendering.GraduatedSymbolsLegend;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantityByCategoryLegend
extends AbstractClassifiedVectorLegend {
    private static final Logger logger = LoggerFactory.getLogger(QuantityByCategoryLegend.class);
    public static final String QUANTITY_BY_CATEGORY_LEGEND_PERSISTENCE_DEFINITION_NAME = "QUANTITY_BY_CATEGORY_LEGEND_PERSISTENCE_DEFINITION_NAME";
    public static final String QUANTITY_BY_CATEGORY_LEGEND_NAME = "QUANTITY_BY_CATEGORY_LEGEND_NAME";
    private GraduatedSymbolsLegend graduatedSymbol = new GraduatedSymbolsLegend();
    private VectorialIntervalLegend colorRamp = new VectorialIntervalLegend(this.getShapeType());
    private ISymbol defaultSymbol = null;
    private int shapeType = 3;
    private boolean isUseDefaultSymbol;

    public QuantityByCategoryLegend() {
        this.setShapeType(3);
        ISymbol def = MapContextLocator.getSymbolManager().createSymbol(this.getShapeType());
        this.setDefaultSymbol(def);
    }

    public void clear() {
        this.colorRamp.clear();
        this.graduatedSymbol.clear();
    }

    public String[] getClassifyingFieldNames() {
        int i;
        ArrayList<String> l = new ArrayList<String>();
        for (i = 0; i < this.graduatedSymbol.getClassifyingFieldNames().length; ++i) {
            l.add(this.graduatedSymbol.getClassifyingFieldNames()[i]);
        }
        for (i = 0; i < this.colorRamp.getClassifyingFieldNames().length; ++i) {
            l.add(this.colorRamp.getClassifyingFieldNames()[i]);
        }
        return l.toArray(new String[l.size()]);
    }

    public int[] getClassifyingFieldTypes() {
        int i;
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (i = 0; i < this.graduatedSymbol.getClassifyingFieldTypes().length; ++i) {
            l.add(this.graduatedSymbol.getClassifyingFieldTypes()[i]);
        }
        for (i = 0; i < this.colorRamp.getClassifyingFieldTypes().length; ++i) {
            l.add(this.colorRamp.getClassifyingFieldTypes()[i]);
        }
        int len = l.size();
        int[] resp = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            resp[i2] = (Integer)l.get(i2);
        }
        return resp;
    }

    public void setClassifyingFieldTypes(int[] fieldTypes) {
        if (fieldTypes.length == 2) {
            this.colorRamp.setClassifyingFieldTypes(new int[]{fieldTypes[1]});
            this.graduatedSymbol.setClassifyingFieldTypes(new int[]{fieldTypes[0]});
        } else {
            logger.info("Error: Unexpected array size (should be 2)");
        }
        super.setClassifyingFieldTypes(fieldTypes);
    }

    public void setClassifyingFieldNames(String[] fieldNames) {
        if (fieldNames.length == 2) {
            this.colorRamp.setClassifyingFieldNames(new String[]{fieldNames[1]});
            this.graduatedSymbol.setClassifyingFieldNames(new String[]{fieldNames[0]});
        } else {
            logger.info("Error: Unexpected array size (should be 2)");
        }
        super.setClassifyingFieldNames(fieldNames);
    }

    public void addSymbol(Object key, ISymbol symbol) {
        if (symbol instanceof IFillSymbol) {
            this.colorRamp.addSymbol(key, symbol);
        } else if (symbol instanceof IMarkerSymbol) {
            this.graduatedSymbol.addSymbol(key, symbol);
        }
        this.fireClassifiedSymbolChangeEvent(new SymbolLegendEvent(null, symbol));
    }

    public void delSymbol(Object key) {
        this.colorRamp.delSymbol(key);
        this.graduatedSymbol.delSymbol(key);
        this.fireClassifiedSymbolChangeEvent(new SymbolLegendEvent(null, null));
    }

    public String[] getDescriptions() {
        int i;
        String[] desc1 = this.colorRamp.getDescriptions();
        String[] desc2 = this.graduatedSymbol.getDescriptions();
        Object[] objects1 = this.colorRamp.getValues();
        Object[] objects2 = this.graduatedSymbol.getValues();
        ArrayList<String> descriptionsList = new ArrayList<String>();
        for (i = 0; i < objects1.length; ++i) {
            descriptionsList.add(desc1[i]);
        }
        for (i = 0; i < objects2.length; ++i) {
            descriptionsList.add(desc2[i]);
        }
        String[] descriptions = new String[descriptionsList.size()];
        descriptions = descriptionsList.toArray(descriptions);
        return descriptions;
    }

    public ISymbol[] getSymbols() {
        int i;
        ISymbol[] symbols1 = this.colorRamp.getSymbols();
        ISymbol[] symbols2 = this.graduatedSymbol.getSymbols();
        Object[] objects1 = this.colorRamp.getValues();
        Object[] objects2 = this.graduatedSymbol.getValues();
        ArrayList<ISymbol> symbolsList = new ArrayList<ISymbol>();
        for (i = 0; i < objects1.length; ++i) {
            symbolsList.add(symbols1[i]);
        }
        for (i = 0; i < objects2.length; ++i) {
            symbolsList.add(symbols2[i]);
        }
        ISymbol[] symbols = new ISymbol[symbolsList.size()];
        symbols = symbolsList.toArray(symbols);
        return symbols;
    }

    public Object[] getValues() {
        int i;
        Object[] objects1 = this.colorRamp.getValues();
        Object[] objects2 = this.graduatedSymbol.getValues();
        ArrayList<Object> objectsList = new ArrayList<Object>();
        for (i = 0; i < objects1.length; ++i) {
            if (objects1[i] instanceof IInterval) {
                objectsList.add(objects1[i]);
                continue;
            }
            objectsList.add(null);
        }
        for (i = 0; i < objects2.length; ++i) {
            if (objects2[i] instanceof IInterval) {
                objectsList.add(objects2[i]);
                continue;
            }
            objectsList.add(null);
        }
        Object[] objects = new IInterval[objectsList.size()];
        objects = objectsList.toArray(objects);
        return objects;
    }

    public Object clone() throws CloneNotSupportedException {
        QuantityByCategoryLegend resp = (QuantityByCategoryLegend)((Object)super.clone());
        resp.setShapeType(this.getShapeType());
        resp.useDefaultSymbol(this.isUseDefaultSymbol());
        ISymbol defsym = this.getDefaultSymbol();
        defsym = (ISymbol)defsym.clone();
        resp.setDefaultSymbol(defsym);
        GraduatedSymbolsLegend gleg = this.getGraduatedSymbolsLegend();
        gleg = (GraduatedSymbolsLegend)gleg.cloneLegend();
        resp.setGraduateSymbolLegend(gleg);
        VectorialIntervalLegend interleg = this.getColorRampLegend();
        interleg = (VectorialIntervalLegend)interleg.cloneLegend();
        resp.setColorRampLegend(interleg);
        return resp;
    }

    public GraduatedSymbolsLegend getGraduatedSymbolsLegend() {
        return this.graduatedSymbol;
    }

    public VectorialIntervalLegend getColorRampLegend() {
        return this.colorRamp;
    }

    public ISymbol getSymbolByFeature(Feature feat) throws MapContextException {
        ISymbol sym1 = null;
        ISymbol sym2 = null;
        sym1 = this.graduatedSymbol.getSymbolByFeature(feat);
        sym1 = GraduatedSymbolsLegend.toFillSymbol((ISymbol)sym1);
        sym2 = this.colorRamp.getSymbolByFeature(feat);
        IMultiLayerSymbol multiSym = null;
        int shpt = this.getShapeType();
        if (QuantityByCategoryLegend.isPolygonal(shpt)) {
            multiSym = MapContextLocator.getSymbolManager().createMultiLayerSymbol(3);
            if (sym2 != null) {
                multiSym.addLayer(sym2);
            }
            if (sym1 != null) {
                multiSym.addLayer(sym1);
            }
        } else {
            logger.info("Error: unexpected shape type (should be surface): " + shpt);
        }
        return multiSym;
    }

    public void setShapeType(int shpt) {
        this.shapeType = shpt;
        ISymbol sym = null;
        this.graduatedSymbol.setShapeType(1);
        sym = MapContextLocator.getSymbolManager().createSymbol(1);
        this.graduatedSymbol.setDefaultSymbol(sym);
        this.colorRamp.setShapeType(shpt);
        sym = MapContextLocator.getSymbolManager().createSymbol(shpt);
        this.colorRamp.setDefaultSymbol(sym);
    }

    public boolean isUseDefaultSymbol() {
        return this.isUseDefaultSymbol;
    }

    public void useDefaultSymbol(boolean b) {
        this.isUseDefaultSymbol = b;
    }

    public void setGraduateSymbolLegend(GraduatedSymbolsLegend legend) {
        this.graduatedSymbol = legend;
    }

    public void setColorRampLegend(VectorialIntervalLegend legend) {
        this.colorRamp = legend;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void replace(ISymbol oldSymbol, ISymbol newSymbol) {
        int i;
        ISymbol[] symbols = this.graduatedSymbol.getSymbols();
        for (i = 0; i < symbols.length; ++i) {
            if (!symbols[i].equals(oldSymbol)) continue;
            this.graduatedSymbol.replace(oldSymbol, newSymbol);
            return;
        }
        symbols = this.colorRamp.getSymbols();
        for (i = 0; i < symbols.length; ++i) {
            if (!symbols[i].equals(oldSymbol)) continue;
            this.colorRamp.replace(oldSymbol, newSymbol);
            return;
        }
    }

    public static boolean isPolygonal(int ty) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return geomManager.isSubtype(9, ty) || geomManager.isSubtype(3, ty);
    }

    public ISymbol getDefaultSymbol() {
        return this.defaultSymbol;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public void setDefaultSymbol(ISymbol s) {
        this.defaultSymbol = s;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("useDefaultSymbol", this.isUseDefaultSymbol());
        state.set("graduatedLegend", (Persistent)this.getGraduatedSymbolsLegend());
        state.set("rampLegend", (Persistent)this.getColorRampLegend());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        Boolean b = state.getBoolean("useDefaultSymbol");
        this.useDefaultSymbol(b);
        ILegend leg = (ILegend)state.get("graduatedLegend");
        if (!(leg instanceof GraduatedSymbolsLegend)) {
            throw new PersistenceException((Throwable)new ClassCastException("Unexpected legend type (" + leg + "). Should be GraduatedSymbolsLegend"));
        }
        this.setGraduateSymbolLegend((GraduatedSymbolsLegend)leg);
        leg = (ILegend)state.get("rampLegend");
        if (!(leg instanceof VectorialIntervalLegend)) {
            throw new PersistenceException((Throwable)new ClassCastException("Unexpected legend type (" + leg + "). Should be VectorialIntervalLegend"));
        }
        this.setColorRampLegend((VectorialIntervalLegend)leg);
    }

    public static class RegisterLegend
    implements Callable {
        public Object call() throws Exception {
            MapContextManager manager = MapContextLocator.getMapContextManager();
            manager.registerLegend(QuantityByCategoryLegend.QUANTITY_BY_CATEGORY_LEGEND_NAME, QuantityByCategoryLegend.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(QuantityByCategoryLegend.QUANTITY_BY_CATEGORY_LEGEND_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(QuantityByCategoryLegend.class, QuantityByCategoryLegend.QUANTITY_BY_CATEGORY_LEGEND_PERSISTENCE_DEFINITION_NAME, "QUANTITY_BY_CATEGORY_LEGEND_PERSISTENCE_DEFINITION_NAME Persistence definition", null, null);
                definition.extend(manager.getDefinition("ClassifiedVectorLegend"));
                definition.addDynFieldBoolean("useDefaultSymbol").setMandatory(true);
                definition.addDynFieldObject("graduatedLegend").setClassOfValue(ILegend.class).setMandatory(true);
                definition.addDynFieldObject("rampLegend").setClassOfValue(ILegend.class).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

