/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.app.extension;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.scripting.DataFolderFound;
import org.gvsig.scripting.app.extension.DataFoldersRecoverPanelView;
import org.gvsig.tools.swing.api.JListWithCheckbox;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class DataFoldersRecoverPanel
extends DataFoldersRecoverPanelView {
    private final List<DataFolderFound> dataFoldersFound;
    private JListWithCheckbox lstCheckedDataFolders;

    public DataFoldersRecoverPanel(List<DataFolderFound> dataFoldersFound) {
        this.dataFoldersFound = dataFoldersFound;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        this.lstCheckedDataFolders = manager.createJListWithCheckbox(this.lstDataFolders);
        DefaultListModel<ListElement> model = new DefaultListModel<ListElement>();
        for (DataFolderFound dataFolderFound : this.dataFoldersFound) {
            if (dataFolderFound.getApplicationFolder() == null) continue;
            model.addElement(new ListElement(dataFolderFound.getApplicationName() + " (" + dataFolderFound.getDataFolderId() + ")", (Object)dataFolderFound));
        }
        this.lstDataFolders.setModel(model);
        this.lstDataFolders.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                DataFoldersRecoverPanel.this.updateInterfaceData();
            }
        });
        this.setPreferredSize(new Dimension(500, 420));
    }

    private void updateInterfaceData() {
        DataFolderFound dataFolder = (DataFolderFound)ListElement.getSelected((JList)this.lstDataFolders);
        if (dataFolder == null) {
            return;
        }
        this.txtApplication.setText(dataFolder.getApplicationName());
        this.txtPreferencias.setText(dataFolder.getDataFolderId());
        this.txtPath.setText(dataFolder.getApplicationFolder().getUserPath());
        String path = dataFolder.getOldDataFolder().getAbsolutePath();
        this.txtOldFolder.setText(path);
        this.txtOldFolder.setCaretPosition(path.length());
    }

    public List<DataFolderFound> getSelectedDataFolders() {
        ArrayList<DataFolderFound> r = new ArrayList<DataFolderFound>();
        ListSelectionModel checkedModel = this.lstCheckedDataFolders.getCheckedModel();
        for (int i = 0; i < this.dataFoldersFound.size(); ++i) {
            if (!checkedModel.isSelectedIndex(i)) continue;
            r.add(this.dataFoldersFound.get(i));
        }
        return r;
    }
}

