/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.app.extension;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.plugins.PluginClassLoader;
import org.gvsig.scripting.ScriptingLocator;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.app.extension.PostProcessArguments;
import org.gvsig.scripting.app.extension.ScriptingUtils;
import org.gvsig.scripting.app.extension.ScriptsInstallerInitializer;
import org.gvsig.tools.script.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingExtension
extends Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptingExtension.class);
    private ScriptingUtils utils;

    @Deprecated
    public static void log(String message) {
        ScriptingUtils.log(0, message, null);
    }

    @Deprecated
    public static void log(int level, String message) {
        ScriptingUtils.log(level, message, null);
    }

    @Deprecated
    public static void log(int level, String message, Throwable th) {
        ScriptingUtils.log(level, message, th);
    }

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"tools-scripting-launcher", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"tools-scripting-composer", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"tools-scripting-console-jython", (Object)((Object)this));
        PluginsManager pluginManager = PluginsLocator.getManager();
        this.utils = new ScriptingUtils();
        this.utils.initializaPaths(pluginManager.getPluginsFolders(), pluginManager.getInstallFolder(), this.getPlugin().getPluginHomeFolder(), pluginManager.getApplicationVersion().format("%M.%m.%r"));
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptingExtension.this.preloadPythonEngine();
            }
        }, "ScriptEnginesInitializer");
        th.start();
        try {
            th.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ScriptingUtils getScriptingUtils() {
        return this.utils;
    }

    public void execute(String actionCommand) {
        this.execute(actionCommand, null);
    }

    public void execute(String command, Object[] args) {
        if ("tools-scripting-launcher".equalsIgnoreCase(command)) {
            this.utils.runLauncher();
        } else if ("tools-scripting-composer".equalsIgnoreCase(command)) {
            this.utils.runComposer();
        } else {
            this.utils.runScript(command, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadPythonEngine() {
        ScriptingManager manager;
        ScriptingManager scriptingManager = manager = ScriptingLocator.getManager();
        synchronized (scriptingManager) {
            String respath = "/scripting/langs/python/preload.py";
            InputStream res = ((Object)((Object)this)).getClass().getResourceAsStream(respath);
            if (res != null) {
                LOGGER.info("Scan for script engines");
                try {
                    List lines = IOUtils.readLines((InputStream)res);
                    String code = StringUtils.join((Iterable)lines, (String)"\n");
                    LOGGER.info("Preload python script engine");
                    Script script = manager.createScript("preload", code, "python");
                    LOGGER.info("Preload python modules");
                    script.invokeFunction("main", null);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't run preload script for python.", (Throwable)ex);
                }
                LOGGER.info("Preload of script engines finished");
            }
        }
    }

    public void postInitialize() {
        super.postInitialize();
        PluginsManager pluginManager = PluginsLocator.getManager();
        pluginManager.addStartupTask("ExecuteAutorunScripts", this.utils.getAutorunScriptsOnStartup(pluginManager.getPluginsFolders()), false, 200);
        pluginManager.addStartupTask("PostProcessArguments", (Runnable)new PostProcessArguments(), false, 199);
        ScriptsInstallerInitializer initializer = new ScriptsInstallerInitializer();
        initializer.call(new Object[]{this.getPlugin().getPluginName()});
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public static void add_classpath(URL url) {
        if (url == null) {
            LOGGER.warn("Can't add to the plugin classloader a null URL.");
            return;
        }
        try {
            PluginsManager manager = PluginsLocator.getManager();
            PluginServices thePlugin = manager.getPlugin(ScriptingExtension.class);
            PluginClassLoader loader = thePlugin.getClassLoader();
            loader.addURL(url);
        }
        catch (Throwable th) {
            LOGGER.warn("Can't add the url '" + url.toString() + "' to the plugin classloader.", th);
        }
    }

    public static void add_classpath(File path) {
        if (path == null) {
            LOGGER.warn("Can't create a url from a null file.");
            return;
        }
        try {
            URL url = path.toURI().toURL();
            ScriptingExtension.add_classpath(url);
        }
        catch (MalformedURLException ex) {
            LOGGER.warn("Can't create a url from the path '" + path + "'.", (Throwable)ex);
        }
    }

    public static void add_classpath(String path) {
        if (path == null) {
            LOGGER.warn("Can't create a url from a null path.");
            return;
        }
        File f = new File(path);
        ScriptingExtension.add_classpath(f);
    }

    public PluginServices getPlugin() {
        PluginServices thePlugin = super.getPlugin();
        if (thePlugin == null) {
            thePlugin = PluginsLocator.getManager().getPlugin(ScriptingExtension.class);
            this.setPlugin(thePlugin);
        }
        return thePlugin;
    }
}

