/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.app.extension;

import java.io.File;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.spi.InstallerProviderLocator;
import org.gvsig.installer.lib.spi.InstallerProviderManager;
import org.gvsig.scripting.ScriptingLocator;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.app.extension.ScriptingUtils;
import org.gvsig.tools.service.spi.ProviderFactory;
import org.gvsig.tools.util.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptsInstallerInitializer
implements Invocable {
    public static final String VERSION_FORMAT = "%M.%m.%r";
    private static final Logger LOG = LoggerFactory.getLogger(ScriptsInstallerInitializer.class);

    public Object call(Object ... args) {
        try {
            String pluginName = (String)args[0];
            InstallerProviderManager providerManager = InstallerProviderLocator.getProviderManager();
            PluginsManager pluginManager = PluginsLocator.getManager();
            ScriptingManager manager = ScriptingLocator.getManager();
            InstallerManager installerManager = InstallerLocator.getInstallerManager();
            File pluginHomeFolder = pluginManager.getPluginHomeFolder(pluginName);
            String gvsigversion = pluginManager.getApplicationVersion().format(VERSION_FORMAT);
            File home = ScriptingUtils.getScriptsHomeFolder(pluginHomeFolder, gvsigversion);
            manager.setHomeFolder(home);
            manager.setPackagesFolder(pluginManager.getInstallFolder());
            File localAddonRepositoryFolder = new File(manager.getRootUserFolder(), "addons");
            ProviderFactory factory = manager.getInstallerFactory();
            providerManager.addProviderFactory(factory);
            installerManager.setDefaultLocalAddonRepository(localAddonRepositoryFolder, factory.getName());
            return true;
        }
        catch (Exception ex) {
            LOG.warn("Problems initializing scripts installer.", (Throwable)ex);
            return false;
        }
    }
}

