/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.csv;

import java.util.ArrayList;
import org.gvsig.fmap.dal.DALFileLibrary;
import org.gvsig.fmap.dal.DALFileLocator;
import org.gvsig.fmap.dal.DALLibrary;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerManager;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.store.csv.CSVFilesystemServerProvider;
import org.gvsig.fmap.dal.store.csv.CSVNewStoreParameters;
import org.gvsig.fmap.dal.store.csv.CSVStoreParameters;
import org.gvsig.fmap.dal.store.csv.CSVStoreProvider;
import org.gvsig.fmap.dal.store.csv.CSVStoreProviderFactory;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;

public class CSVLibrary
extends AbstractLibrary {
    public void doRegistration() {
        this.registerAsServiceOf(DALLibrary.class);
        this.require(DALFileLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        ArrayList<Throwable> exs = new ArrayList<Throwable>();
        try {
            FileHelper.registerParametersDefinition((String)"CSVStoreParameters", CSVStoreParameters.class, (String)"CSVParameters.xml");
            FileHelper.registerParametersDefinition((String)"CSVNewStoreParameters", CSVNewStoreParameters.class, (String)"CSVParameters.xml");
        }
        catch (Exception e) {
            exs.add(e);
        }
        try {
            FileHelper.registerMetadataDefinition((String)"CSV", CSVStoreProvider.class, (String)"CSVMetadata.xml");
        }
        catch (MetadataException e) {
            exs.add(e);
        }
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            if (!dataman.getStoreProviders().contains("CSV")) {
                dataman.registerStoreProviderFactory((DataStoreProviderFactory)new CSVStoreProviderFactory("CSV", "CSV file"));
            }
        }
        catch (RuntimeException e) {
            exs.add(e);
        }
        try {
            FilesystemServerExplorerManager filesystemServerExplorerManager = DALFileLocator.getFilesystemServerExplorerManager();
            filesystemServerExplorerManager.registerProvider("CSV", "CSV file", CSVFilesystemServerProvider.class);
        }
        catch (RuntimeException e) {
            exs.add(e);
        }
        if (exs.size() > 0) {
            throw new LibraryException(((Object)((Object)this)).getClass(), exs);
        }
    }
}

