/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.csv;

import java.io.File;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.store.csv.CSVFeatureTypeLoader;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderFeatureTypeLoader;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreParameters;
import org.gvsig.tools.dynobject.DynObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.quote.AlwaysQuoteMode;
import org.supercsv.quote.NormalQuoteMode;
import org.supercsv.quote.QuoteMode;

public class CSVStoreParameters
extends SimpleReaderStoreParameters
implements OpenFeatureStoreParameters,
FilesystemStoreParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVStoreParameters.class);
    public static final String PARAMETERS_DEFINITION_NAME = "CSVStoreParameters";
    private static final String PROFILE = "profile";
    private static final String QUOTEPOLICY = "quotePolicy";
    private static final String QUOTECHAR = "quoteCharacter";
    private static final String RECORDSEPARATOR = "recordSeparator";
    private static final String DELIMITER = "delimiter";
    private static final String COMMENTSTARTMARKER = "commentStartMarker";
    private static final String ESCAPECHARACTER = "escapeCharacter";
    public static final String FIRST_LINE_HEADER = "firstLineHeader";
    private static final String SURROUNDINGSPACESNEEDQUOTES = "surroundingSpacesNeedQuotes";
    private static final String POINT_COLUMN_NAME = "pointColumnName";
    private static final String INCLUDE_METADATA_IN_HEADER = "includeMetadataInHeader";
    private static final String GEOMETRY_COLUMN = "geometry_column";
    private static final String GEOMETRY_TYPE = "GeometryType";
    private static final String GEOMETRY_SUBTYPE = "GeometrySubtype";
    private static final String GEOMETRY_FORMAT = "GeometryFormat";

    public CSVStoreParameters() {
        this(PARAMETERS_DEFINITION_NAME);
    }

    protected CSVStoreParameters(String parametersDefinitionName) {
        super(parametersDefinitionName, "CSV");
    }

    protected SimpleReaderFeatureTypeLoader getFeatureTypeLoader() {
        return new CSVFeatureTypeLoader(this);
    }

    public void validate() throws ValidateDataParametersException {
        super.validate();
        FeatureType ftype = this.getFeatureType();
        if (ftype != null) {
            FeatureAttributeDescriptor attrgeom = ftype.getDefaultGeometryAttribute();
            if (attrgeom != null) {
                this.setDynValue(GEOMETRY_COLUMN, attrgeom.getName());
                this.setDynValue(GEOMETRY_TYPE, attrgeom.getGeomType().getType());
                this.setDynValue(GEOMETRY_SUBTYPE, attrgeom.getGeomType().getSubType());
            } else {
                this.setDynValue(GEOMETRY_COLUMN, null);
                this.setDynValue(GEOMETRY_TYPE, -1);
                this.setDynValue(GEOMETRY_SUBTYPE, 4);
            }
        }
    }

    public static CsvPreference getPredefinedCSVPreferences(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(PROFILE);
        if ("NONE".equalsIgnoreCase(s)) {
            return null;
        }
        if ("STANDARD_PREFERENCE".equalsIgnoreCase(s)) {
            return CsvPreference.STANDARD_PREFERENCE;
        }
        if ("EXCEL_PREFERENCE".equalsIgnoreCase(s)) {
            return CsvPreference.EXCEL_PREFERENCE;
        }
        if ("EXCEL_NORTH_EUROPE_PREFERENCE".equalsIgnoreCase(s)) {
            return CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE;
        }
        if ("TAB_PREFERENCE".equalsIgnoreCase(s)) {
            return CsvPreference.TAB_PREFERENCE;
        }
        return null;
    }

    public static QuoteMode getQuoteMode(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(QUOTEPOLICY);
        if ("AlwaysQuoteMode".equalsIgnoreCase(s)) {
            return new AlwaysQuoteMode();
        }
        if ("NormalQuoteMode".equalsIgnoreCase(s)) {
            return new NormalQuoteMode();
        }
        return null;
    }

    public static IProjection getCRS(DynObject dynobj) {
        return (IProjection)dynobj.getDynValue("CRS");
    }

    public static String getFileName(DynObject dynobj) {
        File f = (File)dynobj.getDynValue("file");
        if (f == null) {
            return null;
        }
        return f.getPath();
    }

    public static String getRecordSeparator(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(RECORDSEPARATOR);
        return StringEscapeUtils.unescapeJava((String)s);
    }

    public static String getGeometryColumn(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(GEOMETRY_COLUMN);
        return s;
    }

    public static int getGeometryType(DynObject dynobj) {
        Integer gtype = (Integer)dynobj.getDynValue(GEOMETRY_TYPE);
        if (gtype == null) {
            return -1;
        }
        return gtype;
    }

    public static String getGeometryFormat(DynObject dynobj) {
        String gformat = (String)dynobj.getDynValue(GEOMETRY_FORMAT);
        if (StringUtils.isBlank((CharSequence)gformat)) {
            return "WKT";
        }
        return gformat;
    }

    public static int getGeometrySubType(DynObject dynobj) {
        Integer gsubtype = (Integer)dynobj.getDynValue(GEOMETRY_SUBTYPE);
        if (gsubtype == null) {
            return 4;
        }
        return gsubtype;
    }

    public static boolean isBlankOrDefaultLocale(DynObject dynobj) {
        String s = (String)dynobj.getDynValue("locale");
        if (StringUtils.isBlank((CharSequence)s)) {
            return true;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)"DEFAULT", (CharSequence)s.trim());
    }

    public static String getCommentStartMarker(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(COMMENTSTARTMARKER);
        return StringEscapeUtils.unescapeJava((String)s);
    }

    public static String getPointColumnName(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(POINT_COLUMN_NAME);
        return s;
    }

    public static String getQuoteCharacter(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(QUOTECHAR);
        if (StringUtils.isBlank((CharSequence)(s = StringEscapeUtils.unescapeJava((String)s)))) {
            return null;
        }
        return s.substring(0, 1);
    }

    public static String getDelimiter(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(DELIMITER);
        if (StringUtils.isBlank((CharSequence)(s = StringEscapeUtils.unescapeJava((String)s)))) {
            return null;
        }
        return s.substring(0, 1);
    }

    public static String[] getHeaders(DynObject dynobj) {
        String s = CSVStoreParameters.getHeader((DynObject)dynobj);
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        String sep = CSVStoreParameters.getDelimiter(dynobj);
        if (sep == null && (sep = CSVStoreParameters.getDelimiter((String)s)) == null) {
            return null;
        }
        String[] ss = s.split("[" + sep + "]");
        return ss;
    }

    public static String[] getPointDimensionNames(DynObject dynobj) {
        String s = (String)dynobj.getDynValue("point");
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s.split(",");
    }

    public static boolean getSurroundingSpacesNeedQuotes(DynObject dynobj) {
        Boolean b = (Boolean)dynobj.getDynValue(SURROUNDINGSPACESNEEDQUOTES);
        return BooleanUtils.isTrue((Boolean)b);
    }

    public static boolean getIncludeMetadataInHeader(DynObject dynobj) {
        Boolean b = (Boolean)dynobj.getDynValue(INCLUDE_METADATA_IN_HEADER);
        return BooleanUtils.isTrue((Boolean)b);
    }

    public static boolean isFirstLineHeader(DynObject dynobj) {
        Boolean b = (Boolean)dynobj.getDynValue(FIRST_LINE_HEADER);
        return BooleanUtils.isTrue((Boolean)b);
    }

    public boolean isTheSameExplorer(DataStoreParameters parameters) {
        return FilesystemStoreParameters.isTheSameExplorer((DataStoreParameters)this, (DataStoreParameters)parameters);
    }
}

