/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.csv.virtualrows;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RandomAccessFileIndex;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RandomAccessFileReader;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.library.impl.DefaultLibrariesInitializer;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.gvsig.tools.util.GetItemWithSize64;

public class TextFileAsList
extends AbstractList<String>
implements Closeable,
GetItemWithSize64<String> {
    private final RandomAccessFileReader reader;
    private final RandomAccessFileIndex index;

    public TextFileAsList(File text, File index, Charset charset) throws IOException {
        this.reader = new RandomAccessFileReader(text, charset);
        this.index = new RandomAccessFileIndex(index);
    }

    public TextFileAsList(RandomAccessFileReader reader, RandomAccessFileIndex index) throws IOException {
        this.reader = reader;
        this.index = index;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Reader)this.reader);
        IOUtils.closeQuietly((Closeable)this.index);
    }

    @Override
    public String get(int index) {
        try {
            long pos = this.index.get(index);
            this.reader.seek(pos);
            return this.nextLine();
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't access to " + index + " element.", ex);
        }
    }

    @Override
    public int size() {
        return this.index.size();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public long size64() {
        return this.index.size64();
    }

    public String get64(long position) {
        try {
            long pos = this.index.get64(position);
            this.reader.seek(pos);
            return this.nextLine();
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't access to " + position + " element.", ex);
        }
    }

    private String nextLine() throws IOException {
        BufferedReader br = new BufferedReader((Reader)this.reader);
        String line = br.readLine();
        return line;
    }

    public static void main(String[] args) throws Exception {
        new DefaultLibrariesInitializer().fullInitialize();
        String fname = "/home/jjdelcerro/Descargas/test/esp_poblaciones.csv";
        File data_file = new File(fname);
        File index_file = new File(FilenameUtils.removeExtension((String)data_file.getAbsolutePath()) + ".idx");
        TaskStatusManager taskStatusManager = ToolsLocator.getTaskStatusManager();
        taskStatusManager.addObserver((observable, notification) -> {
            TaskStatus status = taskStatusManager.getRunningTaskStatusMostRecent();
        });
        SimpleTaskStatus status = taskStatusManager.createDefaultSimpleTaskStatus(data_file.getName());
        status.add();
        RandomAccessFileReader reader = new RandomAccessFileReader(data_file, "UTF-8");
        RandomAccessFileIndex index_lines = reader.createOrOpenIndexOfLines(index_file, RandomAccessFileReader.FILTER_NONE, null);
        TextFileAsList text = new TextFileAsList(reader, index_lines);
        System.out.println("Lines: " + text.size());
        int n = 0;
        for (String line : text) {
            if (n < 100) {
                System.out.println(String.format("%6d: %s", n, line));
            } else if (n == 100) {
                System.out.println("More records...");
            }
            ++n;
        }
        System.out.println("-----------------");
        long t1 = new Date().getTime();
        for (int i = text.size() - 1; i >= 0; --i) {
            String line = (String)text.get(i);
            if (i < 100) {
                System.out.println(String.format("%6d: %s", i, line));
                continue;
            }
            if (i != 100) continue;
            System.out.println("More records...");
        }
        long t2 = new Date().getTime();
        System.out.println("Time: " + (t2 - t1) + " ms");
        IOUtils.closeQuietly((Closeable)text);
    }
}

