/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante.core;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.gui.core.DefaultTaskMonitor;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.NullOutputChannel;
import java.util.Date;
import javax.swing.JDialog;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.Utilities;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.ProjectPreferences;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.geoprocess.lib.sextante.dataObjects.BufferWriteOnlyIRasterLayer;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FLyrRasterIRasterLayer;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FileTools;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.geoprocess.lib.sextante.dataObjects.TableDocumentITable;
import org.gvsig.geoprocess.lib.sextante.outputs.CompositeSourceIOutputChannel;

public class DefaultOutputFactory
extends OutputFactory {
    public IVectorLayer getNewVectorLayer(String name, int shapeType, Class[] types, String[] fields, IOutputChannel channel, Object crs, int subtype) throws UnsupportedOutputChannelException {
        int[] sizes = this.getSizesFromTypeClass(types);
        return this.getNewVectorLayer(name, shapeType, types, fields, channel, crs, sizes, subtype);
    }

    public IVectorLayer getNewVectorLayer(String name, int shapeType, Class[] types, String[] fields, IOutputChannel channel, Object crs) throws UnsupportedOutputChannelException {
        int[] sizes = this.getSizesFromTypeClass(types);
        return this.getNewVectorLayer(name, shapeType, types, fields, channel, crs, sizes, 4);
    }

    private int[] getSizesFromTypeClass(Class[] types) {
        int[] sizes = new int[types.length];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = this.getSizeFromTypeClass(types[i]);
        }
        return sizes;
    }

    public IVectorLayer getNewVectorLayer(String sName, int iShapeType, Class[] types, String[] sFields, IOutputChannel channel, Object crs, int[] fieldSize) throws UnsupportedOutputChannelException {
        return this.getNewVectorLayer(sName, iShapeType, types, sFields, channel, crs, fieldSize, 4);
    }

    public IVectorLayer getNewVectorLayer(String sName, int iShapeType, Class[] types, String[] sFields, IOutputChannel channel, Object crs, int[] fieldSize, int subtype) throws UnsupportedOutputChannelException {
        if (fieldSize == null) {
            fieldSize = this.getSizesFromTypeClass(types);
        } else {
            for (int i = 0; i < fieldSize.length; ++i) {
                int value = fieldSize[i];
                fieldSize[i] = value <= 0 ? this.getSizeFromTypeClass(types[i]) : Math.min(fieldSize[i], this.getSizeFromTypeClass(types[i]));
            }
        }
        if (channel != null) {
            if (channel instanceof CompositeSourceIOutputChannel) {
                FlyrVectIVectorLayer layer = new FlyrVectIVectorLayer();
                Object inputParams = ((CompositeSourceIOutputChannel)channel).getParameters();
                layer.create(sName, inputParams, iShapeType, types, sFields, crs, fieldSize, subtype);
                return layer;
            }
            if (channel instanceof FileOutputChannel) {
                FlyrVectIVectorLayer layer = new FlyrVectIVectorLayer();
                String fileName = ((FileOutputChannel)channel).getFilename();
                layer.create(sName, fileName, iShapeType, types, sFields, crs, fieldSize, subtype);
                return layer;
            }
            if (channel instanceof NullOutputChannel) {
                return null;
            }
        }
        throw new UnsupportedOutputChannelException();
    }

    public IRasterLayer getNewRasterLayer(String sName, int iDataType, AnalysisExtent extent, int iBands, IOutputChannel channel, Object crs) throws UnsupportedOutputChannelException {
        if (channel instanceof FileOutputChannel) {
            String sFilename = ((FileOutputChannel)channel).getFilename();
            BufferWriteOnlyIRasterLayer layer = new BufferWriteOnlyIRasterLayer();
            layer.create(sName, sFilename, extent, iDataType, iBands, crs);
            return layer;
        }
        throw new UnsupportedOutputChannelException();
    }

    public IRasterLayer getNewEmptyRORasterLayer(String sName, int iDataType, AnalysisExtent extent, int iBands, IOutputChannel channel, Object crs) throws UnsupportedOutputChannelException {
        if (channel instanceof FileOutputChannel) {
            String sFilename = ((FileOutputChannel)channel).getFilename();
            FLyrRasterIRasterLayer layer = new FLyrRasterIRasterLayer(sFilename);
            return layer;
        }
        throw new UnsupportedOutputChannelException();
    }

    public ITable getNewTable(String sName, Class[] types, String[] sFields, IOutputChannel channel) throws UnsupportedOutputChannelException {
        if (channel instanceof FileOutputChannel) {
            String sFilename = ((FileOutputChannel)channel).getFilename();
            TableDocumentITable table = new TableDocumentITable();
            table.create(sName, sFilename, types, sFields);
            return table;
        }
        throw new UnsupportedOutputChannelException();
    }

    public String getTempFolder() {
        return Utilities.createTempDirectory();
    }

    public String[] getRasterLayerOutputExtensions() {
        return FileTools.RASTER_EXT_IN;
    }

    public String[] getVectorLayerOutputExtensions() {
        return new String[]{"shp", "dxf"};
    }

    public String[] getTableOutputExtensions() {
        return new String[]{"dbf"};
    }

    public void addMessage(String s) {
        NotificationManager.addInfo((String)s, null);
    }

    public ITaskMonitor getTaskMonitor(String sTitle, boolean bDeterminate, JDialog parent) {
        return new DefaultTaskMonitor(sTitle, bDeterminate, parent);
    }

    public Object getDefaultCRS() {
        IWindow window = PluginServices.getMDIManager().getActiveWindow();
        if (window == null || !(window instanceof AbstractViewPanel)) {
            IWindow[] windowList = PluginServices.getMDIManager().getAllWindows();
            for (int i = 0; i < windowList.length; ++i) {
                if (!(windowList[i] instanceof AbstractViewPanel)) continue;
                window = windowList[i];
                break;
            }
        }
        if (window != null && window instanceof AbstractViewPanel) {
            return ((AbstractViewPanel)window).getMapControl().getProjection();
        }
        return ((ProjectPreferences)ApplicationLocator.getManager().getPreferences("project")).getDefaultProjection();
    }

    private int getSizeFromTypeClass(Class<?> type) {
        if (type.equals(Integer.class)) {
            return 10;
        }
        if (type.equals(Long.class)) {
            return 20;
        }
        if (type.equals(Double.class)) {
            return 20;
        }
        if (type.equals(Float.class)) {
            return 15;
        }
        if (type.equals(String.class)) {
            return 255;
        }
        if (type.equals(Date.class)) {
            return 10;
        }
        if (type.equals(Boolean.class)) {
            return 1;
        }
        return 20;
    }
}

