/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante.dataObjects;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.dataObjects.AbstractRasterLayer;
import es.unex.sextante.outputs.IOutputChannel;
import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.grid.Grid;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.raster.fmap.layers.FLyrRaster;

public class FLyrRasterReadOnlyIRasterLayer_deprecated
extends AbstractRasterLayer {
    private Grid m_LayerGrid = null;
    private FLyrRaster m_Layer = null;
    private Buffer m_Buffer = null;
    private int m_iDataType = 0;
    private double m_dNoDataValue = 0.0;
    private int xTranslate = 0;
    private int yTranslate = 0;
    private AnalysisExtent layerExtent = null;

    public void create(FLyrRaster obj) {
        this.m_Layer = obj;
    }

    public int getDataType() {
        return this.m_Layer.getDataStore().getDataType()[0];
    }

    public void setCellValue(int x, int y, int iBand, double dValue) {
    }

    public void setNoDataValue(double dNoDataValue) {
        this.m_Layer.getNoDataValue().setValue((Number)dNoDataValue);
    }

    public void setNoData(int x, int y) {
    }

    public double getNoDataValue() {
        return this.m_dNoDataValue;
    }

    public double getCellValueInLayerCoords(int x, int y, int iBand) {
        int newx = x - this.xTranslate;
        int newy = y - this.yTranslate;
        if (this.m_Buffer.isInside(newx, newy)) {
            switch (this.m_iDataType) {
                case 0: {
                    return this.m_Buffer.getElemByte(newy, newx, iBand);
                }
                case 2: {
                    return this.m_Buffer.getElemShort(newy, newx, iBand);
                }
                case 3: {
                    return this.m_Buffer.getElemInt(newy, newx, iBand);
                }
                case 4: {
                    return this.m_Buffer.getElemFloat(newy, newx, iBand);
                }
            }
            return this.m_Buffer.getElemDouble(newy, newx, iBand);
        }
        return this.m_dNoDataValue;
    }

    public int getBandsCount() {
        return this.m_Layer.getDataStore().getBandCount();
    }

    public String getName() {
        return this.m_Layer.getName();
    }

    public void postProcess() {
    }

    public void open() {
    }

    public void close() {
        this.m_LayerGrid = null;
    }

    public Rectangle2D getFullExtent() {
        return this.m_Layer.getFullRasterExtent().toRectangle2D();
    }

    public AnalysisExtent getLayerGridExtent() {
        if (this.layerExtent == null) {
            try {
                this.layerExtent = new AnalysisExtent();
                this.layerExtent.setCellSize(this.m_Layer.getDataStore().getCellSize());
                Extent ext = this.m_Layer.getFullRasterExtent();
                this.layerExtent.setXRange(ext.minX(), ext.maxX(), true);
                this.layerExtent.setYRange(ext.minY(), ext.maxY(), true);
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.layerExtent;
    }

    public void setWindowExtent(AnalysisExtent extent) {
        super.setWindowExtent(extent);
        RasterManager rManager = RasterLocator.getManager();
        RasterDataStore store = this.m_Layer.getDataStore();
        RasterQuery query = rManager.createQuery();
        query.setReadOnly(true);
        int[] bands = new int[store.getBandCount()];
        for (int i = 0; i < store.getBandCount(); ++i) {
            bands[i] = i;
        }
        query.setDrawableBands(bands);
        Extent ext = RasterLocator.getManager().getDataStructFactory().createExtent(extent.getXMin(), extent.getYMax(), extent.getXMax(), extent.getYMin());
        query.setAreaOfInterest(ext, extent.getNX(), extent.getNY());
        Buffer entireBuf = this.m_Buffer;
        try {
            this.m_Buffer = store.query(query);
            Extent lyrExt = this.m_Layer.getFullRasterExtent();
            double distx = extent.getXMin() - lyrExt.minX();
            double disty = lyrExt.maxY() - extent.getYMax();
            this.xTranslate = (int)Math.round(distx * (double)extent.getNX() / (extent.getXMax() - extent.getXMin()));
            this.yTranslate = (int)Math.round(disty * (double)extent.getNY() / (extent.getYMax() - extent.getYMin()));
        }
        catch (QueryException e) {
            this.m_Buffer = entireBuf;
        }
        catch (ProcessInterruptedException processInterruptedException) {
            // empty catch block
        }
    }

    public double getLayerCellSize() {
        return this.m_Layer.getDataStore().getCellSize();
    }

    public Object getCRS() {
        return this.m_Layer.getProjection();
    }

    public void setName(String name) {
        this.m_Layer.setName(name);
    }

    public void free() {
        this.m_Layer.dispose();
        this.m_Layer = null;
        this.m_LayerGrid = null;
    }

    public Object getBaseDataObject() {
        return this.m_Layer;
    }

    public IOutputChannel getOutputChannel() {
        return new IOutputChannel(){

            public String getAsCommandLineParameter() {
                return FLyrRasterReadOnlyIRasterLayer_deprecated.this.m_Layer.getName();
            }
        };
    }
}

