/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante.dataObjects;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.Sextante;
import java.awt.geom.AffineTransform;
import java.io.File;
import org.cresques.cts.IProjection;
import org.gvsig.andami.Utilities;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;

public class RasterDriver {
    public static final int RASTER_DATA_TYPE_FLOAT = 4;
    public static final int RASTER_DATA_TYPE_DOUBLE = 5;
    public static final int RASTER_DATA_TYPE_INT = 3;
    public static final int RASTER_DATA_TYPE_SHORT = 2;
    public static final int RASTER_DATA_TYPE_BYTE = 0;
    private final AnalysisExtent m_GridExtent;
    private Buffer buf = null;
    private String name = null;

    public RasterDriver(AnalysisExtent ae, int iDataType, int iNumBands) {
        this.buf = RasterLocator.getManager().createBuffer(iDataType, ae.getNX(), ae.getNY(), iNumBands, true);
        this.m_GridExtent = ae;
    }

    public RasterDriver(AnalysisExtent ae, int iDataType) {
        this(ae, iDataType, 1);
    }

    public AnalysisExtent getGridExtent() {
        return this.m_GridExtent;
    }

    public Buffer getRasterBuf() {
        return this.buf;
    }

    public void reset() {
        this.free();
    }

    public void setCellValue(int x, int y, double dValue) {
        this.setCellValue(x, y, 0, dValue);
    }

    public void setNoData(int x, int y) {
        this.setNoData(x, y, 0);
    }

    private void setNoData(int x, int y, int iBand) {
        this.setCellValue(x, y, iBand, this.getNoDataValue());
    }

    public void setCellValue(int x, int y, int iBand, double dValue) {
        if (this.isInGrid(x, y) && iBand < this.buf.getBandCount()) {
            switch (this.buf.getDataType()) {
                case 0: {
                    this.buf.setElem(y, x, iBand, (byte)dValue);
                    break;
                }
                case 2: {
                    this.buf.setElem(y, x, iBand, (short)dValue);
                    break;
                }
                case 3: {
                    this.buf.setElem(y, x, iBand, (int)dValue);
                    break;
                }
                case 4: {
                    this.buf.setElem(y, x, iBand, (float)dValue);
                    break;
                }
                default: {
                    this.buf.setElem(y, x, iBand, dValue);
                }
            }
        }
    }

    public double getNoDataValue() {
        NoData nodata = this.buf.getNoDataValue();
        return nodata != null ? (nodata.getValue() != null ? nodata.getValue().doubleValue() : 0.0) : 0.0;
    }

    public void setNoDataValue(double dNoDataValue) {
        if (this.buf.getNoDataValue() == null) {
            NoData nodata = RasterLocator.getManager().getDataStructFactory().createNoData((Number)dNoDataValue, null, null);
            this.buf.setNoDataValue(nodata);
        } else {
            this.buf.getNoDataValue().setValue((Number)dNoDataValue);
        }
    }

    public double getCellValue(int x, int y) {
        return this.getCellValue(x, y, 0);
    }

    public double getCellValue(int x, int y, int iBand) {
        if (this.isInGrid(x, y) && iBand < this.buf.getBandCount()) {
            switch (this.buf.getDataType()) {
                case 0: {
                    return this.buf.getElemByte(y, x, iBand);
                }
                case 2: {
                    return this.buf.getElemShort(y, x, iBand);
                }
                case 3: {
                    return this.buf.getElemInt(y, x, iBand);
                }
                case 4: {
                    return this.buf.getElemFloat(y, x, iBand);
                }
                case 5: {
                    return this.buf.getElemDouble(y, x, iBand);
                }
            }
            return this.getNoDataValue();
        }
        return this.getNoDataValue();
    }

    public boolean isNoDataValue(double dNoDataValue) {
        return this.getNoDataValue() == dNoDataValue;
    }

    public boolean isInGrid(int x, int y) {
        if (x < 0 || y < 0) {
            return false;
        }
        return x < this.m_GridExtent.getNX() && y < this.m_GridExtent.getNY();
    }

    public double getCellSize() {
        return this.m_GridExtent.getCellSize();
    }

    public static String getFilename(String sRoot, String sExtension) {
        String sFilename;
        File file;
        int i = 1;
        sRoot = sRoot.toLowerCase();
        sRoot = sRoot.replaceAll(" ", "_");
        sRoot = sRoot.replaceAll("\\)", "");
        sRoot = sRoot.replaceAll("\\(", "_");
        sRoot = sRoot.replaceAll("\\[", "_");
        sRoot = sRoot.replaceAll("\\]", "");
        sRoot = sRoot.replaceAll("<", "_");
        sRoot = sRoot.replaceAll(">", "_");
        sRoot = sRoot.replaceAll("__", "_");
        while ((file = new File(sFilename = Utilities.createTempDirectory() + File.separator + sRoot + Integer.toString(i) + "." + sExtension)).exists()) {
            ++i;
        }
        return sFilename;
    }

    public boolean export(String sFilename, IProjection projection) {
        try {
            RasterManager manager = RasterLocator.getManager();
            DataServerWriter writerBufferServer = manager.createDataServerWriter();
            writerBufferServer.setBuffer(this.buf, -1);
            Params params = manager.createWriterParams(sFilename);
            AffineTransform affineTransform = new AffineTransform(this.m_GridExtent.getCellSize(), 0.0, 0.0, -this.m_GridExtent.getCellSize(), this.m_GridExtent.getXMin(), this.m_GridExtent.getYMax());
            RasterWriter writer = manager.createWriter(writerBufferServer, sFilename, this.buf.getBandCount(), affineTransform, this.buf.getWidth(), this.buf.getHeight(), this.buf.getDataType(), params, projection);
            writer.dataWrite();
            writer.writeClose();
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void free() {
        if (this.buf != null) {
            this.buf.dispose();
            this.buf = null;
        }
    }
}

