/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.spatialjoin;

import es.unex.sextante.core.Sextante;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.exception.FeatureIndexException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.dissolve.Summary;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;

public class IntersectsSpatialJoinOperation
extends GeometryOperation {
    private SpatialIndex index = null;
    private Summary summary = null;
    private FeatureStore storeOverlay = null;
    private FeatureSelection featureSelection = null;

    public IntersectsSpatialJoinOperation(FlyrVectIVectorLayer targetLayer, SpatialIndex index, Summary summary, AbstractSextanteGeoProcess p) {
        super(p);
        this.index = index;
        this.summary = summary;
        this.storeOverlay = targetLayer.getFeatureStore();
    }

    public EditableFeature invoke(final Geometry g, Feature featureInput) {
        if (g == null) {
            return this.lastEditFeature;
        }
        if (this.featureSelection == null) {
            try {
                this.featureSelection = this.storeOverlay.getFeatureSelection();
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }
        try {
            final MutableBoolean first = new MutableBoolean(true);
            final MutableInt numReg = new MutableInt(0);
            this.index.query(g, new Visitor(){

                public void visit(Object obj) throws VisitCanceledException, BaseException {
                    FeatureReference ref = (FeatureReference)obj;
                    Feature feat = ref.getFeature();
                    Geometry g2 = feat.getDefaultGeometry();
                    if (g.intersects(g2)) {
                        if (first.getValue().booleanValue()) {
                            IntersectsSpatialJoinOperation.this.summary.loadDefaultSummarizes(feat);
                            first.setFalse();
                        }
                        IntersectsSpatialJoinOperation.this.summary.updateValues(feat);
                        numReg.increment();
                    }
                }
            });
            this.buildNewFeature(featureInput, this.summary, numReg.getValue());
        }
        catch (FeatureIndexException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return this.lastEditFeature;
    }

    private void buildNewFeature(Feature feat, Summary summary, int numReg) throws DataException {
        EditableFeature outFeat = this.persister.getOutputFeatureStore().createNewFeature(feat);
        summary.loadEditableFeature(outFeat);
        outFeat.set("NUM_RELA", (Object)new Integer(numReg));
        try {
            List l = feat.getGeometries();
            if (l == null) {
                this.persister.addFeature((Feature)outFeat, feat.getDefaultGeometry());
            } else {
                EditableFeature editFeat = null;
                for (int i = 0; i < l.size(); ++i) {
                    if (editFeat == null) {
                        editFeat = this.persister.addFeature((Feature)outFeat, (Geometry)l.get(i));
                        continue;
                    }
                    this.persister.addGeometryToExistingFeature(editFeat, (Geometry)l.get(i));
                }
            }
        }
        catch (CreateGeometryException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void invoke(Geometry g, EditableFeature featureInput) {
    }
}

