/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.spatialjoin;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.geoprocess.algorithm.spatialjoin.SpatialJoinAlgorithm;
import org.gvsig.geoprocess.lib.api.GeoProcessLocator;
import org.gvsig.geoprocess.sextante.gui.algorithm.AlgorithmOutputPanel;
import org.gvsig.gui.beans.table.TableContainer;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;

public class SpatialJoinParametersPanel
extends GeoAlgorithmParametersPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private GeoAlgorithm m_Algorithm = null;
    private JComboBox layersCombo = null;
    private JComboBox layersJoinCombo = null;
    private JCheckBox selectionInput = null;
    private JCheckBox selectionOverlay = null;
    private JCheckBox nearest = null;
    private AlgorithmOutputPanel output = null;
    private final String[] columnNames = new String[]{"Min", "Max", "Sum", "Avg", "Field ID"};
    private final int[] columnWidths = new int[]{35, 35, 35, 35, 334};
    private TableContainer table = null;
    private OutputChannelSelectionPanel outputChannelSelectionPanel;
    private JPanel outputPanel;

    public void init(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.initGUI();
    }

    private void initGUI() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 8, 0);
        this.add(this.getComboPanel(GeoProcessLocator.getGeoProcessManager().getTranslation("input_layers"), this.getLayers1Combo()), gbc);
        gbc.gridy = 1;
        this.add(this.getComboPanel(GeoProcessLocator.getGeoProcessManager().getTranslation("input_layers_join"), this.getLayers2Combo()), gbc);
        gbc.gridy = 2;
        this.add(this.getSelectionInputCheck(), gbc);
        gbc.gridy = 3;
        this.add(this.getSelectionOverlayCheck(), gbc);
        gbc.gridy = 4;
        this.add(this.getNearestCheck(), gbc);
        gbc.gridy = 5;
        this.add(new JLabel(GeoProcessLocator.getGeoProcessManager().getTranslation("summary_function")), gbc);
        gbc.gridy = 6;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 12, 0);
        gbc.weighty = 1.0;
        this.add((Component)this.getRadioButtonTable(), gbc);
        gbc.gridy = 7;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.add(this.getOutputChannelSelectionPanel(), gbc);
        this.initTable();
        this.getRadioButtonTable().setVisible(false);
    }

    private JPanel getOutputChannelSelectionPanel() {
        if (this.outputPanel == null) {
            try {
                this.outputPanel = new JPanel();
                this.outputPanel.setLayout(new BorderLayout());
                OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
                Output out = ooSet.getOutput("RESULT");
                this.outputChannelSelectionPanel = new OutputChannelSelectionPanel(out, this.m_Algorithm.getParameters());
                this.outputPanel.add((Component)new JLabel(GeoProcessLocator.getGeoProcessManager().getTranslation("Spatialjoin") + " [" + GeoProcessLocator.getGeoProcessManager().getTranslation("Vectorial") + "]                        "), "West");
                this.outputPanel.add((Component)this.outputChannelSelectionPanel, "Center");
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        return this.outputPanel;
    }

    private AlgorithmOutputPanel getAlgorithmOutputPanel() {
        if (this.output == null) {
            this.output = new AlgorithmOutputPanel();
        }
        return this.output;
    }

    public JPanel getComboPanel(String text, JComboBox combo) {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 2, 0, 5);
        JLabel label = new JLabel(text);
        label.setPreferredSize(new Dimension(180, 18));
        panel.add((Component)label, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 2, 0, 0);
        panel.add((Component)combo, gbc);
        return panel;
    }

    public JComboBox getLayers1Combo() {
        if (this.layersCombo == null) {
            this.layersCombo = new JComboBox();
            this.layersCombo.setPreferredSize(new Dimension(0, 18));
            DefaultComboBoxModel<ObjectAndDescription> comboModel = new DefaultComboBoxModel<ObjectAndDescription>(this.getLayerList());
            this.layersCombo.setModel(comboModel);
            this.layersCombo.addActionListener(this);
        }
        return this.layersCombo;
    }

    public JComboBox getLayers2Combo() {
        if (this.layersJoinCombo == null) {
            this.layersJoinCombo = new JComboBox();
            this.layersJoinCombo.setPreferredSize(new Dimension(0, 18));
            DefaultComboBoxModel<ObjectAndDescription> comboModel = new DefaultComboBoxModel<ObjectAndDescription>(this.getLayerList());
            this.layersJoinCombo.setModel(comboModel);
            this.layersJoinCombo.addActionListener(this);
        }
        return this.layersJoinCombo;
    }

    public JCheckBox getSelectionInputCheck() {
        if (this.selectionInput == null) {
            this.selectionInput = new JCheckBox(GeoProcessLocator.getGeoProcessManager().getTranslation("Selected_geometries_input_layer"));
        }
        return this.selectionInput;
    }

    public JCheckBox getSelectionOverlayCheck() {
        if (this.selectionOverlay == null) {
            this.selectionOverlay = new JCheckBox(GeoProcessLocator.getGeoProcessManager().getTranslation("Selected_geometries_overlay_layer"));
        }
        return this.selectionOverlay;
    }

    public JCheckBox getNearestCheck() {
        if (this.nearest == null) {
            this.nearest = new JCheckBox(GeoProcessLocator.getGeoProcessManager().getTranslation("use_the_nearest"));
            this.nearest.setSelected(true);
            this.nearest.addActionListener(this);
        }
        return this.nearest;
    }

    public TableContainer getRadioButtonTable() {
        if (this.table == null) {
            this.table = new TableContainer(this.columnNames, this.columnWidths, null);
            this.table.setModel("ARGBBandSelectorModel");
            this.table.setControlVisible(false);
            this.table.initialize();
        }
        return this.table;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getNearestCheck()) {
            if (!this.getNearestCheck().isSelected()) {
                this.getRadioButtonTable().setVisible(true);
            } else {
                this.getRadioButtonTable().setVisible(false);
            }
        }
        if (e.getSource() == this.getLayers2Combo()) {
            this.initTable();
            IVectorLayer lyr = this.getSelectedVectorLayer2();
            Class[] types = lyr.getFieldTypes();
            boolean hasNumericField = false;
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != Integer.class && types[i] != Double.class && types[i] != Float.class && types[i] != Short.class) continue;
                hasNumericField = true;
                break;
            }
            if (!hasNumericField) {
                this.getNearestCheck().setSelected(true);
            }
        }
    }

    private void initTable() {
        try {
            this.getRadioButtonTable().removeAllRows();
            if (this.getSelectedVectorLayer2() == null) {
                return;
            }
            Class[] types = this.getSelectedVectorLayer2().getFieldTypes();
            for (int i = 0; i < this.getSelectedVectorLayer2().getFieldCount(); ++i) {
                if (!Number.class.isAssignableFrom(types[i])) continue;
                this.addTableRow(this.getSelectedVectorLayer2().getFieldName(i));
            }
        }
        catch (NotInitializeException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void addTableRow(String fieldName) throws NotInitializeException {
        Object[] row = new Object[]{new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), fieldName};
        this.getRadioButtonTable().addRow(row);
    }

    public void assignParameters() {
        try {
            ParametersSet params = this.m_Algorithm.getParameters();
            params.getParameter("LAYER1").setParameterValue((Object)this.getSelectedVectorLayer());
            params.getParameter("LAYER2").setParameterValue((Object)this.getSelectedVectorLayer2());
            params.getParameter("SELECTGEOM_INPUT").setParameterValue((Object)this.getSelectionInputCheck().isSelected());
            params.getParameter("SELECTGEOM_OVERLAY").setParameterValue((Object)this.getSelectionOverlayCheck().isSelected());
            params.getParameter("NEAREST").setParameterValue((Object)this.getNearestCheck().isSelected());
            params.getParameter("FUNCTION_LIST").setParameterValue((Object)this.getValues());
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            Output out = ooSet.getOutput("RESULT");
            out.setOutputChannel(this.outputChannelSelectionPanel.getOutputChannel());
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void setOutputValue(String arg0, String arg1) {
    }

    public void setParameterValue(String arg0, String arg1) {
    }

    private ObjectAndDescription[] getLayerList() {
        IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(-1);
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            oad[i] = new ObjectAndDescription(layers[i].getName(), (Object)layers[i]);
        }
        return oad;
    }

    private IVectorLayer getSelectedVectorLayer() {
        if (this.layersCombo.getSelectedItem() != null) {
            return (IVectorLayer)((ObjectAndDescription)this.layersCombo.getSelectedItem()).getObject();
        }
        return null;
    }

    private IVectorLayer getSelectedVectorLayer2() {
        if (this.layersJoinCombo.getSelectedItem() != null) {
            return (IVectorLayer)((ObjectAndDescription)this.layersJoinCombo.getSelectedItem()).getObject();
        }
        return null;
    }

    public String[] getFieldList() {
        IVectorLayer layer = this.getSelectedVectorLayer2();
        String[] data = new String[layer.getFieldCount()];
        for (int i = 0; i < layer.getFieldCount(); ++i) {
            data[i] = layer.getFieldName(i);
        }
        return data;
    }

    private String getValues() {
        String str = "";
        try {
            for (int i = 0; i < this.getRadioButtonTable().getRowCount(); ++i) {
                str = str + (String)this.getRadioButtonTable().getModel().getValueAt(i, 4) + ",";
                for (int j = 0; j < this.getRadioButtonTable().getModel().getColumnCount() - 1; ++j) {
                    if (!((Boolean)this.getRadioButtonTable().getModel().getValueAt(i, j)).booleanValue()) continue;
                    str = str + SpatialJoinAlgorithm.Summary[j] + ",";
                }
                str = str.substring(0, str.length() - 1) + ";";
            }
        }
        catch (NotInitializeException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        if (str.isEmpty()) {
            return str;
        }
        return str.substring(0, str.length() - 1);
    }
}

