/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.app.symbolinstaller.execution;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.execution.InstallPackageServiceException;
import org.gvsig.installer.lib.spi.InstallPackageProviderServices;
import org.gvsig.installer.lib.spi.InstallerProviderLocator;
import org.gvsig.installer.lib.spi.InstallerProviderManager;
import org.gvsig.installer.lib.spi.execution.InstallPackageProvider;
import org.gvsig.tools.service.spi.AbstractProvider;
import org.gvsig.tools.service.spi.ProviderServices;

public class SymbolInstallerExecutionProvider
extends AbstractProvider
implements InstallPackageProvider {
    private final File symbolsFolder;

    public SymbolInstallerExecutionProvider(ProviderServices providerServices, File symbolsFolder) {
        super(providerServices);
        this.symbolsFolder = symbolsFolder;
    }

    public void install(File applicationDirectory, InputStream inputStream, PackageInfo packageInfo) throws InstallPackageServiceException {
        try {
            if (!this.symbolsFolder.exists()) {
                throw new InstallerSymbolsDirectoryNotFoundException();
            }
            InstallerProviderManager installerProviderManager = InstallerProviderLocator.getProviderManager();
            InstallPackageProviderServices installerProviderServices = installerProviderManager.createInstallerProviderServices();
            installerProviderServices.decompress(inputStream, this.symbolsFolder);
        }
        catch (Exception e) {
            throw new InstallPackageServiceException((Throwable)e);
        }
    }

    public void installLater(File applicationDirectory, InputStream inputStream, PackageInfo packageInfo) throws InstallPackageServiceException, IOException {
    }

    public class InstallerSymbolsDirectoryNotFoundException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = 4416143986837955880L;
        private static final String message = "Symbols directory not found";
        private static final String KEY = "symbols_directory_not_found";

        public InstallerSymbolsDirectoryNotFoundException() {
            super(message, KEY, 4416143986837955880L);
        }
    }
}

