/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.app.symbolinstaller.execution;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.spi.InstallerProviderLocator;
import org.gvsig.installer.lib.spi.InstallerProviderManager;
import org.gvsig.symbology.app.symbolinstaller.execution.SymbolInstallerExecutionProviderFactory;
import org.gvsig.tools.service.spi.ProviderFactory;
import org.gvsig.tools.util.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolsInstallerInitializer
implements Invocable {
    private static final Logger LOG = LoggerFactory.getLogger(SymbolsInstallerInitializer.class);

    public Object call(Object ... args) {
        PluginsManager pluginManager = PluginsLocator.getManager();
        File symbolsFolder = FileUtils.getFile((File)pluginManager.getApplicationHomeFolder(), (String[])new String[]{"plugins", "org.gvsig.app.mainplugin", "Symbols"});
        this.perform((String)args[0], symbolsFolder);
        return true;
    }

    public void perform(String pluginName, File symbolsFolder) {
        try {
            InstallerManager installerManager = InstallerLocator.getInstallerManager();
            InstallerProviderManager providerManager = InstallerProviderLocator.getProviderManager();
            SymbolInstallerExecutionProviderFactory factory = new SymbolInstallerExecutionProviderFactory(symbolsFolder);
            providerManager.addProviderFactory((ProviderFactory)factory);
            installerManager.setDefaultLocalAddonRepository(symbolsFolder, factory.getName());
        }
        catch (Exception ex) {
            LOG.warn("Problems initializing scripts installer.", (Throwable)ex);
        }
    }
}

