/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.fusespatially;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.core.DALFeaturePersister;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;

public class FuseSpatiallyOperation
extends GeometryOperation {
    protected GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private int id = 0;
    private List<Feature> featList = null;
    private FeatureStore outFeatureStoreTable = null;
    private String idField = "FID";

    public FuseSpatiallyOperation(List<Feature> f, FeatureStore outFeatStoreTable, String[] fieldNames, String idField, AbstractSextanteGeoProcess p) throws DataException {
        super(p);
        this.featList = f;
        this.outFeatureStoreTable = outFeatStoreTable;
        this.idField = idField;
    }

    public FuseSpatiallyOperation(Stack<Feature> f, FeatureStore outFeatStoreTable, String[] fieldNames, AbstractSextanteGeoProcess p) throws DataException {
        super(p);
        this.featList = f;
        this.outFeatureStoreTable = outFeatStoreTable;
    }

    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature feature) {
        try {
            Geometry jtsInputGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g);
            this.insertInTable(feature);
            for (int cont = this.featList.size() - 1; cont >= 0 && !this.process.getTaskMonitor().isCanceled(); --cont) {
                Feature f = this.featList.get(cont);
                g = f.getDefaultGeometry();
                Geometry jtsGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g);
                if (!jtsGeom.intersects(jtsInputGeom)) continue;
                jtsInputGeom = jtsInputGeom.union(jtsGeom);
                this.featList.remove(cont);
                this.process.setProgress(this.procesSize - this.featList.size(), this.procesSize);
                cont = this.featList.size();
                this.insertInTable(f);
            }
            if (this.outFeatureStoreTable == null) {
                String[] fieldNames = this.persister.getFieldNamesWithoutGeom();
                ArrayList<String> fields = new ArrayList<String>();
                ArrayList<Object> values = new ArrayList<Object>();
                fields.add(this.idField);
                values.add(this.id);
                for (int j = 0; j < fieldNames.length; ++j) {
                    Object obj = feature.get(fieldNames[j]);
                    if (obj == null || fieldNames[j].compareTo(this.idField) == 0) continue;
                    fields.add(fieldNames[j]);
                    values.add(obj);
                }
                this.lastEditFeature = this.persister.addFeature(jtsInputGeom, fields, values);
            } else {
                this.lastEditFeature = this.persister.addFeature(jtsInputGeom, this.idField, (Object)this.id);
            }
        }
        catch (DataException e) {
            return null;
        }
        catch (CreateGeometryException e) {
            return null;
        }
        ++this.id;
        return this.lastEditFeature;
    }

    private void insertInTable(Feature f) throws DataException {
        if (this.outFeatureStoreTable == null) {
            return;
        }
        EditableFeature edFeat = this.outFeatureStoreTable.createNewFeature();
        edFeat.set(this.idField, (Object)this.id);
        FeatureAttributeDescriptor[] attrList = f.getType().getAttributeDescriptors();
        for (int j = 0; j < attrList.length; ++j) {
            if (attrList[j].getName().compareTo("GEOMETRY") == 0) continue;
            edFeat.set(attrList[j].getName(), f.get(attrList[j].getName()));
        }
        this.outFeatureStoreTable.insert(edFeat);
    }

    public static String[] checkFields(String[] names) {
        if (names.length <= 1) {
            return names;
        }
        int cont = 0;
        for (int i = 1; i < names.length; ++i) {
            if (names[0].compareTo(names[i]) != 0) continue;
            names[0] = "FID_" + cont;
            i = 0;
            ++cont;
        }
        return names;
    }

    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature feature) {
        if (g == null) {
            return;
        }
    }

    public Object getResult() {
        return this.lastEditFeature;
    }

    public DALFeaturePersister getWriter() {
        return this.persister;
    }
}

