/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.report;

import javax.swing.AbstractAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.swing.report.ReportAction;
import org.gvsig.fmap.dal.swing.report.ReportActionFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportAction
extends AbstractAction
implements ReportAction {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractReportAction.class);
    private final ReportActionFactory factory;
    private SimpleTaskStatus status = null;
    private String reportName;

    protected AbstractReportAction(ReportActionFactory factory, String label) {
        this.factory = factory;
        if (label == null) {
            this.putValue("Name", factory.getName());
        } else {
            this.putValue("Name", label);
        }
    }

    @Override
    public ReportActionFactory getFactory() {
        return this.factory;
    }

    @Override
    public String getTypeName() {
        return this.factory.getName();
    }

    @Override
    public String getReportName() {
        return this.reportName;
    }

    @Override
    public void setReportName(String name) {
        this.reportName = name;
    }

    @Override
    public String getReportLabel() {
        return (String)this.getValue("Name");
    }

    @Override
    public void setReportLabel(String label) {
        this.putValue("Name", label);
    }

    public String getLabel() {
        return this.getReportLabel();
    }

    public ReportAction getValue() {
        return this;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public SimpleTaskStatus getStatus() {
        if (this.status == null) {
            this.status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Report " + this.getLabel());
        }
        return this.status;
    }

    @Override
    public FeatureSet rows() {
        return FeatureSet.EMPTY_FEATURESET;
    }

    @Override
    public String formatFieldValue(Feature feature, String fieldname) {
        if (StringUtils.isBlank((CharSequence)fieldname)) {
            LOGGER.warn("Illegal fieldname value (null)");
            return "NULL";
        }
        if (feature == null) {
            LOGGER.warn("Can't access attribute '" + fieldname + "', feature is null.");
            return "NULL";
        }
        String v = null;
        try {
            v = feature.getLabelOfValue(fieldname);
        }
        catch (Exception ex) {
            LOGGER.debug("Esto no deberia estar pasando (1)!!!", (Throwable)ex);
        }
        try {
            v = StringEscapeUtils.escapeHtml4((String)v);
        }
        catch (Exception ex) {
            LOGGER.debug("Esto no deberia estar pasando (2)!!!", (Throwable)ex);
        }
        return v;
    }
}

