/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.lib.impl;

import java.awt.geom.AffineTransform;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPointList;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.algorithm.util.Interpolation;
import org.gvsig.raster.georeferencing.lib.impl.GeoTransformProcess;

public class GeoreferencingProcess
extends DataProcess
implements IProcessActions {
    public static String RASTER_STORE = "RasterStore";
    public static String GCPS = "gcps";
    public static String ORDER = "Order";
    public static String RESULT = "RESULT";
    public static String FILENAME = "FileName";
    public static String XCELLSIZE = "xCellSize";
    public static String YCELLSIZE = "yCellSize";
    public static String INTERPOLATION = "InterpolationMethod";
    public static String PROJECTION = "projection";
    private RasterDataStore store = null;
    private String filename = null;
    private GeoPointList gcps = null;
    private int rMethod = 0;
    private int orden = 0;
    private int[] bands = null;
    private double xCellSize = 0.0;
    private double yCellSize = 0.0;
    private DataServerWriter writerBufferServer = null;
    private IProjection projection;

    public static void registerParameters() {
        GeoreferencingProcess.registerInputParameter((String)RASTER_STORE, RasterDataStore.class, (String)"GeoreferencingProcess");
        GeoreferencingProcess.registerInputParameter((String)INTERPOLATION, Integer.class, (String)"GeoreferencingProcess");
        GeoreferencingProcess.registerInputParameter((String)GCPS, GeoPointList.class, (String)"GeoreferencingProcess");
        GeoreferencingProcess.registerInputParameter((String)ORDER, Integer.class, (String)"GeoreferencingProcess");
        GeoreferencingProcess.registerOutputParameter((String)TIME, Long.class, (String)"GeoreferencingProcess");
        GeoreferencingProcess.registerOutputParameter((String)PROJECTION, IProjection.class, (String)"GeoreferencingProcess");
    }

    public void init() {
        this.store = this.getParam(RASTER_STORE) != null ? (RasterDataStore)this.getParam(RASTER_STORE) : null;
        this.gcps = this.getParam(GCPS) != null ? (GeoPointList)this.getParam(GCPS) : null;
        this.filename = (String)this.getParam(FILENAME);
        this.rMethod = this.getIntParam(INTERPOLATION);
        this.orden = this.getIntParam(ORDER);
        this.bands = new int[this.store.getBandCount()];
        this.xCellSize = this.getDoubleParam("xCellSize");
        this.yCellSize = this.getDoubleParam("yCellSize");
        this.projection = (IProjection)this.getParam(PROJECTION);
        for (int i = 0; i < this.store.getBandCount(); ++i) {
            this.bands[i] = i;
        }
    }

    public void process() throws ProcessInterruptedException, ProcessException {
        Buffer bufInput;
        RasterQuery query = RasterLocator.getManager().createQuery();
        query.setAllDrawableBands();
        query.setAreaOfInterest();
        query.setReadOnly(true);
        try {
            bufInput = this.store.query(query);
        }
        catch (QueryException e1) {
            throw new ProcessException("Error getting the input buffer", (Throwable)e1);
        }
        GeoTransformProcess transform = new GeoTransformProcess();
        transform.setActions(this);
        transform.addParam(GCPS, this.gcps);
        transform.addParam(ORDER, new Integer(this.orden));
        transform.execute();
        double[] p1 = transform.getCoordMap(0.0, 0.0);
        double[] p2 = transform.getCoordMap(this.store.getWidth(), 0.0);
        double[] p3 = transform.getCoordMap(0.0, this.store.getHeight());
        double[] p4 = transform.getCoordMap(this.store.getWidth(), this.store.getHeight());
        double xmin = Math.min(Math.min(p1[0], p3[0]), Math.min(p2[0], p4[0]));
        double ymin = Math.min(Math.min(p3[1], p4[1]), Math.min(p1[1], p2[1]));
        double xmax = Math.max(Math.max(p2[0], p4[0]), Math.max(p1[0], p3[0]));
        double ymax = Math.max(Math.max(p1[1], p2[1]), Math.max(p3[1], p4[1]));
        int w = 0;
        int h = 0;
        if (this.xCellSize >= 0.0 && this.yCellSize >= 0.0) {
            w = (int)((xmax - xmin) / this.xCellSize);
            h = (int)((ymax - ymin) / this.yCellSize);
        }
        int dataType = this.store.getDataType()[0];
        Buffer bufResult = RasterLocator.getManager().createBuffer(dataType, w, h, this.store.getBandCount(), true);
        NoData nd = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(this.store.getBandCount(), dataType);
        Interpolation interpolation = new Interpolation(bufInput);
        double[] coord = null;
        double[] values = new double[this.bands.length];
        for (int row = 0; row < bufResult.getHeight(); ++row) {
            for (int col = 0; col < bufResult.getWidth(); ++col) {
                coord = transform.getCoordPixel((double)col * this.xCellSize + xmin, ymax - (double)row * this.yCellSize);
                for (int iBand = 0; iBand < this.store.getBandCount(); ++iBand) {
                    values[iBand] = coord[0] < 0.0 || coord[1] < 0.0 || coord[0] > (double)(bufInput.getWidth() - 1) || coord[1] > (double)(bufInput.getHeight() - 1) ? nd.getValue().doubleValue() : (this.rMethod == 2 ? interpolation.getBilinearValue(coord[0], coord[1], iBand) : (this.rMethod == 3 ? interpolation.getInverseDistance(coord[0], coord[1], iBand) : interpolation.getNearestNeighbour(coord[0], coord[1], iBand)));
                    if (dataType == 0) {
                        bufResult.setElem(row, col, iBand, (byte)values[iBand]);
                        continue;
                    }
                    if (dataType == 5) {
                        bufResult.setElem(row, col, iBand, values[iBand]);
                        continue;
                    }
                    if (dataType == 4) {
                        bufResult.setElem(row, col, iBand, (float)values[iBand]);
                        continue;
                    }
                    if (dataType == 2) {
                        bufResult.setElem(row, col, iBand, (short)values[iBand]);
                        continue;
                    }
                    if (dataType != 3) continue;
                    bufResult.setElem(row, col, iBand, (int)values[iBand]);
                }
            }
            this.updatePercent(row, bufResult.getHeight());
        }
        this.export(this.filename, bufResult, this.xCellSize, this.yCellSize, xmin, ymax);
        this.addOutputValue(FILENAME, this.filename);
    }

    public boolean export(String sFilename, Buffer buf, double xcellsize, double ycellsize, double minX, double maxY) {
        try {
            RasterManager manager = RasterLocator.getManager();
            this.writerBufferServer = manager.createDataServerWriter();
            this.writerBufferServer.setBuffer(buf, -1);
            Params params = manager.createWriterParams(sFilename);
            AffineTransform affineTransform = new AffineTransform(xcellsize, 0.0, 0.0, -ycellsize, minX, maxY);
            RasterWriter writer = manager.createWriter(this.writerBufferServer, sFilename, buf.getBandCount(), affineTransform, buf.getWidth(), buf.getHeight(), buf.getDataType(), params, this.projection);
            writer.dataWrite();
            writer.writeClose();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getTitle() {
        return Messages.getText((String)"georreferenciacion_process");
    }

    public String getLog() {
        return Messages.getText((String)"georreferencing_log_message");
    }

    public void interrupted() {
    }

    public void end(Object param) {
    }

    public void updateProgress(int current, int total) {
    }
}

