/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.principalcomponents.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.JPanel;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.BasicAPISwingPanel;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.algorithm.process.ProcessParamsManagement;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.principalcomponents.algorithm.PCStatsDataStructure;
import org.gvsig.raster.principalcomponents.app.MainWindow;
import org.gvsig.raster.principalcomponents.app.PrincipalComponentsTocMenuEntry;
import org.gvsig.raster.principalcomponents.app.ProcessEndActions;
import org.gvsig.raster.principalcomponents.app.toolbox.ToolboxPCLoader;
import org.gvsig.raster.principalcomponents.swing.PrincipalComponentsSwingLibrary;
import org.gvsig.raster.principalcomponents.swing.PrincipalComponentsSwingLocator;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;

public class PrincipalComponentsExtension
extends Extension
implements ActionListener,
IProcessActions {
    private BasicAPISwingPanel mainPanel = null;
    private BasicAPISwingPanel componentsPanel = null;
    private MainWindow windowMainPanel = null;
    private MainWindow windowComponentsPanel = null;
    private MainWindow statisticsPanel = null;
    private FLyrRaster lyr = null;
    private PCStatsDataStructure stats = null;

    public void initialize() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add("GenericToolBarMenu");
        point.append("PrincipalComponents", "", (ExtensionBuilder)PrincipalComponentsTocMenuEntry.getSingleton());
        PrincipalComponentsTocMenuEntry.setExtension(this);
        Messages.addResourceFamily((String)"org.gvsig.raster.principalcomponents.app.i18n.text", (ClassLoader)PrincipalComponentsExtension.class.getClassLoader(), (String)PrincipalComponentsExtension.class.getClass().getName());
        this.initilizeIcons();
    }

    public void postInitialize() {
        new ToolboxPCLoader().registerTool();
    }

    public void execute(String actionCommand) {
        if (actionCommand.compareTo("PrincipalComponents") == 0) {
            this.lyr = this.getSelectedLayer();
            if (this.lyr == null) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"layer_not_found"), null);
                return;
            }
            String defaultROIEPSG = this.getFirstMapCtrl().getProjection().getAbrev();
            this.mainPanel = PrincipalComponentsSwingLocator.getSwingManager().createPCAMainPanel((Object)this.lyr.getDataStore(), this.lyr.getName(), this.lyr.getDataStore().getBandCount(), defaultROIEPSG);
            this.windowMainPanel = new MainWindow(this.mainPanel.getComponent(), Messages.getText((String)"principal_components"), 400, 350, this);
            PluginServices.getMDIManager().addCentredWindow((IWindow)this.windowMainPanel);
            this.mainPanel.initialize();
        }
    }

    private MapControl getFirstMapCtrl() {
        IWindow[] windowList = PluginServices.getMDIManager().getOrderedWindows();
        for (int i = 0; i < windowList.length; ++i) {
            if (!(windowList[i] instanceof IView)) continue;
            return ((IView)windowList[i]).getMapControl();
        }
        return null;
    }

    private FLyrRaster getSelectedLayer() {
        MapControl firstMapCtrl = this.getFirstMapCtrl();
        if (firstMapCtrl != null) {
            FLayer[] lyrList = firstMapCtrl.getMapContext().getLayers().getActives();
            for (int i = 0; i < lyrList.length; ++i) {
                if (!(lyrList[i] instanceof FLyrRaster)) continue;
                return (FLyrRaster)lyrList[i];
            }
        }
        return null;
    }

    public boolean isEnabled() {
        FLyrRaster selectedLayer = this.getSelectedLayer();
        if (selectedLayer == null) {
            return false;
        }
        if (!(selectedLayer instanceof ILayerState)) {
            return false;
        }
        if (!((ILayerState)selectedLayer).isOpen()) {
            return false;
        }
        return selectedLayer.getRender().getFilterList().get("colortable") == null;
    }

    public boolean isVisible() {
        FLyrRaster selectedLayer = this.getSelectedLayer();
        if (selectedLayer == null) {
            return false;
        }
        if (!(selectedLayer instanceof IRasterLayerActions)) {
            return false;
        }
        return ((IRasterLayerActions)selectedLayer).isActionEnabled(13);
    }

    void initilizeIcons() {
        IconThemeHelper.registerIcon(null, (String)"principal-components", (Object)this);
        IconThemeHelper.registerIcon(null, (String)"gvsig-icon", (Object)this);
        IconThemeHelper.registerIcon(null, (String)"gvsig-icon16x16", (Object)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataProcess task;
        if (e.getSource() == this.windowMainPanel.getButtonsPanel().getButton(3) || e.getSource() == this.windowMainPanel.getButtonsPanel().getButton(1)) {
            task = null;
            try {
                task = (DataProcess)this.mainPanel.getResult();
            }
            catch (Exception e1) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"problems_creating_process"), null);
                return;
            }
            task.setActions((IProcessActions)this);
            task.init();
            task.start();
        }
        if (this.componentsPanel != null && PrincipalComponentsSwingLibrary.GENERATE_STATIST == this.componentsPanel.getComponentIDByObject(e.getSource())) {
            try {
                Object[] result = (Object[])this.componentsPanel.getResult();
                JPanel statsPanel = PrincipalComponentsSwingLocator.getSwingManager().createStatisticsPanel(this.stats, ((Boolean)result[1]).booleanValue(), ((Boolean)result[2]).booleanValue(), ((Boolean)result[3]).booleanValue());
                this.statisticsPanel = new MainWindow(statsPanel, Messages.getText((String)"stats"), 800, 500, this, true);
                PluginServices.getMDIManager().addWindow((IWindow)this.statisticsPanel);
            }
            catch (Exception e1) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"problems_creating_process"), null);
                return;
            }
        }
        if (this.windowComponentsPanel != null && (e.getSource() == this.windowComponentsPanel.getButtonsPanel().getButton(3) || e.getSource() == this.windowComponentsPanel.getButtonsPanel().getButton(1))) {
            task = null;
            try {
                Object[] result = (Object[])this.componentsPanel.getResult();
                task = (DataProcess)result[0];
                task.setActions((IProcessActions)new ProcessEndActions(this.windowComponentsPanel, (FLayer)this.lyr));
                task.init();
                task.start();
            }
            catch (Exception e1) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"problems_creating_process"), null);
                return;
            }
        }
    }

    public void end(Object param) {
        HashMap params = (HashMap)param;
        String processName = (String)params.get(ProcessParamsManagement.PROCESS_NAME);
        if (processName.equals("StatsPrincipalComponentsProcess")) {
            PluginServices.getMDIManager().closeWindow((IWindow)this.windowMainPanel);
            this.stats = (PCStatsDataStructure)params.get("STATS_RESULT");
            String fileName = (String)params.get("PATH");
            boolean[] bands = (boolean[])params.get("BANDS");
            String rois = (String)params.get("ROI_EPSG");
            this.componentsPanel = PrincipalComponentsSwingLocator.getSwingManager().createPCAComponentsListPanel((Object)this.lyr.getDataStore(), this.stats, fileName, bands, rois);
            this.componentsPanel.addListener((EventListener)this);
            this.windowComponentsPanel = new MainWindow(this.componentsPanel.getComponent(), Messages.getText((String)"principal_components"), 400, 350, this);
            PluginServices.getMDIManager().addCentredWindow((IWindow)this.windowComponentsPanel);
            this.componentsPanel.initialize();
        }
    }

    public void interrupted() {
    }

    public void updateProgress(int current, int total) {
    }
}

