/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.principalcomponents.app;

import java.io.File;
import java.util.HashMap;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.util.ProviderServices;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.algorithm.process.ProcessParamsManagement;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.util.RasterNotLoadException;

public class ProcessEndActions
implements IProcessActions {
    private IWindow window = null;
    private FLayer inputLyr = null;

    public ProcessEndActions(IWindow window, FLayer lyr) {
        this.window = window;
        this.inputLyr = lyr;
    }

    public void end(Object param) {
        HashMap params;
        String processName;
        if (this.window != null) {
            PluginServices.getMDIManager().closeWindow(this.window);
            this.window = null;
        }
        if ((processName = (String)(params = (HashMap)param).get(ProcessParamsManagement.PROCESS_NAME)).equals("PrincipalComponentsProcess")) {
            String fileName = (String)params.get("FILENAME");
            long milis = (Long)params.get("TIME");
            this.processFinalize(fileName, milis);
            RasterSwingLocator.getSwingManager().showSummaryProcessDialog(fileName, milis);
        }
    }

    private void processFinalize(String fileName, long milis) {
        if (!new File(fileName).exists()) {
            return;
        }
        if (RasterSwingLibrary.messageBoxYesOrNot((String)"cargar_toc", null)) {
            try {
                this.loadLayer(fileName, fileName.substring(fileName.lastIndexOf(File.separator) + 1));
            }
            catch (RasterNotLoadException e) {
                RasterSwingLibrary.messageBoxError((String)"error_load_layer", (Object)((Object)e));
            }
        }
    }

    private AbstractViewPanel getView() {
        IWindow[] w = PluginServices.getMDIManager().getAllWindows();
        for (int i = 0; i < w.length; ++i) {
            if (!(w[i] instanceof AbstractViewPanel)) continue;
            FLayers lyrs = ((AbstractViewPanel)w[i]).getMapControl().getMapContext().getLayers();
            for (int j = 0; j < lyrs.getLayersCount(); ++j) {
                FLayer lyr = lyrs.getLayer(j);
                if (this.inputLyr != lyr) continue;
                return (AbstractViewPanel)w[i];
            }
        }
        return null;
    }

    private void loadLayer(String fileName, String layerName) throws RasterNotLoadException {
        if (fileName == null) {
            return;
        }
        AbstractViewPanel theView = this.getView();
        theView.getMapControl().getMapContext().beginAtomicEvent();
        try {
            DataManager dataManager = DALLocator.getDataManager();
            ProviderServices provServ = RasterLocator.getManager().getProviderServices();
            RasterDataParameters storeParameters = provServ.createParameters(fileName);
            storeParameters.setURI(new File(fileName).toURI());
            MapContextManager mcm = MapContextLocator.getMapContextManager();
            DataStore dataStore = null;
            try {
                dataStore = dataManager.createStore((DataStoreParameters)storeParameters);
            }
            catch (ValidateDataParametersException e) {
                throw new RasterNotLoadException("Error al cargar la capa.");
            }
            catch (InitializeException e) {
                throw new RasterNotLoadException("Error al cargar la capa.");
            }
            catch (ProviderNotRegisteredException e) {
                throw new RasterNotLoadException("Error al cargar la capa.");
            }
            if (layerName == null) {
                int endIndex = fileName.lastIndexOf(".");
                if (endIndex < 0) {
                    endIndex = fileName.length();
                }
                layerName = fileName.substring(fileName.lastIndexOf(File.separator) + 1, endIndex);
            }
            FLayer lyr = mcm.createLayer(layerName, dataStore);
            theView.getMapControl().getMapContext().getLayers().addLayer(lyr);
        }
        catch (LoadLayerException e) {
            throw new RasterNotLoadException("Error al cargar la capa.");
        }
        theView.getMapControl().getMapContext().invalidate();
        theView.getMapControl().getMapContext().endAtomicEvent();
    }

    public void interrupted() {
    }

    public void updateProgress(int current, int total) {
    }
}

