/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.factory;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.collections.api.block.SerializableComparator;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.set.sorted.SortedSetIterable;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.comparator.FunctionComparator;
import org.eclipse.collections.impl.block.factory.Functions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Comparators {
    private static final SerializableComparator<?> NATURAL_ORDER_COMPARATOR = new NaturalOrderComparator();
    private static final SerializableComparator<?> REVERSE_NATURAL_ORDER_COMPARATOR = new ReverseComparator((Comparator)NATURAL_ORDER_COMPARATOR);
    private static final SerializableComparator<?> POWER_SET_COMPARATOR = new PowerSetComparator();
    private static final SerializableComparator<Collection<?>> ASCENDING_COLLECTION_SIZE_COMPARATOR = new AscendingCollectionSizeComparator();
    private static final SerializableComparator<Collection<?>> DESCENDING_COLLECTION_SIZE_COMPARATOR = new DescendingCollectionSizeComparator();

    private Comparators() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> SerializableComparator<T> naturalOrder() {
        return NATURAL_ORDER_COMPARATOR;
    }

    public static <T> SerializableComparator<T> reverseNaturalOrder() {
        return REVERSE_NATURAL_ORDER_COMPARATOR;
    }

    public static <T> SerializableComparator<T> reverse(Comparator<T> comparator) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        return new ReverseComparator(comparator);
    }

    public static <T> SerializableComparator<T> safeNullsLow(Comparator<T> notNullSafeComparator) {
        return new SafeNullsLowComparator(notNullSafeComparator);
    }

    public static <T> SerializableComparator<T> safeNullsHigh(Comparator<T> notNullSafeComparator) {
        return new SafeNullsHighComparator(notNullSafeComparator);
    }

    public static <T> SerializableComparator<T> chain(Comparator<T> ... comparators) {
        if (comparators.length == 0) {
            throw new IllegalArgumentException("Nothing to chain");
        }
        return new ChainedComparator(comparators);
    }

    public static <T, V extends Comparable<? super V>> SerializableComparator<T> fromFunctions(Function<? super T, ? extends V> one) {
        return Comparators.byFunction(one);
    }

    public static <T, V1 extends Comparable<? super V1>, V2 extends Comparable<? super V2>> SerializableComparator<T> fromFunctions(Function<? super T, ? extends V1> one, Function<? super T, ? extends V2> two) {
        return Comparators.chain(new Comparator[]{Comparators.byFunction(one), Comparators.byFunction(two)});
    }

    public static <T, V1 extends Comparable<? super V1>, V2 extends Comparable<? super V2>, V3 extends Comparable<? super V3>> SerializableComparator<T> fromFunctions(Function<? super T, ? extends V1> one, Function<? super T, ? extends V2> two, Function<? super T, ? extends V3> three) {
        return Comparators.chain(new Comparator[]{Comparators.byFunction(one), Comparators.byFunction(two), Comparators.byFunction(three)});
    }

    public static <T> SerializableComparator<SortedSetIterable<T>> powerSet() {
        return POWER_SET_COMPARATOR;
    }

    public static SerializableComparator<Collection<?>> ascendingCollectionSizeComparator() {
        return ASCENDING_COLLECTION_SIZE_COMPARATOR;
    }

    public static SerializableComparator<Collection<?>> descendingCollectionSizeComparator() {
        return DESCENDING_COLLECTION_SIZE_COMPARATOR;
    }

    public static <T> SerializableComparator<Pair<T, ?>> byFirstOfPair(Comparator<? super T> comparator) {
        return new ByFirstOfPairComparator(comparator);
    }

    public static <T> SerializableComparator<Pair<?, T>> bySecondOfPair(Comparator<? super T> comparator) {
        return new BySecondOfPairComparator(comparator);
    }

    /*
     * Exception decompiling
     */
    public static <T, V extends Comparable<? super V>> SerializableComparator<T> byFunction(Function<? super T, ? extends V> function) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> SerializableComparator<T> byBooleanFunction(BooleanFunction<T> function) {
        return Functions.toBooleanComparator(function);
    }

    public static <T> SerializableComparator<T> byByteFunction(ByteFunction<T> function) {
        return Functions.toByteComparator(function);
    }

    public static <T> SerializableComparator<T> byCharFunction(CharFunction<T> function) {
        return Functions.toCharComparator(function);
    }

    public static <T> SerializableComparator<T> byDoubleFunction(DoubleFunction<T> function) {
        return Functions.toDoubleComparator(function);
    }

    public static <T> SerializableComparator<T> byFloatFunction(FloatFunction<T> function) {
        return Functions.toFloatComparator(function);
    }

    public static <T> SerializableComparator<T> byIntFunction(IntFunction<T> function) {
        return Functions.toIntComparator(function);
    }

    public static <T> SerializableComparator<T> byLongFunction(LongFunction<T> function) {
        return Functions.toLongComparator(function);
    }

    public static <T> SerializableComparator<T> byShortFunction(ShortFunction<T> function) {
        return Functions.toShortComparator(function);
    }

    public static <T, V> SerializableComparator<T> byFunction(Function<? super T, ? extends V> function, Comparator<V> comparator) {
        return new FunctionComparator<T, V>(function, comparator);
    }

    public static boolean nullSafeEquals(Object value1, Object value2) {
        return value1 == null ? value2 == null : value1.equals(value2);
    }

    public static <T extends Comparable<T>> int nullSafeCompare(T value1, T value2) {
        if (value1 != null && value2 != null) {
            return value1.compareTo(value2);
        }
        if (value1 == null && value2 == null) {
            return 0;
        }
        return value1 == null ? -1 : 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BySecondOfPairComparator<T>
    implements SerializableComparator<Pair<?, T>> {
        private static final long serialVersionUID = 1L;
        private final Comparator<? super T> comparator;

        private BySecondOfPairComparator(Comparator<? super T> comparator) {
            this.comparator = comparator;
        }

        public int compare(Pair<?, T> p1, Pair<?, T> p2) {
            return this.comparator.compare(p1.getTwo(), p2.getTwo());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ByFirstOfPairComparator<T>
    implements SerializableComparator<Pair<T, ?>> {
        private static final long serialVersionUID = 1L;
        private final Comparator<? super T> comparator;

        private ByFirstOfPairComparator(Comparator<? super T> comparator) {
            this.comparator = comparator;
        }

        public int compare(Pair<T, ?> p1, Pair<T, ?> p2) {
            return this.comparator.compare(p1.getOne(), p2.getOne());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DescendingCollectionSizeComparator
    implements SerializableComparator<Collection<?>> {
        private static final long serialVersionUID = 1L;

        private DescendingCollectionSizeComparator() {
        }

        public int compare(Collection<?> c1, Collection<?> c2) {
            return c2.size() - c1.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AscendingCollectionSizeComparator
    implements SerializableComparator<Collection<?>> {
        private static final long serialVersionUID = 1L;

        private AscendingCollectionSizeComparator() {
        }

        public int compare(Collection<?> c1, Collection<?> c2) {
            return c1.size() - c2.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PowerSetComparator<T>
    implements SerializableComparator<SortedSetIterable<T>> {
        private static final long serialVersionUID = 1L;

        private PowerSetComparator() {
        }

        public int compare(SortedSetIterable<T> setA, SortedSetIterable<T> setB) {
            int compareTo = Integer.valueOf(setA.size()).compareTo(setB.size());
            if (compareTo == 0) {
                return setA.compareTo(setB);
            }
            return compareTo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChainedComparator<T>
    implements SerializableComparator<T> {
        private static final long serialVersionUID = 1L;
        private final Comparator<T>[] comparators;

        private ChainedComparator(Comparator<T>[] comparators) {
            this.comparators = comparators;
        }

        public int compare(T value1, T value2) {
            for (Comparator<T> comparator : this.comparators) {
                int result = comparator.compare(value1, value2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SafeNullsHighComparator<T>
    implements SerializableComparator<T> {
        private static final long serialVersionUID = 1L;
        private final Comparator<T> notNullSafeComparator;

        private SafeNullsHighComparator(Comparator<T> newNotNullSafeComparator) {
            this.notNullSafeComparator = newNotNullSafeComparator;
        }

        public int compare(T value1, T value2) {
            if (value1 != null && value2 != null) {
                return this.notNullSafeComparator.compare(value1, value2);
            }
            if (value1 == null && value2 == null) {
                return 0;
            }
            return value1 == null ? 1 : -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SafeNullsLowComparator<T>
    implements SerializableComparator<T> {
        private static final long serialVersionUID = 1L;
        private final Comparator<T> notNullSafeComparator;

        private SafeNullsLowComparator(Comparator<T> newNotNullSafeComparator) {
            this.notNullSafeComparator = newNotNullSafeComparator;
        }

        public int compare(T value1, T value2) {
            if (value1 != null && value2 != null) {
                return this.notNullSafeComparator.compare(value1, value2);
            }
            if (value1 == null && value2 == null) {
                return 0;
            }
            return value1 == null ? -1 : 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReverseComparator<T>
    implements SerializableComparator<T> {
        private static final long serialVersionUID = 1L;
        private final Comparator<T> comparator;

        private ReverseComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        public int compare(T o1, T o2) {
            return this.comparator.compare(o2, o1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NaturalOrderComparator<T extends Comparable<T>>
    implements SerializableComparator<T> {
        private static final long serialVersionUID = 1L;

        private NaturalOrderComparator() {
        }

        public int compare(T o1, T o2) {
            if (o1 == null || o2 == null) {
                throw new NullPointerException();
            }
            return o1.compareTo(o2);
        }
    }
}

