/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf;

import java.util.NoSuchElementException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadRuntimeException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureProviderIterator;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureSetProvider;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.store.dbf.DBFStoreProvider;
import org.gvsig.tools.exception.BaseException;

public class DBFSetProvider
extends AbstractFeatureSetProvider {
    public DBFSetProvider(DBFStoreProvider store, FeatureQuery query, FeatureType providerFeatureType, FeatureType storeFeatureType) throws DataException {
        super((AbstractFeatureStoreProvider)store, query, DBFSetProvider.getEditable(providerFeatureType), storeFeatureType);
    }

    private static FeatureType getEditable(FeatureType type) {
        try {
            return type.getEditable();
        }
        catch (UnsupportedOperationException ex) {
            return type.getCopy().getEditable();
        }
    }

    public boolean canFilter() {
        return false;
    }

    public boolean canIterateFromIndex() {
        return true;
    }

    public boolean canOrder() {
        return false;
    }

    public long getSize() throws DataException {
        return this.getStore().getFeatureCount();
    }

    public boolean isEmpty() throws DataException {
        return this.getSize() == 0L;
    }

    protected void doDispose() throws BaseException {
    }

    protected AbstractFeatureProviderIterator createIterator(long index) throws DataException {
        return new DBFIterator((DBFStoreProvider)this.getStore(), this.getProviderFeatureType(), index);
    }

    protected AbstractFeatureProviderIterator createFastIterator(long index) throws DataException {
        return new FastDBFIterator((DBFStoreProvider)this.getStore(), this.getProviderFeatureType(), index);
    }

    protected class FastDBFIterator
    extends DBFIterator {
        protected FeatureProvider data;

        public FastDBFIterator(DBFStoreProvider store, FeatureType type, long startOn) throws DataException {
            super(store, type, startOn);
            this.data = this.getDBFStoreProvider().createFeatureProvider(type, DBFSetProvider.this.getStoreFeatureType());
        }

        @Override
        protected Object internalNext() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            try {
                this.getDBFStoreProvider().initFeatureProviderByIndex(this.data, this.index, this.type);
            }
            catch (DataException e) {
                throw new ReadRuntimeException(this.getNameForMessages(), (Object)this.index, (Throwable)e);
            }
            ++this.index;
            return this.data;
        }

        @Override
        protected void internalDispose() {
            super.internalDispose();
            this.data = null;
        }
    }

    protected class DBFIterator
    extends AbstractFeatureProviderIterator {
        protected long index;
        protected FeatureType type;
        protected long count;

        public DBFIterator(DBFStoreProvider store, FeatureType type, long startOn) throws DataException {
            super((FeatureStoreProvider)store);
            this.index = startOn;
            this.type = type;
            this.count = store.getFeatureCount();
        }

        protected boolean internalHasNext() {
            return this.count > this.index;
        }

        protected Object internalNext() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            try {
                FeatureProvider ret = this.getDBFStoreProvider().getFeatureProviderByIndex(this.index, this.type, DBFSetProvider.this.getStoreFeatureType());
                ++this.index;
                return ret;
            }
            catch (DataException e) {
                throw new ReadRuntimeException(this.getNameForMessages(), (Object)this.index, (Throwable)e);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void internalDispose() {
            this.type = null;
        }

        protected DBFStoreProvider getDBFStoreProvider() {
            return (DBFStoreProvider)this.getFeatureStoreProvider();
        }

        protected String getNameForMessages() {
            try {
                return this.getFeatureStoreProvider().getName();
            }
            catch (Exception ex) {
                return "unknown";
            }
        }

        protected void doDispose() throws BaseException {
        }
    }
}

