/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTypeUtils;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.FileNotFoundException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.UnsupportedVersionException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.AttributeNameTooLongException;
import org.gvsig.fmap.dal.feature.exception.PerformEditingException;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.DefaultFeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureSetProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.exception.ResourceException;
import org.gvsig.fmap.dal.resource.exception.ResourceExecuteException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyChangesException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyCloseException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyOpenException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.dbf.DBFAutodetectInputStream;
import org.gvsig.fmap.dal.store.dbf.DBFFeatureProvider;
import org.gvsig.fmap.dal.store.dbf.DBFFeatureWriter;
import org.gvsig.fmap.dal.store.dbf.DBFSetProvider;
import org.gvsig.fmap.dal.store.dbf.DBFStoreParameters;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseFile;
import org.gvsig.fmap.dal.store.dbf.utils.FieldFormatter;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.tools.math.BigDecimalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBFStoreProvider
extends AbstractFeatureStoreProvider
implements ResourceConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(DBFStoreProvider.class);
    public static final int MAX_FIELD_NAME_LENGTH = 10;
    public static final String NAME = "DBF";
    public static final String DESCRIPTION = "DBF file";
    public static final String METADATA_DEFINITION_NAME = "DBF";
    private static final String METADATA_ENCODING = "Encoding";
    private static final String METADATA_CODEPAGE = "CodePage";
    private DbaseFile dbfFile = null;
    private ResourceProvider dbfResource;
    private long counterNewsOIDs = -1L;
    private DBFFeatureWriter writer;
    private boolean loTengoEnUso;
    private boolean allowDuplicatedFieldNames;
    private FilteredLogger logger = new FilteredLogger(LOG, "DBFStoreProvider", -1);
    protected EditableFeatureType featureType;

    protected static void registerMetadataDefinition() throws MetadataException {
        MetadataManager manager = MetadataLocator.getMetadataManager();
        if (manager.getDefinition("DBF") == null) {
            manager.addDefinition("DBF", DBFStoreParameters.class.getResourceAsStream("DBFStoreMetadata.xml"), DBFStoreParameters.class.getClassLoader());
        }
    }

    public DBFStoreProvider(DBFStoreParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        this(params, storeServices, FileHelper.newMetadataContainer((String)"DBF"));
    }

    protected DBFStoreProvider(DBFStoreParameters params, DataStoreProviderServices storeServices, DynObject metadata) throws InitializeException {
        super((DataStoreParameters)params, storeServices, metadata);
        this.logger.setInterval(2000L);
        this.init(params, storeServices);
    }

    protected void init(DBFStoreParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        DataManager dataManager;
        boolean autodetectCharset;
        if (params == null) {
            throw new InitializeException((Throwable)new NullPointerException("params is null"));
        }
        File theFile = this.getDBFParameters().getDBFFile();
        if (theFile == null) {
            throw new InitializeException((Throwable)new NullPointerException("dbf file is null"));
        }
        this.setStoreServices((FeatureStoreProviderServices)storeServices);
        this.initResource(params, storeServices);
        Charset charset = params.getEncoding();
        String charsetName = params.getEncodingName();
        if (StringUtils.isBlank((CharSequence)charsetName) && (autodetectCharset = DataTypeUtils.toBoolean((Object)(dataManager = DALLocator.getDataManager()).getProperty("dbf_AutodetectEncoding"), (boolean)false))) {
            int autodetectCharsetMaxRecords = DataTypeUtils.toInteger((Object)dataManager.getProperty("dbf_AutodetectEncodingMaxRecords"), (int)1000);
            try {
                charset = DBFAutodetectInputStream.autodetectCharset(theFile, autodetectCharsetMaxRecords);
            }
            catch (Exception ex) {
                throw new InitializeException((Throwable)ex);
            }
        }
        this.allowDuplicatedFieldNames = params.allowDuplicatedFieldNames();
        this.dbfFile = new DbaseFile(theFile, charset, this.allowDuplicatedFieldNames);
        this.writer = new DBFFeatureWriter(this.getProviderName());
        this.initFeatureType();
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        try {
            this.open();
        }
        catch (OpenException e) {
            throw new RuntimeException(e);
        }
        if (METADATA_ENCODING.equalsIgnoreCase(name)) {
            return this.dbfFile.getOriginalCharset();
        }
        if (METADATA_CODEPAGE.equalsIgnoreCase(name)) {
            return this.dbfFile.getCodePageInt();
        }
        return super.getDynValue(name);
    }

    protected void initResource(DBFStoreParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        File theFile = this.getDBFParameters().getDBFFile();
        this.dbfResource = this.createResource("file", new Object[]{theFile.getAbsolutePath()});
        this.dbfResource.addConsumer((ResourceConsumer)this);
    }

    protected void initResource(ResourceProvider resource, DataStoreProviderServices storeServices) {
        this.dbfResource = resource;
        this.dbfResource.addConsumer((ResourceConsumer)this);
    }

    public String getProviderName() {
        return "DBF";
    }

    protected DBFStoreParameters getDBFParameters() {
        return (DBFStoreParameters)super.getParameters();
    }

    public DataServerExplorer getExplorer() throws ReadException {
        DataManager manager = DALLocator.getDataManager();
        try {
            FilesystemServerExplorerParameters params = (FilesystemServerExplorerParameters)manager.createServerExplorerParameters("FilesystemExplorer");
            params.setRoot(this.getDBFParameters().getDBFFile().getParent());
            return manager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)params);
        }
        catch (DataException | ValidateDataParametersException e) {
            throw new ReadException(this.getName(), e);
        }
    }

    protected FeatureProvider internalGetFeatureProviderByReference(FeatureReferenceProviderServices reference, FeatureType featureType) throws DataException {
        return this.getFeatureProviderByIndex(((Number)reference.getOID()).longValue(), featureType, null);
    }

    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator originalFeatureTypesUpdated) throws PerformEditingException {
        this.checkNewFieldsNameSize(originalFeatureTypesUpdated);
        try {
            this.loTengoEnUso = true;
            final FeatureStore theStore = this.getStoreServices().getFeatureStore();
            this.resourceCloseRequest();
            this.getResource().execute(new ResourceAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    FeatureSet set = null;
                    DisposableIterator iter = null;
                    try {
                        set = theStore.getFeatureSet();
                        DBFStoreParameters tmpParams = (DBFStoreParameters)DBFStoreProvider.this.getDBFParameters().getCopy();
                        File tmp_file = File.createTempFile("tmp_" + System.currentTimeMillis(), ".dbf");
                        tmp_file.deleteOnExit();
                        tmpParams.setDBFFile(tmp_file);
                        DBFStoreProvider.this.writer.begin(tmpParams, theStore.getDefaultFeatureType(), set.getSize());
                        iter = set.fastIterator();
                        while (iter.hasNext()) {
                            Feature feature = (Feature)iter.next();
                            DBFStoreProvider.this.writer.append(feature);
                        }
                        DBFStoreProvider.this.writer.end();
                        DBFStoreProvider.this.loTengoEnUso = false;
                        try {
                            DBFStoreProvider.this.close();
                        }
                        catch (CloseException e1) {
                            throw new PerformEditingException(DBFStoreProvider.this.getProviderName(), (Throwable)e1);
                        }
                        DBFStoreProvider.this.getDBFParameters().getDBFFile().delete();
                        File target_file = DBFStoreProvider.this.getDBFParameters().getDBFFile();
                        if (target_file.exists()) {
                            target_file.delete();
                        }
                        tmp_file.renameTo(target_file);
                        if (tmp_file.exists() && !target_file.exists()) {
                            LOG.info("Warning: copying tmp file instead of renaming: " + target_file.getName());
                            FileUtils.copyFile((File)tmp_file, (File)target_file);
                        }
                        DBFStoreProvider.this.resourcesNotifyChanges();
                        DBFStoreProvider.this.initFeatureType();
                    }
                    finally {
                        DBFStoreProvider.this.loTengoEnUso = false;
                        if (set != null) {
                            set.dispose();
                        }
                        if (iter != null) {
                            iter.dispose();
                        }
                    }
                    return null;
                }
            });
        }
        catch (ResourceException | ResourceExecuteException e) {
            throw new PerformEditingException("DBF", e);
        }
        this.counterNewsOIDs = -1L;
    }

    protected void checkNewFieldsNameSize(Iterator ft_upd) throws PerformEditingException {
        String long_fields = this.getNewFieldsWithNameTooLong(ft_upd);
        if (long_fields != null) {
            AttributeNameTooLongException ane = new AttributeNameTooLongException(long_fields, this.getProviderName(), 10);
            throw new PerformEditingException(this.getProviderName(), (Throwable)ane);
        }
    }

    protected String getNewFieldsWithNameTooLong(Iterator ft_updated) {
        String resp = "";
        while (ft_updated.hasNext()) {
            FeatureAttributeDescriptor[] atts;
            FeatureType.FeatureTypeChanged item = (FeatureType.FeatureTypeChanged)ft_updated.next();
            FeatureType ft = item.getTarget();
            for (FeatureAttributeDescriptor att : atts = ft.getAttributeDescriptors()) {
                if (att.getName().length() <= 10) continue;
                resp = resp.length() == 0 ? att.getName() : resp + ", " + att.getName();
            }
        }
        if (resp.length() == 0) {
            return null;
        }
        return "(" + resp + ")";
    }

    public FeatureProvider createFeatureProvider(FeatureType providerFeatureType) throws DataException {
        return new DBFFeatureProvider(this, providerFeatureType, null);
    }

    public FeatureProvider createFeatureProvider(FeatureType providerFeatureType, FeatureType storeFeatureType) throws DataException {
        return new DBFFeatureProvider(this, providerFeatureType, storeFeatureType);
    }

    protected void initFeatureType() throws InitializeException {
        this.featureType = this.getTheFeatureType();
        FeatureType defaultType = this.featureType.getNotEditableCopy();
        this.setStoreFeatureType(defaultType);
    }

    protected void setStoreFeatureType(FeatureType ftype) {
        FeatureStoreProviderServices store = this.getStoreServices();
        ArrayList<FeatureType> ftypes = new ArrayList<FeatureType>();
        ftypes.add(ftype);
        store.setFeatureTypes(ftypes, ftype);
    }

    protected EditableFeatureType getTheFeatureType() throws InitializeException {
        try {
            this.open();
        }
        catch (DataException e) {
            throw new InitializeException(this.getProviderName(), (Throwable)e);
        }
        EditableFeatureType featureType = (EditableFeatureType)this.getResource().execute(new ResourceAction(){

            public Object run() throws Exception {
                EditableFeatureType featureType = DBFStoreProvider.this.getStoreServices().createFeatureType(DBFStoreProvider.this.getName());
                featureType.setHasOID(true);
                DBFStoreProvider.this.dbfFile.getHeader().toFeatureType(featureType, DBFStoreProvider.this.getDBFParameters().handleDatesAsStrings());
                return featureType;
            }
        });
        return featureType;
    }

    protected void loadValue(DBFFeatureProvider featureProvider, long rowIndex, FeatureAttributeDescriptor descriptor) throws ReadException {
        if (descriptor.getEvaluator() != null) {
            return;
        }
        int dbfFieldIndex = this.dbfFile.getFieldIndex(descriptor.getName());
        if (dbfFieldIndex < 0) {
            this.logger.warn("The requested field (" + descriptor.getName() + ") does not exist in the DBF file. Assumed it's a new field in editing mode.");
            return;
        }
        String value = null;
        try {
            value = this.dbfFile.getStringFieldValue(rowIndex, dbfFieldIndex);
        }
        catch (DataException e) {
            throw new ReadException(this.getName(), (Throwable)e);
        }
        value = value.trim();
        FieldFormatter formatter = new FieldFormatter(descriptor.getName(), rowIndex);
        int index = descriptor.getIndex();
        Object defaultValue = descriptor.getDefaultValueCoerced();
        switch (descriptor.getType()) {
            case 8: {
                featureProvider.set(index, (Object)formatter.parseString(value, (String)defaultValue));
                break;
            }
            case 19: {
                BigDecimal d = formatter.parseDecimal(value, descriptor.getMathContext(), descriptor.getScale(), (BigDecimal)defaultValue);
                if (!BigDecimalUtils.isValid((BigDecimal)d, (int)descriptor.getScale(), (int)descriptor.getPrecision())) {
                    DBFStoreParameters params = this.getDBFParameters();
                    if (params.allowInconsistenciesInDecimals()) {
                        MutableInt scale = new MutableInt(descriptor.getScale());
                        MutableInt precision = new MutableInt(descriptor.getPrecision());
                        d = BigDecimalUtils.forceScaleAndEnsurePrecisionIfValid((BigDecimal)d, (MutableInt)scale, (MutableInt)precision);
                        this.updateStoreScaleAndPrecision(featureProvider, descriptor, scale.intValue(), precision.intValue());
                    } else {
                        FeatureAttributeDescriptor storeDescriptor;
                        FeatureType storeFeatureType = featureProvider.getStoreFeatureType();
                        if (storeFeatureType != null && (storeDescriptor = storeFeatureType.getAttributeDescriptor(descriptor.getName())) instanceof EditableFeatureAttributeDescriptor && BigDecimalUtils.isValid((BigDecimal)d, (int)storeDescriptor.getScale(), (int)storeDescriptor.getPrecision())) {
                            ((EditableFeatureAttributeDescriptor)descriptor).setScale(storeDescriptor.getScale());
                            ((EditableFeatureAttributeDescriptor)descriptor).setPrecision(storeDescriptor.getPrecision());
                        }
                    }
                }
                featureProvider.set(index, (Object)d);
                break;
            }
            case 7: {
                featureProvider.set(index, (Object)formatter.parseDouble(value, (Double)defaultValue));
                break;
            }
            case 6: {
                featureProvider.set(index, (Object)formatter.parseFloat(value, (Float)defaultValue));
                break;
            }
            case 5: {
                featureProvider.set(index, (Object)formatter.parseLong(value, (Long)defaultValue));
                break;
            }
            case 4: {
                featureProvider.set(index, (Object)formatter.parseInt(value, (Integer)defaultValue));
                break;
            }
            case 2: {
                featureProvider.set(index, (Object)formatter.parseByte(value, (Byte)defaultValue));
                break;
            }
            case 1: {
                featureProvider.set(index, (Object)formatter.parseBoolean(value, (Boolean)defaultValue));
                break;
            }
            case 11: {
                featureProvider.set(index, (Object)formatter.parseTimestamp(value, (Timestamp)defaultValue));
                break;
            }
            case 10: {
                featureProvider.set(index, (Object)formatter.parseTime(value, (Time)defaultValue));
                break;
            }
            case 9: {
                featureProvider.set(index, (Object)formatter.parseDate(value, (Date)defaultValue));
                break;
            }
            default: {
                Object v;
                try {
                    v = descriptor.getDataType().coerce((Object)value);
                }
                catch (CoercionException ex) {
                    v = defaultValue;
                }
                featureProvider.set(index, v);
            }
        }
    }

    protected FeatureProvider getFeatureProviderByIndex(long index) throws DataException {
        return this.getFeatureProviderByIndex(index, this.getStoreServices().getDefaultFeatureType(), null);
    }

    public long getFeatureCount() throws ReadException, OpenException, ResourceNotifyChangesException {
        this.open();
        return (Long)this.getResource().execute(() -> (long)this.dbfFile.getRecordCount());
    }

    public FeatureSetProvider createSet(FeatureQuery query, FeatureType featureType) throws DataException {
        return new DBFSetProvider(this, query, featureType, null);
    }

    public FeatureSetProvider createSet(FeatureQuery query, FeatureType providerFeatureType, FeatureType storeFeatureType) throws DataException {
        return new DBFSetProvider(this, query, providerFeatureType, storeFeatureType);
    }

    public boolean canCreate() {
        return true;
    }

    public boolean canWriteGeometry(int geometryType, int geometrySubType) throws DataException {
        return false;
    }

    public void open() throws OpenException {
        if (this.dbfFile != null && this.dbfFile.isOpen()) {
            return;
        }
        try {
            this.getResource().execute(new ResourceAction(){

                public Object run() throws Exception {
                    DBFStoreProvider.this.openFile();
                    DBFStoreProvider.this.resourcesOpen();
                    return null;
                }
            });
        }
        catch (ResourceExecuteException e) {
            throw new OpenException(this.getProviderName(), (Throwable)e);
        }
    }

    protected void openFile() throws FileNotFoundException, UnsupportedVersionException, IOException, DataException {
        this.dbfFile.open();
        this.getDBFParameters().setEffectiveEncoding(this.dbfFile.getCharsetName());
    }

    public void close() throws CloseException {
        if (this.loTengoEnUso) {
            return;
        }
        if (this.dbfFile == null || !this.dbfFile.isOpen()) {
            return;
        }
        super.close();
        try {
            this.getResource().execute(new ResourceAction(){

                public Object run() throws Exception {
                    DBFStoreProvider.this.closeFile();
                    DBFStoreProvider.this.resourcesNotifyClose();
                    return null;
                }
            });
        }
        catch (ResourceExecuteException e) {
            throw new CloseException(this.getProviderName(), (Throwable)e);
        }
    }

    protected void closeFile() throws CloseException {
        try {
            this.dbfFile.close();
        }
        catch (IOException ex) {
            throw new CloseException("DBF", (Throwable)ex);
        }
    }

    protected void doDispose() throws BaseException {
        this.close();
        this.dbfFile = null;
        this.disposeResource();
        if (this.writer != null) {
            this.writer.dispose();
            this.writer = null;
        }
        super.doDispose();
    }

    protected void disposeResource() {
        if (this.dbfResource != null) {
            this.dbfResource.removeConsumer((ResourceConsumer)this);
            this.dbfResource = null;
        }
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        try {
            this.close();
        }
        catch (CloseException e) {
            return false;
        }
        return true;
    }

    public boolean allowWrite() {
        if (this.allowDuplicatedFieldNames || this.getDBFParameters().allowInconsistenciesInDecimals()) {
            return false;
        }
        return this.dbfFile.isWritable();
    }

    public void refresh() throws OpenException {
        try {
            FeatureStoreProviderServices store = this.getStoreServices();
            this.doDispose();
            this.init(this.getDBFParameters(), (DataStoreProviderServices)store);
        }
        catch (Exception e) {
            throw new OpenException(this.getProviderName(), (Throwable)e);
        }
        this.open();
        try {
            this.initFeatureType();
        }
        catch (InitializeException e) {
            throw new OpenException(this.getProviderName(), (Throwable)e);
        }
    }

    protected FeatureProvider getFeatureProviderByIndex(long index, FeatureType providerFeatureType, FeatureType storeFeatureType) throws DataException {
        FeatureProvider featureProvider = this.createFeatureProvider(providerFeatureType, storeFeatureType);
        featureProvider.setOID((Object)index);
        return featureProvider;
    }

    protected void initFeatureProviderByIndex(FeatureProvider featureProvider, long index, FeatureType featureType) throws DataException {
        featureProvider.setOID((Object)index);
    }

    protected void loadFeatureProviderByIndex(FeatureProvider featureProvider) throws DataException {
        int rec_count;
        long index = (Long)featureProvider.getOID();
        if (index >= (long)(rec_count = this.dbfFile.getRecordCount())) {
            ReadException rex = new ReadException(this.getName(), (Throwable)new ArrayIndexOutOfBoundsException("Index of requested feature (" + index + ") is >= record count (" + rec_count + ")"));
            LOG.info("Error while loading feature. ", (Throwable)rex);
            throw rex;
        }
        ((DBFFeatureProvider)featureProvider).setBroken(false);
        ((DBFFeatureProvider)featureProvider).setDataStatus(0);
        for (FeatureAttributeDescriptor desc : featureProvider.getType()) {
            try {
                this.loadValue((DBFFeatureProvider)featureProvider, index, desc);
                try {
                    BigDecimal d;
                    if (desc.getType() != 19 || BigDecimalUtils.isValid((BigDecimal)(d = (BigDecimal)featureProvider.get(desc.getName())), (int)desc.getScale(), (int)desc.getPrecision())) continue;
                    ((DefaultFeatureProvider)featureProvider).setDataStatus(2);
                    this.logger.warn("Possible inconsistency in the value of the '" + desc.getName() + "' attribute at index " + index + "( value is " + BigDecimalUtils.repr((BigDecimal)d) + ") but required precision is " + desc.getPrecision() + " and scale is " + desc.getScale() + ")");
                }
                catch (Exception e) {
                    LOG.debug("Can't check decimal format", (Throwable)e);
                }
            }
            catch (Throwable th) {
                this.logger.warn("Can't load value for attribute '" + desc.getName() + "' at index " + index, th);
                ((DefaultFeatureProvider)featureProvider).setBroken(true);
                featureProvider.set(desc.getIndex(), null);
            }
        }
    }

    public int getOIDType() {
        return 5;
    }

    public Object createNewOID() {
        if (this.counterNewsOIDs < 0L) {
            try {
                this.counterNewsOIDs = this.getFeatureCount();
            }
            catch (DataException e) {
                LOG.warn("Can't initialice counter for news OIDs.", (Throwable)e);
            }
        } else {
            ++this.counterNewsOIDs;
        }
        return this.counterNewsOIDs;
    }

    public boolean supportsAppendMode() {
        return true;
    }

    public void append(FeatureProvider featureProvider) throws DataException {
        this.getResource().execute(() -> {
            this.writer.append(this.getStoreServices().createFeature(featureProvider));
            return null;
        });
    }

    public void beginAppend() throws DataException {
        this.close();
        this.getResource().execute(() -> {
            this.writer.begin(this.getDBFParameters(), this.getStoreServices().getDefaultFeatureType(), this.getStoreServices().getFeatureStore().getFeatureCount());
            return null;
        });
    }

    public void endAppend() throws DataException {
        this.getResource().execute(new ResourceAction(){

            public Object run() throws Exception {
                DBFStoreProvider.this.writer.end();
                DBFStoreProvider.this.resourcesNotifyChanges();
                DBFStoreProvider.this.counterNewsOIDs = -1L;
                return null;
            }
        });
    }

    public void resourceChanged(ResourceProvider resource) {
        if (this.getStoreServices() != null) {
            this.getStoreServices().notifyChange("resourceChange_DataStore", (Resource)resource);
        }
    }

    protected void resourcesNotifyChanges() throws ResourceNotifyChangesException {
        this.dbfResource.notifyChanges();
    }

    protected void resourcesNotifyClose() throws ResourceNotifyCloseException {
        this.dbfResource.notifyClose();
    }

    protected void resourcesOpen() throws ResourceNotifyOpenException {
        this.dbfResource.notifyOpen();
    }

    public Object getSourceId() {
        return this.getDBFParameters().getFile();
    }

    public String getName() {
        String name = this.getDBFParameters().getFile().getName();
        int n = name.lastIndexOf(".");
        if (n < 1) {
            return name;
        }
        return name.substring(0, n);
    }

    public String getFullName() {
        return this.getDBFParameters().getFile().getAbsolutePath();
    }

    protected void resourceCloseRequest() throws ResourceException {
        this.dbfResource.closeRequest();
    }

    public ResourceProvider getResource() {
        return this.dbfResource;
    }

    public void fixFeatureTypeFromParameters() {
        FeatureStoreProviderServices store = this.getStoreServices();
        try {
            int sizeWithoutComputed = 0;
            for (FeatureAttributeDescriptor featureAttributeDescriptor : store.getDefaultFeatureType()) {
                if (featureAttributeDescriptor.isComputed()) continue;
                ++sizeWithoutComputed;
            }
            if (this.featureType.size() != sizeWithoutComputed) {
                this.setStoreFeatureType(this.featureType.getNotEditableCopy());
            }
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    private void updateStoreScaleAndPrecision(DBFFeatureProvider featureProvider, FeatureAttributeDescriptor descriptor, int scale, int precision) {
        if (descriptor.getType() == 19) {
            if (descriptor.getScale() == scale && descriptor.getPrecision() == precision) {
                return;
            }
            FeatureType ft = this.getFeatureStore().getDefaultFeatureTypeQuietly();
            FeatureAttributeDescriptor d = ft.getAttributeDescriptor(descriptor.getName());
            if (d.getScale() == scale && d.getPrecision() == precision) {
                featureProvider.setProviderFeatureType(ft);
                return;
            }
            EditableFeatureType eft = ft.getEditable();
            EditableFeatureAttributeDescriptor ed = (EditableFeatureAttributeDescriptor)eft.getAttributeDescriptor(descriptor.getName());
            ed.setScale(scale);
            ed.setPrecision(precision);
            ft = eft.getNotEditableCopy();
            featureProvider.setProviderFeatureType(ft);
            this.setStoreFeatureType(ft);
        }
    }

    public DbaseFile getDBFFile() {
        return this.dbfFile;
    }
}

