/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf.dbfcharset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.store.dbf.DBFAutodetectInputStream;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.pickercontroller.CharsetPickerController;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDynFormFieldDBFCharset
extends AbstractJDynFormField
implements JDynFormField,
FocusListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDynFormFieldDBFCharset.class);
    protected Charset assignedValue = null;
    protected JComboBox jcombo = null;
    protected JButton jbutton = null;
    private CharsetPickerController charsetPicker;
    private Thread task = null;

    public JDynFormFieldDBFCharset(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = (Charset)value;
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    public void initComponent() {
        this.contents = new JPanel();
        this.contents.setLayout(new BorderLayout());
        this.jcombo = new JComboBox();
        this.charsetPicker = ToolsSwingLocator.getToolsSwingManager().createCharsetPickerController(this.jcombo);
        this.jbutton = this.getComponentsFactory().getJButton(this.getDefinition(), null);
        this.jbutton.setIcon(this.getIcon("detect-charset"));
        if (StringUtils.equals((CharSequence)"...", (CharSequence)this.jbutton.getText())) {
            this.jbutton.setText("");
        }
        this.jbutton.addActionListener(e -> this.onClickBrowse());
        this.contents.add((Component)this.jcombo, "Center");
        this.contents.add((Component)this.jbutton, "After");
        this.contents.setVisible(true);
        this.setValue(this.assignedValue);
        SwingUtilities.invokeLater(this::automaticDetectEncoding);
    }

    public void onClickBrowse() {
        this.fireFieldEnterEvent();
        File dbfFile = this.getFile();
        this.detectEncoding(dbfFile, -1);
    }

    private File getFile() {
        return (File)this.getForm().getField("dbfFile").getValue();
    }

    public boolean hasValidValue() {
        return true;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.fireFieldEnterEvent();
        this.problemIndicator().restore();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.fireFieldExitEvent();
    }

    public void setValue(Object value) {
        this.charsetPicker.coerceAndSet(value);
        this.assignedValue = (Charset)this.charsetPicker.get();
    }

    public Object getValue() {
        return this.charsetPicker.get();
    }

    private void automaticDetectEncoding() {
        DataManager dataManager;
        boolean autodetectCharset;
        Charset charset = (Charset)this.getValue();
        if (charset == null && (autodetectCharset = DataTypeUtils.toBoolean((Object)(dataManager = DALLocator.getDataManager()).getProperty("dbf_AutodetectEncoding"), (boolean)false))) {
            int autodetectCharsetMaxRecords = DataTypeUtils.toInteger((Object)dataManager.getProperty("dbf_AutodetectEncodingMaxRecords"), (int)1000);
            this.detectEncoding(this.getFile(), autodetectCharsetMaxRecords);
        }
    }

    private synchronized void detectEncoding(File file, int maxRecords) {
        if (this.task != null) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.jbutton.setEnabled(false);
        final SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Detecting_encoding"));
        status.add();
        ComponentAdapter hideListener = new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                status.cancelRequest();
            }
        };
        JComponent jForm = this.getForm().asJComponent();
        jForm.addComponentListener(hideListener);
        this.task = new Thread(() -> {
            try {
                Charset charset = DBFAutodetectInputStream.autodetectCharset(file, maxRecords, status);
                SwingUtilities.invokeLater(() -> {
                    if (!status.isCancellationRequested()) {
                        this.setValue(charset);
                    }
                    this.problemIndicator().clear();
                    jForm.removeComponentListener(hideListener);
                    status.terminate();
                    this.jbutton.setEnabled(true);
                });
            }
            catch (Exception ex) {
                LOGGER.warn("Can't detect encoding", (Throwable)ex);
                status.abort();
                SwingUtilities.invokeLater(() -> this.problemIndicator().set(i18n.getTranslation("_Encoding_could_not_be_detected") + "\n" + ex.getLocalizedMessage()));
            }
            finally {
                this.task = null;
            }
        }, "DBFAutodetectEncoding");
        this.task.start();
    }
}

