/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.store.dbf.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbaseCodepage {
    private static Logger LOGGER = LoggerFactory.getLogger(DbaseCodepage.class);
    private File codePageFile;
    private String charset = null;
    public static final short[] dbfLdid = new short[]{1, 2, 3, 4, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31, 34, 35, 36, 37, 38, 55, 64, 77, 78, 79, 80, 87, 88, 89, 100, 101, 102, 103, 104, 105, 106, 107, 108, 120, 121, 122, 123, 124, 125, 125, 134, 135, 136, 200, 201, 202, 203, 204};
    public static final String[] ldidJava = new String[]{"IBM437", "IBM850", "windows-1252", "x-MacRoman", "IBM865", "IBM437", "IBM850", "IBM437", "IBM437", "IBM850", "IBM437", "IBM850", "IBM437", "IBM850", "x-IBM943", "IBM850", "IBM437", "IBM850", "IBM865", "IBM437", "IBM437", "IBM850", "IBM437", "IBM863", "IBM850", "IBM852", "IBM852", "IBM852", "IBM860", "IBM850", "IBM866", "IBM850", "IBM852", "x-mswin-936", "x-IBM949", "IBM950", "x-IBM874", "windows-1252", "windows-1252", "windows-1252", "IBM852", "IBM866", "IBM865", "IBM861", "IBM437", "IBM437", "x-IBM737", "IBM857", "IBM863", "x-IBM950", "x-IBM949", "x-mswin-936", "x-IBM942", "x-IBM874", "windows-1255", "windows-1256", "x-IBM737", "IBM852", "IBM857", "windows-1250", "windows-1251", "windows-1254", "windows-1253", "windows-1257"};

    public DbaseCodepage(File dbfFile) {
        String cpfileName = DbaseCodepage.getCpgFileName(dbfFile.getAbsolutePath());
        this.codePageFile = new File(cpfileName);
    }

    public static String getCpgFileName(String dbfFile) {
        return FilenameUtils.removeExtension((String)dbfFile) + ".cpg";
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public static String cpg2java(String codePage) {
        if (codePage.equals("UTF8")) {
            return "UTF-8";
        }
        if (codePage.equals("SJIS")) {
            return "Shift_JIS";
        }
        if (StringUtils.isNumeric((CharSequence)codePage)) {
            if (codePage.startsWith("8859") && codePage.length() > 4) {
                return "ISO-8859-" + codePage.substring(4);
            }
            if (codePage.startsWith("125") && codePage.length() == 4) {
                return "windows-" + codePage;
            }
            if (codePage.length() == 3) {
                return "IBM-" + codePage;
            }
            for (int i = 0; i < ldidJava.length; ++i) {
                if (!ldidJava[i].contains(codePage)) continue;
                return codePage;
            }
        }
        if (codePage == "65001") {
            return "UTF-8";
        }
        return codePage;
    }

    public static String java2cpg(String charset) {
        if (charset.startsWith("windows-") || charset.startsWith("ISO-8859") || charset.startsWith("IBM-") || charset.startsWith("x-IBM") || charset.startsWith("x-mswin-")) {
            return charset.replaceAll("[^\\d]", "");
        }
        if (charset.equals("Shift_JIS")) {
            return "SJIS";
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read() {
        BufferedReader bufReader = null;
        try {
            String charset;
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.codePageFile), "ISO-8859-1");
            bufReader = new BufferedReader(reader);
            String cp = bufReader.readLine();
            this.charset = charset = DbaseCodepage.cpg2java(cp);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufReader != null) {
                try {
                    bufReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.getCharset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String charset) {
        this.charset = charset;
        try {
            LogUtils.log(this, "begin write (" + this.codePageFile.getAbsolutePath() + ")");
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(FileUtils.openOutputStream((File)this.codePageFile));
                LogUtils.log(this, "write(" + this.codePageFile.getAbsolutePath() + ")");
                IOUtils.write((String)DbaseCodepage.java2cpg(charset), (OutputStream)os, (String)"ISO-8859-1");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)os);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            LogUtils.log(this, "end write (" + this.codePageFile.getAbsolutePath() + ")");
        }
    }

    public static int getLdid(String charsetName) {
        for (int i = 0; i < ldidJava.length; ++i) {
            if (!ldidJava[i].equals(charsetName)) continue;
            return dbfLdid[i];
        }
        return 0;
    }

    public static String getCharsetName(int ldid) {
        if (ldid != 0) {
            for (int i = 0; i < dbfLdid.length; ++i) {
                if (dbfLdid[i] != ldid) continue;
                return ldidJava[i];
            }
        }
        return null;
    }
}

