/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf.utils;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.UnsupportedVersionException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.AttributeFeatureTypeNotSuportedException;
import org.gvsig.fmap.dal.feature.exception.UnknownDataTypeException;
import org.gvsig.fmap.dal.store.dbf.DuplicatedFieldNameException;
import org.gvsig.fmap.dal.store.dbf.utils.CoerceDateToDbfTimeAsString;
import org.gvsig.fmap.dal.store.dbf.utils.CoerceDateToDbfTimestampAsString;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseCodepage;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseFieldDescriptor;
import org.gvsig.fmap.dal.store.dbf.utils.FieldNameTooLongException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.utils.bigfile.BigByteBuffer2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbaseFileHeader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbaseFileHeader.class);
    private final int FILE_DESCRIPTOR_SIZE = 32;
    private static final byte MAGIC = 3;
    private static final int MINIMUM_HEADER = 33;
    private int myFileType = 3;
    private Date myUpdateDate = new Date();
    private int myNumRecords = 0;
    private int myHeaderLength;
    private int myRecordLength = 1;
    private int myNumFields;
    private DbaseFieldDescriptor[] myFieldDescriptions;
    private int myLanguageID = 0;
    private String charset = null;
    private List<String> encodingSupportedByString = new ArrayList<String>();
    private int origLanguageID = 0;
    private static final Charset HEADER_CHARSET = Charset.forName("ISO-8859-1");

    public DbaseFileHeader() {
        SortedMap<String, Charset> m = Charset.availableCharsets();
        Set<String> k = m.keySet();
        Iterator<String> it = k.iterator();
        while (it.hasNext()) {
            this.encodingSupportedByString.add(it.next());
        }
    }

    public void addColumn(String fieldName, char fieldType, int fieldSize, int fieldPrecision, int fieldScale) throws AttributeFeatureTypeNotSuportedException {
        if (this.myFieldDescriptions == null) {
            this.myFieldDescriptions = new DbaseFieldDescriptor[0];
        }
        int tempLength = 1;
        DbaseFieldDescriptor[] tempFieldDescriptors = new DbaseFieldDescriptor[this.myFieldDescriptions.length + 1];
        for (int i = 0; i < this.myFieldDescriptions.length; ++i) {
            this.myFieldDescriptions[i].setOffsetInRecord(tempLength);
            tempLength += this.myFieldDescriptions[i].getSize();
            tempFieldDescriptors[i] = this.myFieldDescriptions[i];
        }
        tempFieldDescriptors[this.myFieldDescriptions.length] = new DbaseFieldDescriptor();
        tempFieldDescriptors[this.myFieldDescriptions.length].setType(fieldType);
        tempFieldDescriptors[this.myFieldDescriptions.length].setSize(fieldSize);
        tempFieldDescriptors[this.myFieldDescriptions.length].setScale(fieldScale);
        tempFieldDescriptors[this.myFieldDescriptions.length].setOffsetInRecord(tempLength);
        String tempFieldName = fieldName;
        if (tempFieldName == null) {
            tempFieldName = "NoName";
        }
        if (tempFieldName.length() > 10) {
            tempFieldName = tempFieldName.substring(0, 10);
            this.warn("FieldName " + fieldName + " is longer than " + 10 + " characters, truncating to " + tempFieldName);
        }
        tempFieldDescriptors[this.myFieldDescriptions.length].setName(tempFieldName);
        tempFieldDescriptors[this.myFieldDescriptions.length].setName_trim(StringUtils.stripEnd((String)tempFieldName, null));
        this.myFieldDescriptions = tempFieldDescriptors;
        this.myHeaderLength = 33 + 32 * this.myFieldDescriptions.length;
        this.myNumFields = this.myFieldDescriptions.length;
        this.myRecordLength = tempLength += tempFieldDescriptors[this.myFieldDescriptions.length].getSize();
    }

    public int removeColumn(String inFieldName) {
        int retCol = -1;
        int tempLength = 1;
        DbaseFieldDescriptor[] tempFieldDescriptors = new DbaseFieldDescriptor[this.myFieldDescriptions.length - 1];
        int j = 0;
        for (int i = 0; i < this.myFieldDescriptions.length; ++i) {
            if (!inFieldName.equalsIgnoreCase(this.myFieldDescriptions[i].getName().trim())) {
                if (i == j && i == this.myFieldDescriptions.length - 1) {
                    return retCol;
                }
                tempFieldDescriptors[j] = this.myFieldDescriptions[i];
                tempFieldDescriptors[j].setOffsetInRecord(tempLength);
                tempLength += tempFieldDescriptors[j].getSize();
                ++j;
                continue;
            }
            retCol = i;
        }
        this.myFieldDescriptions = tempFieldDescriptors;
        this.myHeaderLength = 33 + 32 * this.myFieldDescriptions.length;
        this.myNumFields = this.myFieldDescriptions.length;
        this.myRecordLength = tempLength;
        return retCol;
    }

    private void warn(String inWarn) {
        LOGGER.warn(inWarn);
    }

    public DbaseFieldDescriptor getFieldDescription(int index) {
        return this.myFieldDescriptions[index];
    }

    public DbaseFieldDescriptor getFieldDescription(String name) {
        int index = this.getFieldIndex(name);
        return this.myFieldDescriptions[index];
    }

    public int getFieldIndex(String name) {
        for (int i = 0; i < this.myFieldDescriptions.length; ++i) {
            if (!this.myFieldDescriptions[i].getName_trim().equalsIgnoreCase(StringUtils.stripEnd((String)name, null))) continue;
            return i;
        }
        return -1;
    }

    public Date getLastUpdateDate() {
        return this.myUpdateDate;
    }

    public int getNumFields() {
        return this.myNumFields;
    }

    public int getNumRecords() {
        return this.myNumRecords;
    }

    public int getRecordLength() {
        return this.myRecordLength;
    }

    public int getHeaderLength() {
        return this.myHeaderLength;
    }

    public void read(BigByteBuffer2 in, String charsName, boolean allowDuplicatedFieldNames) throws UnsupportedVersionException, AttributeFeatureTypeNotSuportedException {
        this.myFileType = in.get();
        if (this.myFileType != 3) {
            throw new UnsupportedVersionException("DBF", Integer.toHexString(this.myFileType));
        }
        int tempUpdateYear = in.get();
        byte tempUpdateMonth = in.get();
        byte tempUpdateDay = in.get();
        Calendar c = Calendar.getInstance();
        c.set(1, tempUpdateYear += 1900);
        c.set(2, tempUpdateMonth - 1);
        c.set(5, tempUpdateDay);
        this.myUpdateDate = c.getTime();
        in.order(ByteOrder.LITTLE_ENDIAN);
        this.myNumRecords = in.getInt();
        this.myHeaderLength = in.getShort();
        this.myRecordLength = in.getShort();
        in.order(ByteOrder.BIG_ENDIAN);
        in.position(29L);
        this.origLanguageID = this.byteAsUnsigned(in.get());
        if (charsName != null) {
            this.myLanguageID = DbaseCodepage.getLdid(charsName);
            this.charset = charsName;
        } else {
            this.myLanguageID = this.origLanguageID;
            charsName = this.getCharsetName();
        }
        in.position(32L);
        this.myNumFields = (this.myHeaderLength - 32 - 1) / 32;
        this.myFieldDescriptions = new DbaseFieldDescriptor[this.myNumFields];
        int fieldOffset = 0;
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < this.myNumFields; ++i) {
            this.myFieldDescriptions[i] = new DbaseFieldDescriptor();
            byte[] buffer = new byte[11];
            in.get(buffer);
            String fieldName = new String(buffer, HEADER_CHARSET);
            if (allowDuplicatedFieldNames) {
                fieldName = this.getUniqueFieldName(fieldName, fieldNames);
            }
            fieldNames.add(fieldName);
            this.myFieldDescriptions[i].setName(fieldName);
            this.myFieldDescriptions[i].setName_trim(this.myFieldDescriptions[i].getName().trim());
            this.myFieldDescriptions[i].setType((char)in.get());
            this.myFieldDescriptions[i].setOffsetInRecord(in.getInt());
            int tempLength = in.get();
            if (tempLength < 0) {
                tempLength += 256;
            }
            this.myFieldDescriptions[i].setSize(tempLength);
            this.myFieldDescriptions[i].setScale(in.get());
            this.myFieldDescriptions[i].setOffsetInRecord(fieldOffset);
            fieldOffset += tempLength;
            in.position(in.position() + 14L);
        }
        in.get();
    }

    public void setNumRecords(int inNumRecords) {
        this.myNumRecords = inNumRecords;
    }

    private int byteAsUnsigned(byte b) {
        int i = b < 0 ? b & 0xFF : b;
        return i;
    }

    public int getLanguageID() {
        return this.myLanguageID;
    }

    public void write(FileChannel out) throws IOException {
        if (this.myHeaderLength <= 0) {
            this.myHeaderLength = 33;
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.myHeaderLength);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)3);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        buffer.put((byte)(c.get(1) % 100));
        buffer.put((byte)(c.get(2) + 1));
        buffer.put((byte)c.get(5));
        buffer.putInt(this.myNumRecords);
        buffer.putShort((short)this.myHeaderLength);
        buffer.putShort((short)this.myRecordLength);
        ((Buffer)buffer).position(buffer.position() + 17);
        buffer.put((byte)this.getLanguageID());
        ((Buffer)buffer).position(buffer.position() + 2);
        int tempOffset = 0;
        if (this.myFieldDescriptions != null) {
            for (int i = 0; i < this.myFieldDescriptions.length; ++i) {
                for (int j = 0; j < 11; ++j) {
                    if (this.myFieldDescriptions[i].getName().length() > j) {
                        buffer.put((byte)this.myFieldDescriptions[i].getName().charAt(j));
                        continue;
                    }
                    buffer.put((byte)0);
                }
                buffer.put((byte)this.myFieldDescriptions[i].getType());
                buffer.putInt(tempOffset);
                tempOffset += this.myFieldDescriptions[i].getSize();
                buffer.put((byte)this.myFieldDescriptions[i].getSize());
                buffer.put((byte)this.myFieldDescriptions[i].getScale());
                ((Buffer)buffer).position(buffer.position() + 14);
            }
        }
        buffer.put((byte)13);
        ((Buffer)buffer).position(0);
        int r = buffer.remaining();
        out.position(0L);
        while ((r -= out.write(buffer)) > 0) {
        }
    }

    public String getCharsetName() {
        return this.getCharsetName(this.getLanguageID());
    }

    public String getCharsetName(int ldid) {
        if (ldid != 0) {
            this.charset = DbaseCodepage.getCharsetName(ldid);
        }
        if (this.charset != null) {
            return this.charset;
        }
        return "ISO-8859-1";
    }

    public String getOriginalCharset() {
        return this.getCharsetName(this.origLanguageID);
    }

    public String mappingEncoding(String dbfEnconding) {
        if (this.encodingSupportedByString.contains(dbfEnconding)) {
            return dbfEnconding;
        }
        return "UTF-8";
    }

    private String getUniqueFieldName(String fieldName, List fieldNames) {
        int index = 0;
        String tempFieldName = fieldName;
        while (fieldNames.contains(tempFieldName) && index < 1000) {
            String sufix = String.valueOf(++index);
            tempFieldName = tempFieldName.substring(0, 10 - sufix.length()) + sufix;
        }
        if (index >= 1000) {
            throw new RuntimeException("Can't fix duplicated name for field '" + fieldName + "'.");
        }
        return tempFieldName;
    }

    public EditableFeatureType toFeatureType(EditableFeatureType featureType, boolean handleDatesAsStrings) throws DataException {
        featureType.setHasOID(true);
        for (DbaseFieldDescriptor dbfattr : this.myFieldDescriptions) {
            EditableFeatureAttributeDescriptor attr;
            if (featureType.get(dbfattr.getName()) != null) {
                throw new DuplicatedFieldNameException(dbfattr.getName());
            }
            switch (dbfattr.getType()) {
                case 'L': {
                    attr = featureType.add(dbfattr.getName(), 1);
                    attr.setSize(0);
                    attr.setDefaultValue(null);
                    attr.setAllowNull(true);
                    break;
                }
                case 'F': {
                    if (dbfattr.getScale() == -1 || dbfattr.getScale() > 0) {
                        if (dbfattr.getSize() > 19) {
                            attr = featureType.add(dbfattr.getName(), 19);
                            attr.setDisplaySize(dbfattr.getSize());
                            attr.setScale(-1);
                            attr.setPrecision(dbfattr.getPrecision());
                            attr.setDefaultValue(null);
                            attr.setAllowNull(true);
                            break;
                        }
                        if (dbfattr.getSize() > 11) {
                            attr = featureType.add(dbfattr.getName(), 7);
                            attr.setDisplaySize(dbfattr.getSize());
                            attr.setScale(dbfattr.getScale());
                            attr.setPrecision(dbfattr.getPrecision());
                            attr.setDefaultValue(null);
                            attr.setAllowNull(true);
                            break;
                        }
                        attr = featureType.add(dbfattr.getName(), 6);
                        attr.setDisplaySize(dbfattr.getSize());
                        attr.setScale(dbfattr.getScale());
                        attr.setPrecision(dbfattr.getPrecision());
                        attr.setDefaultValue(null);
                        attr.setAllowNull(true);
                        break;
                    }
                    if (dbfattr.getPrecision() > 19) {
                        attr = featureType.add(dbfattr.getName(), 19);
                        attr.setDisplaySize(dbfattr.getSize());
                        attr.setPrecision(dbfattr.getPrecision());
                        attr.setScale(-1);
                        attr.setDefaultValue(null);
                        attr.setAllowNull(true);
                        break;
                    }
                    if (dbfattr.getPrecision() > 10) {
                        attr = featureType.add(dbfattr.getName(), 5);
                        attr.setDisplaySize(dbfattr.getSize());
                        attr.setPrecision(dbfattr.getPrecision());
                        attr.setScale(0);
                        attr.setDefaultValue(null);
                        attr.setAllowNull(true);
                        break;
                    }
                    if (dbfattr.getPrecision() > 3) {
                        attr = featureType.add(dbfattr.getName(), 4);
                        attr.setDisplaySize(dbfattr.getSize());
                        attr.setPrecision(dbfattr.getPrecision());
                        attr.setScale(0);
                        attr.setDefaultValue(null);
                        attr.setAllowNull(true);
                        break;
                    }
                    attr = featureType.add(dbfattr.getName(), 19);
                    attr.setDisplaySize(dbfattr.getSize());
                    attr.setPrecision(dbfattr.getPrecision());
                    attr.setScale(0);
                    attr.setDefaultValue(null);
                    attr.setAllowNull(true);
                    break;
                }
                case 'N': {
                    if (dbfattr.getScale() == -1 || dbfattr.getScale() > 0) {
                        attr = featureType.add(dbfattr.getName(), 19);
                        attr.setDisplaySize(dbfattr.getSize());
                        attr.setPrecision(dbfattr.getPrecision());
                        attr.setScale(dbfattr.getScale());
                        attr.setDefaultValue(null);
                        attr.setAllowNull(true);
                        break;
                    }
                    if (dbfattr.getPrecision() > 19) {
                        attr = featureType.add(dbfattr.getName(), 19);
                        attr.setDisplaySize(dbfattr.getSize());
                        attr.setPrecision(dbfattr.getPrecision());
                        attr.setScale(0);
                        attr.setDefaultValue(null);
                        attr.setAllowNull(true);
                        break;
                    }
                    if (dbfattr.getPrecision() > 10) {
                        attr = featureType.add(dbfattr.getName(), 5);
                        attr.setDisplaySize(dbfattr.getSize());
                        attr.setPrecision(dbfattr.getPrecision());
                        attr.setScale(0);
                        attr.setDefaultValue(null);
                        attr.setAllowNull(true);
                        break;
                    }
                    if (dbfattr.getPrecision() > 3) {
                        attr = featureType.add(dbfattr.getName(), 4);
                        attr.setDisplaySize(dbfattr.getSize());
                        attr.setPrecision(dbfattr.getPrecision());
                        attr.setScale(0);
                        attr.setDefaultValue(null);
                        attr.setAllowNull(true);
                        break;
                    }
                    attr = featureType.add(dbfattr.getName(), 19);
                    attr.setDisplaySize(dbfattr.getSize());
                    attr.setPrecision(dbfattr.getPrecision());
                    attr.setScale(0);
                    attr.setDefaultValue(null);
                    attr.setAllowNull(true);
                    break;
                }
                case 'C': {
                    DataType dataType2;
                    attr = featureType.add(dbfattr.getName(), 8, dbfattr.getSize());
                    attr.setDefaultValue(null);
                    attr.setAllowNull(true);
                    if (dbfattr.getSize() == 14) {
                        try {
                            dataType2 = ToolsLocator.getDataTypesManager().get(8).clone();
                            dataType2.addCoercion((Coercion)new CoerceDateToDbfTimestampAsString());
                            attr.setDataType(dataType2);
                        }
                        catch (Exception dataType2) {}
                        break;
                    }
                    if (dbfattr.getSize() != 6) break;
                    try {
                        dataType2 = ToolsLocator.getDataTypesManager().get(8).clone();
                        dataType2.addCoercion((Coercion)new CoerceDateToDbfTimeAsString());
                        attr.setDataType(dataType2);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 'D': {
                    if (handleDatesAsStrings) {
                        attr = featureType.add(dbfattr.getName(), 8, dbfattr.getSize());
                        attr.setDefaultValue(null);
                        attr.setAllowNull(true);
                        break;
                    }
                    attr = featureType.add(dbfattr.getName(), 9);
                    attr.setDefaultValue(null);
                    attr.setAllowNull(true);
                    break;
                }
                default: {
                    throw new UnknownDataTypeException(dbfattr.getName(), String.valueOf(dbfattr.getType()), "DBF");
                }
            }
            attr.setDisplaySize(dbfattr.getSize());
        }
        return featureType;
    }

    public static DbaseFileHeader fromFeatureType(FeatureType featureType) throws DataException {
        return DbaseFileHeader.fromFeatureType(featureType, null);
    }

    public static DbaseFileHeader fromFeatureType(FeatureType featureType, String charsetName) throws DataException {
        DbaseFileHeader header = new DbaseFileHeader();
        Iterator iterator = featureType.iterator();
        header.myLanguageID = DbaseCodepage.getLdid(charsetName);
        header.charset = charsetName;
        block13: while (iterator.hasNext()) {
            FeatureAttributeDescriptor descriptor = (FeatureAttributeDescriptor)iterator.next();
            if (descriptor.isComputed()) continue;
            int type = descriptor.getType();
            String colName = descriptor.getName();
            if (colName.length() > 10) {
                throw new FieldNameTooLongException("DBF file", colName);
            }
            int size = descriptor.getSize();
            int scale = descriptor.getScale();
            int precision = descriptor.getPrecision();
            int displaySize = descriptor.getDisplaySize();
            switch (type) {
                case 19: {
                    if (precision < 0) {
                        if (displaySize < 1) {
                            displaySize = 20;
                        }
                    } else {
                        displaySize = Math.max(displaySize, precision + 3);
                    }
                    header.addColumn(colName, 'N', displaySize, precision, scale);
                    continue block13;
                }
                case 7: {
                    if (displaySize < 1) {
                        displaySize = 19;
                    }
                    if (displaySize > 20) {
                        displaySize = 20;
                    }
                    header.addColumn(colName, 'F', displaySize, precision, scale);
                    continue block13;
                }
                case 6: {
                    if (displaySize < 1) {
                        displaySize = 11;
                    }
                    if (displaySize > 20) {
                        displaySize = 20;
                    }
                    header.addColumn(colName, 'F', displaySize, precision, scale);
                    continue block13;
                }
                case 4: {
                    displaySize = Math.max(displaySize, precision + 1);
                    if (displaySize >= 10) {
                        displaySize = 10;
                    }
                    if (displaySize > 20) {
                        displaySize = 20;
                    }
                    header.addColumn(colName, 'N', displaySize, precision, scale);
                    continue block13;
                }
                case 5: {
                    displaySize = Math.max(displaySize, precision + 1);
                    if (displaySize >= 19) {
                        displaySize = 19;
                    }
                    if (displaySize > 20) {
                        displaySize = 20;
                    }
                    header.addColumn(colName, 'N', displaySize, precision, scale);
                    continue block13;
                }
                case 9: {
                    header.addColumn(colName, 'D', 8, 0, 0);
                    continue block13;
                }
                case 10: {
                    header.addColumn(colName, 'C', 6, 0, 0);
                    continue block13;
                }
                case 11: {
                    header.addColumn(colName, 'C', 14, 0, 0);
                    continue block13;
                }
                case 1: {
                    header.addColumn(colName, 'L', 1, 0, 0);
                    continue block13;
                }
                case 8: {
                    displaySize = Math.max(displaySize, size);
                    if (displaySize > 254 || displaySize <= 0) {
                        displaySize = 254;
                    }
                    header.addColumn(colName, 'C', displaySize, 0, 0);
                    continue block13;
                }
                case 2: {
                    displaySize = Math.max(displaySize, precision + 1);
                    if (displaySize >= 3) {
                        displaySize = 3;
                    }
                    if (displaySize > 20) {
                        displaySize = 20;
                    }
                    header.addColumn(colName, 'N', displaySize, precision, scale);
                    continue block13;
                }
            }
            displaySize = Math.max(displaySize, Math.max(size, 20));
            if (displaySize > 254) {
                displaySize = 254;
            }
            header.addColumn(colName, 'C', displaySize, 0, 0);
        }
        return header;
    }
}

