/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.file.imageio.legend;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import org.gvsig.fmap.dal.file.imageio.ImageIOStoreProvider;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.lib.legend.api.colortable.colortableclass.ColorTableClass;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynMethod;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.dynobject.exception.DynMethodNotSupportedException;

public class ImageIOGetColorTable
implements DynMethod {
    private int code;

    public static void register(DynClass storeClass) {
        ImageIOGetColorTable method = new ImageIOGetColorTable();
        method.code = ToolsLocator.getDynObjectManager().registerDynMethod(storeClass, (DynMethod)method);
    }

    public int getCode() throws DynMethodNotSupportedException {
        return this.code;
    }

    public String getDescription() {
        return "ImageIO based color table";
    }

    public String getName() {
        return "getColorTable";
    }

    public Object invoke(DynObject self, Object[] args) throws DynMethodException {
        ColorTable colorTable = null;
        ImageIOStoreProvider provider = (ImageIOStoreProvider)self;
        RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
        ColorModel colorModel = provider.getImage().getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int[] rgbs = new int[indexColorModel.getMapSize()];
            boolean hasalpha = indexColorModel.hasAlpha();
            indexColorModel.getRGBs(rgbs);
            ArrayList<ColorTableClass> colorTableClasses = new ArrayList<ColorTableClass>();
            for (int i = 0; i < rgbs.length; ++i) {
                String className = i + "";
                double value = (byte)i;
                double interpolation = 50.0;
                Color color = new Color(rgbs[i], hasalpha);
                ColorTableClass colorTableClass = legendManager.createColorTableClass(className, value, interpolation, color);
                colorTableClasses.add(colorTableClass);
            }
            String colorTableName = provider.getName() + "_color_table";
            colorTable = legendManager.createColorTable(colorTableName, colorTableClasses, true);
        }
        return colorTable;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

