/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Vector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.gvsig.utils.NotExistInXMLEntity;
import org.gvsig.utils.XMLEntityIterator;
import org.gvsig.utils.xmlEntity.generate.Property;
import org.gvsig.utils.xmlEntity.generate.XmlTag;

public class XMLEntity {
    private Vector whiteAttrList;
    private XmlTag xmltag;

    public XMLEntity(XmlTag tag) {
        this.xmltag = tag;
    }

    public XMLEntity() {
        this.xmltag = new XmlTag();
    }

    public void putProperty(String key, String value, boolean matters) {
        if (key == null) {
            return;
        }
        Property p = new Property();
        p.setKey(key);
        p.setValue(value);
        this.putProperty(p, matters);
    }

    public void putProperty(String key, String value) {
        this.putProperty(key, value, true);
    }

    public void putProperty(String key, Object value, boolean matters) {
        String ret = "";
        if (key == null) {
            return;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray()) {
            Class<?> compType = valueClass.getComponentType();
            if (compType == Byte.TYPE) {
                byte[] array = (byte[])value;
                if (array.length != 0) {
                    ret = ret + ("" + array[0]).replaceAll("[,]", "\\\\,");
                    for (int i = 1; i < array.length; ++i) {
                        ret = ret + " ," + ("" + array[i]).replaceAll("[,]", "\\\\,");
                    }
                }
            } else if (compType == Short.TYPE) {
                short[] array = (short[])value;
                if (array.length != 0) {
                    ret = ret + ("" + array[0]).replaceAll("[,]", "\\\\,");
                    for (int i = 1; i < array.length; ++i) {
                        ret = ret + " ," + ("" + array[i]).replaceAll("[,]", "\\\\,");
                    }
                }
            } else if (compType == Integer.TYPE) {
                int[] array = (int[])value;
                if (array.length != 0) {
                    ret = ret + ("" + array[0]).replaceAll("[,]", "\\\\,");
                    for (int i = 1; i < array.length; ++i) {
                        ret = ret + " ," + ("" + array[i]).replaceAll("[,]", "\\\\,");
                    }
                }
            } else if (compType == Long.TYPE) {
                long[] array = (long[])value;
                if (array.length != 0) {
                    ret = ret + ("" + array[0]).replaceAll("[,]", "\\\\,");
                    for (int i = 1; i < array.length; ++i) {
                        ret = ret + " ," + ("" + array[i]).replaceAll("[,]", "\\\\,");
                    }
                }
            } else if (compType == Float.TYPE) {
                float[] array = (float[])value;
                if (array.length != 0) {
                    ret = ret + ("" + array[0]).replaceAll("[,]", "\\\\,");
                    for (int i = 1; i < array.length; ++i) {
                        ret = ret + " ," + ("" + array[i]).replaceAll("[,]", "\\\\,");
                    }
                }
            } else if (compType == Double.TYPE) {
                double[] array = (double[])value;
                if (array.length != 0) {
                    ret = ret + ("" + array[0]).replaceAll("[,]", "\\\\,");
                    for (int i = 1; i < array.length; ++i) {
                        ret = ret + " ," + ("" + array[i]).replaceAll("[,]", "\\\\,");
                    }
                }
            } else if (compType == Boolean.TYPE) {
                boolean[] array = (boolean[])value;
                if (array.length != 0) {
                    ret = ret + ("" + array[0]).replaceAll("[,]", "\\\\,");
                    for (int i = 1; i < array.length; ++i) {
                        ret = ret + " ," + ("" + array[i]).replaceAll("[,]", "\\\\,");
                    }
                }
            } else if (compType == String.class) {
                String[] array = (String[])value;
                if (array.length != 0) {
                    if (array[0] == null) {
                        array[0] = "null";
                    }
                    ret = ret + array[0].replaceAll("[,]", "\\\\,");
                    for (int i = 1; i < array.length; ++i) {
                        if (array[i] == null) {
                            array[i] = "null";
                        }
                        array[i] = array[i].replaceAll("[,]", "\\\\,");
                        ret = ret + " ," + array[i];
                    }
                }
            } else {
                Object[] array = (Object[])value;
                if (array.length != 0) {
                    ret = ret + ("" + array[0]).replaceAll("[,]", "\\\\,");
                    for (int i = 1; i < array.length; ++i) {
                        array[i] = ("" + array[i]).replaceAll("[,]", "\\\\,");
                        ret = ret + " ," + array[i];
                    }
                }
            }
        } else {
            ret = value.toString();
        }
        Property p = new Property();
        p.setKey(key);
        p.setValue(ret);
        this.putProperty(p, matters);
    }

    public void putProperty(String key, Object value) {
        this.putProperty(key, value, true);
    }

    public void putProperty(String key, int value, boolean matters) {
        if (key == null) {
            return;
        }
        Property p = new Property();
        p.setKey(key);
        p.setValue(Integer.toString(value));
        this.putProperty(p, matters);
    }

    public void putProperty(String key, int value) {
        this.putProperty(key, value, true);
    }

    public void putProperty(String key, long value, boolean matters) {
        if (key == null) {
            return;
        }
        Property p = new Property();
        p.setKey(key);
        p.setValue(Long.toString(value));
        this.putProperty(p, matters);
    }

    public void putProperty(String key, long value) {
        this.putProperty(key, value, true);
    }

    public void putProperty(String key, boolean value, boolean matters) {
        if (key == null) {
            return;
        }
        Property p = new Property();
        p.setKey(key);
        p.setValue(Boolean.toString(value));
        this.putProperty(p, matters);
    }

    public void putProperty(String key, boolean value) {
        this.putProperty(key, value, true);
    }

    public void putProperty(String key, float value, boolean matters) {
        if (key == null) {
            return;
        }
        Property p = new Property();
        p.setKey(key);
        p.setValue(Float.toString(value));
        this.putProperty(p, matters);
    }

    public void putProperty(String key, float value) {
        this.putProperty(key, value, true);
    }

    public void putProperty(String key, double value, boolean matters) {
        if (key == null) {
            return;
        }
        Property p = new Property();
        p.setKey(key);
        p.setValue(Double.toString(value));
        this.putProperty(p, matters);
    }

    public void putProperty(String key, double value) {
        this.putProperty(key, value, true);
    }

    public String getStringProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        String res = null;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            res = properties[i].getValue();
            exists = true;
        }
        if (exists) {
            return res;
        }
        throw new NotExistInXMLEntity();
    }

    public double getDoubleProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        double res = 0.0;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            res = Double.parseDouble(properties[i].getValue());
            exists = true;
        }
        if (exists) {
            return res;
        }
        throw new NotExistInXMLEntity();
    }

    public double[] getDoubleArrayProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        String value = null;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            value = properties[i].getValue();
            exists = true;
        }
        if (!exists) {
            throw new NotExistInXMLEntity();
        }
        if (value.compareTo("") == 0) {
            return new double[0];
        }
        String[] aux = value.split(" ,");
        double[] ret = new double[aux.length];
        for (int i = 0; i < aux.length; ++i) {
            ret[i] = Double.parseDouble(aux[i].replaceAll("\\\\,", ","));
        }
        return ret;
    }

    public Object getObjectProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        String res = null;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            res = properties[i].getValue();
            exists = true;
        }
        if (exists) {
            return res;
        }
        throw new NotExistInXMLEntity();
    }

    public float[] getFloatArrayProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        String value = null;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            value = properties[i].getValue();
            exists = true;
        }
        if (!exists) {
            throw new NotExistInXMLEntity();
        }
        if (value.compareTo("") == 0) {
            return new float[0];
        }
        String[] aux = value.split(" ,");
        float[] ret = new float[aux.length];
        for (int i = 0; i < aux.length; ++i) {
            ret[i] = Float.parseFloat(aux[i].replaceAll("\\\\,", ","));
        }
        return ret;
    }

    public long[] getLongArrayProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        String value = null;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            value = properties[i].getValue();
            exists = true;
        }
        if (!exists) {
            throw new NotExistInXMLEntity();
        }
        if (value.compareTo("") == 0) {
            return new long[0];
        }
        String[] aux = value.split(" ,");
        long[] ret = new long[aux.length];
        for (int i = 0; i < aux.length; ++i) {
            ret[i] = Long.parseLong(aux[i].replaceAll("\\\\,", ","));
        }
        return ret;
    }

    public byte[] getByteArrayProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        String value = null;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            value = properties[i].getValue();
            exists = true;
        }
        if (!exists) {
            throw new NotExistInXMLEntity();
        }
        if (value.compareTo("") == 0) {
            return new byte[0];
        }
        String[] aux = value.split(" ,");
        byte[] ret = new byte[aux.length];
        for (int i = 0; i < aux.length; ++i) {
            ret[i] = Byte.parseByte(aux[i].replaceAll("\\\\,", ","));
        }
        return ret;
    }

    public int[] getIntArrayProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        String value = null;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            value = properties[i].getValue();
            exists = true;
        }
        if (!exists) {
            throw new NotExistInXMLEntity();
        }
        if (value.compareTo("") == 0) {
            return new int[0];
        }
        String[] aux = value.split(" ,");
        int[] ret = new int[aux.length];
        for (int i = 0; i < aux.length; ++i) {
            ret[i] = Integer.parseInt(aux[i].replaceAll("\\\\,", ","));
        }
        return ret;
    }

    public boolean[] getBooleanArrayProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        String value = null;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            value = properties[i].getValue();
            exists = true;
        }
        if (!exists) {
            throw new NotExistInXMLEntity();
        }
        if (value.compareTo("") == 0) {
            return new boolean[0];
        }
        String[] aux = value.split(" ,");
        boolean[] ret = new boolean[aux.length];
        for (int i = 0; i < aux.length; ++i) {
            ret[i] = Boolean.valueOf(aux[i].replaceAll("\\\\,", ","));
        }
        return ret;
    }

    public String[] getStringArrayProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        String value = null;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            value = properties[i].getValue();
            exists = true;
        }
        if (!exists) {
            throw new NotExistInXMLEntity();
        }
        if (value.compareTo("") == 0) {
            return new String[0];
        }
        String[] aux = value.split(" ,");
        for (int i = 0; i < aux.length; ++i) {
            aux[i] = aux[i].replaceAll("\\\\,", ",");
        }
        return aux;
    }

    public boolean getBooleanProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        boolean res = false;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            res = Boolean.valueOf(properties[i].getValue());
            exists = true;
        }
        if (exists) {
            return res;
        }
        throw new NotExistInXMLEntity();
    }

    public int getIntProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        int res = 0;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            res = Integer.parseInt(properties[i].getValue());
            exists = true;
        }
        if (exists) {
            return res;
        }
        throw new NotExistInXMLEntity();
    }

    public long getLongProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        long res = 0L;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            res = Long.valueOf(properties[i].getValue());
            exists = true;
        }
        if (exists) {
            return res;
        }
        throw new NotExistInXMLEntity();
    }

    public float getFloatProperty(String key) {
        Property[] properties = this.xmltag.getProperty();
        float res = 0.0f;
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            res = Float.valueOf(properties[i].getValue()).floatValue();
            exists = true;
        }
        if (exists) {
            return res;
        }
        throw new NotExistInXMLEntity();
    }

    public void setName(String name) {
        Property p = new Property();
        p.setKey("name");
        p.setValue(name);
        this.xmltag.addProperty(p);
    }

    public String getName() {
        Property p = this.getProperty("name");
        return p.getValue();
    }

    public Class getImplementingClass() {
        Property p = this.getProperty("class");
        String ob = p.getValue();
        return (Class)((Object)ob);
    }

    public void addChild(XMLEntity entity) {
        this.xmltag.addXmlTag(entity.getXmlTag());
    }

    public XMLEntity getChild(int i) {
        return new XMLEntity(this.xmltag.getXmlTag(i));
    }

    public int getChildrenCount() {
        return this.xmltag.getXmlTagCount();
    }

    private Property getProperty(String key) {
        Property[] ps = this.xmltag.getProperty();
        for (int i = 0; i < ps.length; ++i) {
            if (ps[i].getKey().compareTo(key) != 0) continue;
            return ps[i];
        }
        return null;
    }

    public XmlTag getXmlTag() {
        return this.xmltag;
    }

    private void putProperty(Property p, boolean matters) {
        if (!matters) {
            this.getWhiteAttrList().add(p.getKey());
        }
        for (int i = 0; i < this.xmltag.getPropertyCount(); ++i) {
            if (this.xmltag.getProperty(i).getKey().compareTo(p.getKey()) != 0) continue;
            this.xmltag.getProperty(i).setValue(p.getValue());
            return;
        }
        this.xmltag.addProperty(p);
    }

    private Vector getWhiteAttrList() {
        if (this.whiteAttrList == null) {
            this.whiteAttrList = new Vector();
        }
        return this.whiteAttrList;
    }

    public boolean contains(String key) {
        Property[] properties = this.xmltag.getProperty();
        boolean exists = false;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            exists = true;
        }
        return exists;
    }

    public int getPropertyCount() {
        return this.xmltag.getPropertyCount();
    }

    public String getPropertyValue(int index) {
        return this.xmltag.getProperty(index).getValue();
    }

    public String getPropertyName(int index) {
        return this.xmltag.getProperty(index).getKey();
    }

    public void remove(String key) {
        Property[] properties = this.xmltag.getProperty();
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getKey().compareTo(key) != 0) continue;
            Property[] newProperties = new Property[properties.length - 1];
            int k = 0;
            for (int j = 0; j < newProperties.length; ++j) {
                if (j == i) {
                    k = 1;
                }
                newProperties[j] = properties[j + k];
            }
            this.xmltag.setProperty(newProperties);
            return;
        }
    }

    public void removeChild(int index) {
        this.xmltag.removeXmlTag(index);
    }

    public void removeAllChildren() {
        this.xmltag.removeAllXmlTag();
    }

    public boolean equals(Object obj) {
        if (obj instanceof XMLEntity) {
            int i;
            Property[] otherProperties;
            XMLEntity other = (XMLEntity)obj;
            Property[] thisProperties = this.xmltag.getProperty();
            if (thisProperties.length != (otherProperties = other.xmltag.getProperty()).length) {
                return false;
            }
            for (i = 0; i < thisProperties.length; ++i) {
                if (!thisProperties[i].getKey().equals(otherProperties[i].getKey())) {
                    return false;
                }
                if (thisProperties[i].getValue().equals(otherProperties[i].getValue())) continue;
                return false;
            }
            if (this.getChildrenCount() != other.getChildrenCount()) {
                return false;
            }
            for (i = 0; i < this.getChildrenCount(); ++i) {
                if (this.getChild(i).equals(other.getChild(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public long hash() {
        int i;
        long result = 17L;
        if (this.xmltag.getName() != null) {
            char[] name = this.xmltag.getName().toCharArray();
            for (i = 0; i < name.length; ++i) {
                result = 37L + result + (long)name[i];
            }
        }
        Property[] properties = this.xmltag.getProperty();
        for (i = 0; i < properties.length; ++i) {
            String strKey = properties[i].getKey();
            if (this.whiteAttrList != null && this.whiteAttrList.contains(strKey)) continue;
            char[] key = strKey.toCharArray();
            for (int j = 0; j < key.length; ++j) {
                result = 37L + result + (long)key[j];
            }
            if (properties[i] != null) {
                String value = properties[i].getValue();
                char[] chars = value != null ? value.toCharArray() : new char[]{};
                for (int j = 0; j < chars.length; ++j) {
                    result = 37L + result + (long)chars[j];
                }
                continue;
            }
            result += 37L;
        }
        for (i = 0; i < this.getChildrenCount(); ++i) {
            result = 37L + result + this.getChild(i).hash();
        }
        return result;
    }

    public XMLEntity firstChild(String key, String value) {
        int num = this.getChildrenCount();
        for (int i = 0; i < num; ++i) {
            XMLEntity child = this.getChild(i);
            try {
                if (!child.getStringProperty(key).equals(value)) continue;
                return child;
            }
            catch (NotExistInXMLEntity notExistInXMLEntity) {
                // empty catch block
            }
        }
        return null;
    }

    public XMLEntity firstChild(String value) {
        int num = this.getChildrenCount();
        for (int i = 0; i < num; ++i) {
            XMLEntity child = this.getChild(i);
            try {
                if (!child.getXmlTag().getName().equals(value)) continue;
                return child;
            }
            catch (NotExistInXMLEntity notExistInXMLEntity) {
                // empty catch block
            }
        }
        return null;
    }

    public int firstIndexOfChild(String key, String value) {
        int num = this.getChildrenCount();
        for (int i = 0; i < num; ++i) {
            try {
                XMLEntity child = this.getChild(i);
                if (!child.getStringProperty(key).equals(value)) continue;
                return i;
            }
            catch (NotExistInXMLEntity notExistInXMLEntity) {
                // empty catch block
            }
        }
        return -1;
    }

    public int firstIndexOfChild(String value) {
        int num = this.getChildrenCount();
        for (int i = 0; i < num; ++i) {
            try {
                XMLEntity child = this.getChild(i);
                if (!child.getXmlTag().getName().equals(value)) continue;
                return i;
            }
            catch (NotExistInXMLEntity notExistInXMLEntity) {
                // empty catch block
            }
        }
        return -1;
    }

    public Iterator findChildren(String key, String value) {
        return new XMLEntityIterator(this, key, value);
    }

    public String toString() {
        Marshaller m;
        StringWriter buffer = new StringWriter();
        try {
            m = new Marshaller((Writer)buffer);
        }
        catch (IOException e4) {
            e4.printStackTrace();
            return null;
        }
        m.setEncoding("ISO-8859-1");
        try {
            m.marshal((Object)this.getXmlTag());
        }
        catch (MarshalException e2) {
            e2.printStackTrace();
            return null;
        }
        catch (ValidationException e3) {
            e3.printStackTrace();
            return null;
        }
        return buffer.toString();
    }

    public static XMLEntity parse(String data) throws MarshalException, ValidationException {
        StringReader reader = new StringReader(data);
        XmlTag tag = (XmlTag)XmlTag.unmarshal(reader);
        return new XMLEntity(tag);
    }
}

