/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gvsig.utils.NotExistInXMLEntity;
import org.gvsig.utils.XMLEntity;

class XMLEntityIterator
implements Iterator {
    private int lastIndex;
    private int lastHasNextIndex;
    private XMLEntity entity;
    private String key;
    private String value;

    public XMLEntityIterator(XMLEntity entity, String key, String value) {
        this.entity = entity;
        this.key = key;
        this.value = value;
        this.lastIndex = -1;
        this.lastHasNextIndex = -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.entity.getChildrenCount() == 0 || this.entity.getChildrenCount() <= this.lastIndex) {
            return false;
        }
        int num = this.entity.getChildrenCount();
        for (int i = this.lastIndex + 1; i < num; ++i) {
            XMLEntity child = this.entity.getChild(i);
            try {
                if (!child.getStringProperty(this.key).equals(this.value)) continue;
                this.lastHasNextIndex = i;
                return true;
            }
            catch (NotExistInXMLEntity notExistInXMLEntity) {
                // empty catch block
            }
        }
        return false;
    }

    public Object next() {
        XMLEntity child;
        if (this.entity.getChildrenCount() == 0 || this.entity.getChildrenCount() <= this.lastIndex) {
            throw new NoSuchElementException();
        }
        if (this.lastHasNextIndex > -1 && this.entity.getChildrenCount() > this.lastHasNextIndex) {
            child = this.entity.getChild(this.lastHasNextIndex);
            try {
                if (child.getStringProperty(this.key).equals(this.value)) {
                    this.lastIndex = this.lastHasNextIndex;
                    this.lastHasNextIndex = -1;
                    return child;
                }
            }
            catch (NotExistInXMLEntity notExistInXMLEntity) {
                // empty catch block
            }
        }
        int num = this.entity.getChildrenCount();
        for (int i = this.lastIndex + 1; i < num; ++i) {
            child = this.entity.getChild(i);
            try {
                if (!child.getStringProperty(this.key).equals(this.value)) continue;
                this.lastIndex = i;
                this.lastHasNextIndex = -1;
                return child;
            }
            catch (NotExistInXMLEntity notExistInXMLEntity) {
                // empty catch block
            }
        }
        this.lastHasNextIndex = -1;
        throw new NoSuchElementException();
    }
}

