/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.console.jedit;

import javax.swing.text.Segment;
import org.gvsig.utils.console.jedit.KeywordMap;
import org.gvsig.utils.console.jedit.TokenMarker;

public class SQLTokenMarker
extends TokenMarker {
    private int offset;
    private int lastOffset;
    private int lastKeyword;
    private int length;
    protected boolean isTSQL = false;
    private KeywordMap keywords;
    private char literalChar = '\u0000';

    public SQLTokenMarker(KeywordMap k) {
        this(k, false);
    }

    public SQLTokenMarker(KeywordMap k, boolean tsql) {
        this.keywords = k;
        this.isTSQL = tsql;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        this.lastOffset = this.lastKeyword = line.offset;
        this.offset = this.lastKeyword;
        this.length = line.count + this.offset;
        block13: for (int i = this.offset; i < this.length; ++i) {
            switch (line.array[i]) {
                case '*': {
                    if (token == 1 && this.length - i >= 1 && line.array[i + 1] == '/') {
                        token = 0;
                        this.addToken(++i + 1 - this.lastOffset, (byte)1);
                        this.lastOffset = i + 1;
                        break;
                    }
                    if (token != 0) break;
                    this.searchBack(line, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '[': {
                    if (token != 0) break;
                    this.searchBack(line, i);
                    token = (byte)3;
                    this.literalChar = (char)91;
                    this.lastOffset = i;
                    break;
                }
                case ']': {
                    if (token != 3 || this.literalChar != '[') break;
                    token = 0;
                    this.literalChar = '\u0000';
                    this.addToken(i + 1 - this.lastOffset, (byte)3);
                    this.lastOffset = i + 1;
                    break;
                }
                case '(': 
                case ')': 
                case ',': 
                case '.': {
                    if (token != 0) break;
                    this.searchBack(line, i);
                    this.addToken(1, (byte)0);
                    this.lastOffset = i + 1;
                    break;
                }
                case '%': 
                case '&': 
                case '+': 
                case '<': 
                case '=': 
                case '>': 
                case '^': 
                case '|': 
                case '~': {
                    if (token != 0) break;
                    this.searchBack(line, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (token != 0) break;
                    this.searchBack(line, i, false);
                    break;
                }
                case ':': {
                    if (token != 0) break;
                    this.addToken(i + 1 - this.lastOffset, (byte)5);
                    this.lastOffset = i + 1;
                    break;
                }
                case '/': {
                    if (token != 0) break;
                    if (this.length - i >= 2 && line.array[i + 1] == '*') {
                        this.searchBack(line, i);
                        token = 1;
                        this.lastOffset = i++;
                        break;
                    }
                    this.searchBack(line, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '-': {
                    if (token != 0) break;
                    if (this.length - i >= 2 && line.array[i + 1] == '-') {
                        this.searchBack(line, i);
                        this.addToken(this.length - i, (byte)1);
                        this.lastOffset = this.length;
                        break block13;
                    }
                    this.searchBack(line, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '!': {
                    if (!this.isTSQL || token != 0 || this.length - i < 2 || line.array[i + 1] != '=' && line.array[i + 1] != '<' && line.array[i + 1] != '>') break;
                    this.searchBack(line, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '\"': 
                case '\'': {
                    if (token == 0) {
                        token = (byte)3;
                        this.literalChar = line.array[i];
                        this.addToken(i - this.lastOffset, (byte)0);
                        this.lastOffset = i;
                        break;
                    }
                    if (token != 3 || this.literalChar != line.array[i]) break;
                    token = 0;
                    this.literalChar = '\u0000';
                    this.addToken(i + 1 - this.lastOffset, (byte)3);
                    this.lastOffset = i + 1;
                }
            }
        }
        if (token == 0) {
            this.searchBack(line, this.length, false);
        }
        if (this.lastOffset != this.length) {
            this.addToken(this.length - this.lastOffset, token);
        }
        return token;
    }

    private void searchBack(Segment line, int pos) {
        this.searchBack(line, pos, true);
    }

    private void searchBack(Segment line, int pos, boolean padNull) {
        int len = pos - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = pos;
        }
        this.lastKeyword = pos + 1;
        if (padNull && this.lastOffset < pos) {
            this.addToken(pos - this.lastOffset, (byte)0);
        }
    }
}

