/*
 * Decompiled with CFR 0.152.
 */
package org.amic.broker;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;
import org.amic.util.url.URLConnect;
import org.amic.util.xml.DBExport;
import org.amic.util.xml.DBImport;
import org.amic.util.xml.DBTable;
import org.amic.util.xml.TablePacked;
import org.xml.sax.SAXException;

public class XmlBroker {
    private DBTable table = null;
    static int countReq = 0;

    public XmlBroker(String url, String params) throws SAXException, ParserConfigurationException, IOException {
        this(new URLConnect(url, params).getInputStream());
    }

    public XmlBroker(String url) throws SAXException, ParserConfigurationException, IOException {
        this(new URLConnect(url).getInputStream());
    }

    public XmlBroker(URL url) throws SAXException, ParserConfigurationException, IOException {
        this(new URLConnect(url).getInputStream());
    }

    public XmlBroker(InputStream is) throws SAXException, ParserConfigurationException, IOException {
        this(is, false);
    }

    public XmlBroker(InputStream is, boolean restoreTypes) throws SAXException, ParserConfigurationException, IOException {
        this.table = new DBTable();
        new DBImport(is).setTableData(this.table, restoreTypes);
    }

    public XmlBroker(ResultSet rs) throws SQLException, ParserConfigurationException, SAXException, IOException {
        this.table = new DBTable();
        DBExport dbExport = new DBExport(this.table.getIdentifier());
        dbExport.setData(rs);
        new DBImport(new ByteArrayInputStream(dbExport.getDocument().getBytes())).setTableData(this.table);
    }

    public XmlBroker(TablePacked tp) throws ParserConfigurationException, SAXException, IOException {
        this((DBTable)tp);
    }

    public XmlBroker(DBTable tp) throws ParserConfigurationException, SAXException, IOException {
        this.table = tp;
    }

    public DBTable getTable() {
        return this.table;
    }

    public String getXML() throws ParserConfigurationException {
        DBExport dbExport = new DBExport(this.table.getIdentifier());
        dbExport.setData(this.table);
        return dbExport.getDocument();
    }

    public String sendResults(URL url, boolean onlyModified) throws ParserConfigurationException {
        DBExport dbExport = new DBExport(this.table.getIdentifier(), onlyModified);
        dbExport.setData(this.table);
        URLConnect uc = new URLConnect(url);
        uc.setMethod("POST");
        uc.setParams(dbExport.getDocument(), false);
        return uc.getContent();
    }

    public String sendResults(String url, boolean onlyModified) throws ParserConfigurationException, MalformedURLException {
        return this.sendResults(new URL(url), onlyModified);
    }

    public String sendResults(URL url) throws ParserConfigurationException {
        return this.sendResults(url, false);
    }

    public String sendResults(String url) throws ParserConfigurationException, MalformedURLException {
        return this.sendResults(new URL(url), false);
    }
}

