/*
 * Decompiled with CFR 0.152.
 */
package org.amic.desktop;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.amic.desktop.ContainedPanel;
import org.amic.desktop.Desktop;
import org.amic.util.icons.Icons;

public abstract class DefaultContainedPanel
extends JPanel
implements ContainedPanel {
    private Icon icon = null;
    private Desktop desktop;
    private Component frame;

    public boolean canClose() {
        return true;
    }

    public JComponent getJComponent() {
        return this;
    }

    public void willShow() {
    }

    public void setDesktop(Desktop desktop) {
        this.desktop = desktop;
    }

    public abstract void update();

    public boolean isUpdating() {
        return false;
    }

    public abstract String getTitle();

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = Icons.getIcon(this.getClass(), "/org/amic/images/explorer.gif");
        }
        return this.icon;
    }

    public String getTabTitle() {
        String title = this.getTitle();
        if (title.length() > 18) {
            return title.substring(0, 15) + "...";
        }
        return title;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Desktop getDesktop() {
        return this.desktop;
    }

    public void putGlobalData(String key, Object value) {
        this.desktop.putGlobalData(key, value);
    }

    public Object getGlobalData(String key) {
        return this.desktop.getGlobalData(key);
    }

    public void addGlobalDataListener(String key, PropertyChangeListener listener) {
        this.desktop.addGlobalDataListener(key, listener);
    }

    public void removeGlobalDataListener(String key, PropertyChangeListener listener) {
        this.desktop.removeGlobalDataListener(key, listener);
    }

    public void removeGlobalDataListener(PropertyChangeListener listener) {
        this.desktop.removeGlobalDataListener(listener);
    }

    public Component getFrame() {
        return this.frame;
    }

    public void setFrame(Component frame) {
        this.frame = frame;
    }

    public Popup getPopup(Component contents, int x, int y) {
        return PopupFactory.getSharedInstance().getPopup(this.frame, contents, x, y);
    }
}

