/*
 * Decompiled with CFR 0.152.
 */
package org.amic.properties;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.amic.util.string.ClassFormatter;

public class PropertiesTableModel
extends AbstractTableModel {
    private Vector model = new Vector();
    static /* synthetic */ Class class$java$lang$String;

    public PropertiesTableModel() {
    }

    public PropertiesTableModel(Object[][] properties) {
        this();
        int y = 0;
        while (y < properties.length) {
            this.addRow((String)properties[y][0], properties[y][1]);
            ++y;
        }
    }

    public PropertiesTableModel(Properties properties) {
        this();
        Enumeration<?> props = properties.propertyNames();
        while (props.hasMoreElements()) {
            String key = (String)props.nextElement();
            this.addRow(key, properties.getProperty(key));
        }
    }

    public Property addRow(String rowName, Object value) {
        Property prop = new Property(this, rowName, value);
        this.model.addElement(prop);
        return prop;
    }

    public void addValidValue(String rowName, Object value) {
        Property prop = this.getRowByName(rowName);
        if (prop != null) {
            prop.addValid(value);
        }
    }

    public void setFormat(String rowName, String format) {
        Property prop = this.getRowByName(rowName);
        if (prop != null) {
            prop.format = format;
        }
    }

    public void setLabel(String rowName, String label) {
        Property prop = this.getRowByName(rowName);
        if (prop != null) {
            prop.label = label;
        }
    }

    public void setJClass(String rowName, Class jClass) {
        Property prop = this.getRowByName(rowName);
        if (prop != null) {
            prop.jClass = jClass;
        }
    }

    public void setEditable(String rowName, boolean editable) {
        Property prop = this.getRowByName(rowName);
        if (prop != null) {
            prop.editable = editable;
        }
    }

    public void setValue(String rowName, String value) {
        block2: {
            Property prop = this.getRowByName(rowName);
            if (prop == null) break block2;
            try {
                prop.value = prop.format == null ? ClassFormatter.parse(value, prop.jClass) : ClassFormatter.parse(value, prop.jClass, prop.format);
            }
            catch (Exception ex) {
                prop.value = null;
            }
        }
    }

    public Property getRowByName(String rowName) {
        int i = 0;
        while (i < this.model.size()) {
            Property prop = this.getRowByIndex(i);
            if (prop != null && prop.name.equalsIgnoreCase(rowName)) {
                return prop;
            }
            ++i;
        }
        return null;
    }

    public Property getRowByIndex(int index) {
        if (index < 0 || index >= this.model.size()) {
            return null;
        }
        return (Property)this.model.elementAt(index);
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.model.size()) {
            return null;
        }
        if (col == 0) {
            return ((Property)this.model.get((int)row)).label;
        }
        if (col == 1) {
            return ((Property)this.model.get((int)row)).value;
        }
        return null;
    }

    public int getRowCount() {
        return this.model.size();
    }

    public boolean isCellEditable(int row, int col) {
        Property prop = this.getRowByIndex(row);
        return col == 1 && (prop.editable || prop.validCount() > 0);
    }

    public void setValueAt(Object value, int row, int col) {
        if (row < 0 || row >= this.model.size() || col == 0) {
            return;
        }
        ((Property)this.model.get((int)row)).value = value;
        this.fireRowHasChanged(row);
    }

    public void fireRowHasChanged(int row) {
        this.fireTableChanged(new TableModelEvent(this, row));
    }

    public void clearModel() {
        this.model = new Vector();
        this.fireTableChanged(new TableModelEvent(this));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Property {
        public String name;
        public String label;
        public String format;
        public Object value;
        public Class jClass;
        public Vector valids;
        public boolean editable;
        private final /* synthetic */ PropertiesTableModel this$0;

        public Property(PropertiesTableModel this$0, Object name, Object value) {
            Class clazz = value == null ? (class$java$lang$String == null ? (class$java$lang$String = PropertiesTableModel.class$("java.lang.String")) : class$java$lang$String) : value.getClass();
            this(this$0, name, value, clazz);
        }

        public Property(PropertiesTableModel this$0, Object name, Object value, Class jClass) {
            this.this$0 = this$0;
            this.editable = true;
            this.label = this.name = name.toString();
            this.value = value;
            this.format = null;
            this.jClass = jClass;
            this.valids = new Vector();
        }

        public void addValid(Object value) {
            this.valids.addElement(value);
        }

        public int validCount() {
            return this.valids.size();
        }

        public Vector getValids() {
            return this.valids;
        }

        public Object[] stripBooleanFormat() {
            Object[] obj = new Object[2];
            if (this.format == null) {
                obj[0] = "false";
                obj[1] = "true";
            } else {
                int p = this.format.indexOf(59);
                obj[0] = this.format.substring(0, p);
                obj[1] = this.format.substring(p + 1);
            }
            return obj;
        }
    }
}

