/*
 * Decompiled with CFR 0.152.
 */
package org.amic.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.amic.swing.PopupComponent;

public class JPopupField
extends JTextField
implements KeyListener {
    private Popup popup = null;
    private Component frame = null;
    private PopupComponent contents = null;
    private boolean internal = false;
    private boolean popupVisible = false;
    private Timer timer = null;

    public JPopupField(Component frame) {
        this.frame = frame;
    }

    public void setContent(PopupComponent popupContent) {
        this.contents = popupContent;
        final JPopupField jpf = this;
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent evt) {
            }

            public void ancestorMoved(AncestorEvent evt) {
                if (JPopupField.this.frame == evt.getAncestor()) {
                    JPopupField.this.closePopup();
                }
            }

            public void ancestorRemoved(AncestorEvent evt) {
                if (jpf == evt.getAncestor()) {
                    JPopupField.this.closePopup();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                if (evt.getOppositeComponent() != JPopupField.this.contents.getComponent()) {
                    JPopupField.this.closePopup();
                }
            }
        });
        this.addKeyListener(this);
    }

    protected Document createDefaultModel() {
        return new PopupDocument(this);
    }

    public void showPopup(int timeWait) {
        if (!this.isShowing() || this.internal || !this.popupVisible) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (timeWait == 0) {
            this.initPopup();
        } else {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                public void run() {
                    JPopupField.this.initPopup();
                }
            }, timeWait);
        }
    }

    public void initPopup() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPopupField.this.closePopup();
                if (JPopupField.this.contents.initiatePopup(JPopupField.this.getText())) {
                    JPopupField.this.createPopup();
                }
            }
        });
    }

    private void createPopup() {
        final JPopupField jpf = this;
        this.contents.getComponent().addKeyListener(this);
        this.contents.getComponent().addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                if (evt.getOppositeComponent() != jpf) {
                    JPopupField.this.closePopup();
                }
            }
        });
        Point p = new Point(0, this.getHeight());
        SwingUtilities.convertPointToScreen(p, jpf);
        this.popup = PopupFactory.getSharedInstance().getPopup(this.frame, this.contents.getFrame(), p.x, p.y);
        if (this.isShowing() && this.popupVisible) {
            this.popup.show();
            this.requestFocus();
        } else {
            this.closePopup();
        }
    }

    public void closePopup() {
        if (this.popup != null) {
            this.popup.hide();
            if (this.frame != null) {
                this.frame.invalidate();
            }
            if (this.contents != null) {
                this.contents.finalizePopup();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JPopupField.this.requestFocus();
                }
            });
        }
        this.popup = null;
    }

    public void setPopupVisible(boolean value) {
        this.popupVisible = value;
        if (!this.popupVisible) {
            this.closePopup();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void keyPressed(KeyEvent e) {
        if (e.getSource() instanceof JPopupField) {
            if (e.getKeyCode() == 40 && this.popup != null) {
                this.internal = true;
                this.contents.setPopupText(this.getText());
                this.contents.getComponent().requestFocus();
                this.internal = false;
                e.consume();
                return;
            }
            if (e.getKeyCode() == 32) {
                if ((e.getModifiers() & 2) != 0) {
                    this.showPopup(0);
                    return;
                }
            }
            if (e.getKeyCode() != 27) return;
            this.closePopup();
            return;
        }
        if (e.getKeyCode() == 27) {
            this.closePopup();
            return;
        }
        if (e.getKeyCode() != 10) return;
        this.internal = true;
        this.setText(this.contents.getPopupText());
        this.internal = false;
        this.closePopup();
        e.consume();
    }

    public void keyTyped(KeyEvent e) {
    }

    public class PopupDocument
    extends PlainDocument {
        private JPopupField jpf = null;

        public PopupDocument(JPopupField jpf) {
            this.jpf = jpf;
        }

        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            super.insertString(offset, str, a);
            if (this.jpf != null) {
                this.jpf.showPopup(500);
            }
        }

        public void remove(int offset, int len) throws BadLocationException {
            super.remove(offset, len);
            if (this.jpf != null) {
                this.jpf.showPopup(500);
            }
        }
    }
}

