/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.date;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.amic.util.date.CheckDate;

public class TimeClient {
    private TimeClient() {
    }

    private static String getTimeString(String server, int port) {
        if (port < 1) {
            port = 13;
        }
        InetSocketAddress socketaddress = new InetSocketAddress(server, port);
        String thetime = null;
        Socket time = new Socket();
        try {
            time.setSoTimeout(2000);
            StringBuffer sb = new StringBuffer();
            time.connect(socketaddress, 5000);
            BufferedReader br = new BufferedReader(new InputStreamReader(time.getInputStream()));
            while ((thetime = br.readLine()) != null) {
                sb.append(thetime);
            }
            thetime = sb.toString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return thetime;
    }

    public static Date getDate() {
        return TimeClient.getDate(0);
    }

    public static Date getDate(int diffHour) {
        return TimeClient.getDate("time-a.nist.gov", 13, diffHour);
    }

    public static Date getDate(String server, int port, int diffHour) {
        Pattern p = Pattern.compile("([0-9]{2})-([0-9]{2})-([0-9]{2}) ([0-9]{2}):([0-9]{2}):([0-9]{2})");
        String date = TimeClient.getTimeString(server, port);
        Matcher m = p.matcher(date);
        CheckDate d = new CheckDate();
        d.setDay(1);
        if (m.find()) {
            d.setDate(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), Integer.parseInt(m.group(4)) + diffHour, Integer.parseInt(m.group(5)), Integer.parseInt(m.group(6)));
            return d.getDate();
        }
        return null;
    }
}

