/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.db;

import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.amic.util.date.CheckDate;

public class Converter {
    private Object value;

    public Converter() {
        this.value = null;
    }

    public Converter(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Class getValueClass() {
        return this.value.getClass();
    }

    public boolean getBoolean() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        if (this.value instanceof String) {
            return Boolean.getBoolean((String)this.value);
        }
        return false;
    }

    public byte getByte() {
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).byteValue();
        }
        if (this.value instanceof String) {
            return Byte.parseByte((String)this.value);
        }
        return 0;
    }

    public short getShort() {
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).shortValue();
        }
        if (this.value instanceof String) {
            return Short.parseShort((String)this.value);
        }
        return 0;
    }

    public int getInt() {
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        if (this.value instanceof String) {
            return Integer.parseInt((String)this.value);
        }
        return 0;
    }

    public long getLong() {
        if (this.value == null) {
            return 0L;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        if (this.value instanceof String) {
            return Long.parseLong((String)this.value);
        }
        return 0L;
    }

    public float getFloat() {
        if (this.value == null) {
            return 0.0f;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).floatValue();
        }
        if (this.value instanceof String) {
            return Float.parseFloat((String)this.value);
        }
        return 0.0f;
    }

    public double getDouble() {
        if (this.value == null) {
            return 0.0;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        if (this.value instanceof String) {
            return Double.parseDouble((String)this.value);
        }
        return 0.0;
    }

    public Date getDate() {
        if (this.value instanceof Date) {
            return (Date)this.value;
        }
        if (this.value instanceof String) {
            return new CheckDate().setUniversalDate((String)this.value).getDate();
        }
        return null;
    }

    public java.sql.Date getSqlDate() {
        if (this.value instanceof Date) {
            return new java.sql.Date(((Date)this.value).getTime());
        }
        return null;
    }

    public Time getSqlTime() {
        if (this.value instanceof Date) {
            return new Time(((Date)this.value).getTime());
        }
        return null;
    }

    public Timestamp getSqlTimestamp() {
        if (this.value instanceof Date) {
            return new Timestamp(((Date)this.value).getTime());
        }
        return null;
    }

    public String getString() {
        if (this.value == null) {
            return "";
        }
        if (this.value instanceof Date) {
            return new CheckDate((Date)this.value).getUniversalDate();
        }
        return this.value.toString();
    }

    public String format(String pattern) {
        if (this.value == null) {
            return "";
        }
        if (this.value instanceof Date) {
            return new SimpleDateFormat(pattern).format(this.value);
        }
        if (this.value instanceof Number) {
            return new DecimalFormat(pattern).format(this.value);
        }
        return this.value.toString();
    }

    public Converter setValue(Object value) {
        this.value = value;
        return this;
    }

    public Converter setBoolean(boolean value) {
        this.value = new Boolean(value);
        return this;
    }

    public Converter setByte(byte value) {
        this.value = new Byte(value);
        return this;
    }

    public Converter setShort(short value) {
        this.value = new Short(value);
        return this;
    }

    public Converter setInteger(int value) {
        this.value = new Integer(value);
        return this;
    }

    public Converter setLong(long value) {
        this.value = new Long(value);
        return this;
    }

    public Converter setFloat(float value) {
        this.value = new Float(value);
        return this;
    }

    public Converter setDouble(double value) {
        this.value = new Double(value);
        return this;
    }

    public Converter setDate(Date value) {
        this.value = value;
        return this;
    }

    public Converter setSqlDate(java.sql.Date value) {
        this.value = new Date(value.getTime());
        return this;
    }

    public Converter setSqlTime(Time value) {
        this.value = new Date(value.getTime());
        return this;
    }

    public Converter setSqlTimestamp(Timestamp value) {
        this.value = new Date(value.getTime());
        return this;
    }

    public Converter setString(String value) {
        this.value = this.value != null ? (this.value instanceof Date ? new CheckDate().setUniversalDate(value).getDate() : (this.value instanceof Boolean ? new Boolean(value) : (this.value instanceof Byte ? new Byte(value) : (this.value instanceof Short ? new Short(value) : (this.value instanceof Integer ? new Integer(value) : (this.value instanceof Long ? new Long(value) : (this.value instanceof Float ? new Float(value) : (this.value instanceof Double ? new Double(value) : value)))))))) : value;
        return this;
    }

    public Converter setString(String value, String pattern) throws ParseException {
        if (value == null || value.trim().length() == 0) {
            this.value = null;
        } else if (this.value instanceof Date) {
            this.value = new SimpleDateFormat(pattern).parse(value);
        } else if (this.value instanceof Number) {
            this.value = new DecimalFormat(pattern).parse(value);
        } else {
            this.setString(value);
        }
        return this;
    }

    public Converter setString(Object value, int sqlType) {
        this.value = value;
        return this;
    }

    public Converter setString(String value, int sqlType) {
        if (value == null || value.trim().length() == 0) {
            this.value = null;
        } else {
            switch (sqlType) {
                case -5: {
                    this.value = new BigInteger(value);
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    this.value = new Integer(value);
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    this.value = new Double(value);
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.value = value;
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    this.value = new Converter(new Date()).setString(value).getDate();
                    break;
                }
                case -7: 
                case 16: {
                    this.value = new Boolean(value);
                }
            }
        }
        return this;
    }

    public Converter setType(int sqlType) {
        switch (sqlType) {
            case -5: {
                this.value = new BigInteger("0");
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                this.value = new Integer(0);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                this.value = new Double(0.0);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.value = new String();
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                this.value = new Date();
                break;
            }
            case -7: 
            case 16: {
                this.value = new Boolean(false);
            }
        }
        return this;
    }
}

