/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.edit;

import javax.swing.JTextField;
import javax.swing.text.Document;
import org.amic.util.edit.FormattedDocument;
import org.amic.util.string.ClassFormatter;

public class JFormattedTextField
extends JTextField {
    private Class jClass;
    private String format;

    protected Document createDefaultModel() {
        return new FormattedDocument();
    }

    public void setFormatterOptions(Class jClass, String format) {
        this.jClass = jClass;
        this.format = format;
    }

    public String getText() {
        String result = super.getText();
        if (this.jClass != null) {
            result = this.format != null ? ClassFormatter.format(result, this.jClass, this.format) : ClassFormatter.format(result, this.jClass);
        }
        return result;
    }

    public void setText(String value) {
        if (value == null) {
            super.setText(value);
            return;
        }
        if (this.jClass != null) {
            if (this.format != null) {
                super.setText(ClassFormatter.format(value, this.jClass, this.format));
            } else {
                super.setText(ClassFormatter.format(value, this.jClass));
            }
        } else {
            super.setText(value);
        }
    }
}

